/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.beans.model.BeanTreeComparator;
import com.spacekiller.util.beans.model.BeanTreeModel;
import java.beans.beancontext.BeanContext;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class DefaultBeanTreeComparator
implements BeanTreeComparator {
    private Comparator rootComparator;
    private Map classComparators = new HashMap();
    private boolean useSuperClasses = true;

    public void addClassComparatorDefinition(Class type, ClassComparatorDefinition def) {
        this.classComparators.put(type, def);
    }

    public void getClassComparatorClasses(Collection dstClasses) {
        dstClasses.addAll(this.classComparators.keySet());
    }

    public ClassComparatorDefinition getClassComparatorDefinition(Class clazz) {
        return (ClassComparatorDefinition)this.classComparators.get(clazz);
    }

    @Override
    public Comparator getComparator(BeanTreeModel model, BeanContext bc) {
        BeanContext parent;
        if (bc == model.getRootBean()) {
            return this.rootComparator;
        }
        for (Class<?> clazz = bc.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            ClassComparatorDefinition def = this.getClassComparatorDefinition(clazz);
            if (def != null) {
                return def.getComparator(model, bc);
            }
            if (!this.useSuperClasses) break;
        }
        if ((parent = bc.getBeanContext()) != null) {
            return this.getComparator(model, parent);
        }
        return this.rootComparator;
    }

    public Comparator getRootComparator() {
        return this.rootComparator;
    }

    public boolean isUseSuperClasses() {
        return this.useSuperClasses;
    }

    public void removeClassComparatorDefinition(Class type) {
        this.classComparators.remove(type);
    }

    public void removeClassComparatorDefinition(Class type, ClassComparatorDefinition def) {
        if (this.getClassComparatorDefinition(type) == def) {
            this.classComparators.remove(type);
        }
    }

    public void setRootComparator(Comparator newRootComparator) {
        this.rootComparator = newRootComparator;
    }

    public void setUseSuperClasses(boolean newUseSuperClasses) {
        this.useSuperClasses = newUseSuperClasses;
    }

    public class ClassComparatorDefinition {
        private Comparator comparator;
        private boolean useParentContext;

        public ClassComparatorDefinition() {
            this.comparator = null;
            this.useParentContext = true;
        }

        public ClassComparatorDefinition(Comparator comparator) {
            this.comparator = comparator;
            this.useParentContext = false;
        }

        public Comparator getComparator(BeanTreeModel model, BeanContext context) {
            if (this.useParentContext) {
                BeanContext parentContext = context.getBeanContext();
                return parentContext == null ? DefaultBeanTreeComparator.this.getRootComparator() : this.getComparator(model, parentContext);
            }
            return this.comparator;
        }
    }
}

