/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.model.AbstractBeanTreeBranchNode;
import com.spacekiller.util.beans.model.AbstractBeanTreeModel;
import com.spacekiller.util.beans.model.BeanTreeComparator;
import com.spacekiller.util.beans.model.BeanTreeNode;
import com.spacekiller.util.beans.model.BeanTreeRootNode;
import com.spacekiller.util.beans.model.DefaultBeanTreeNode;
import com.spacekiller.util.beans.model.TreeModelTrace;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultBeanTreeModel
extends AbstractBeanTreeModel
implements BeanContextMembershipListener {
    private Object rootBean = null;
    private Hashtable contexts = new Hashtable();
    private BeanTreeComparator beanTreeComparator;
    private static final Logger logger = Logger.getLogger(DefaultBeanTreeModel.class.getName());

    public DefaultBeanTreeModel(BeansToolkit tk, FeatureDescriptorFilter newFeatureFilter) {
        super(tk, newFeatureFilter);
        this.addTreeModelListener(new TreeModelTrace());
    }

    private void invokeSync(Runnable run) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(run);
            } else {
                SwingUtilities.invokeAndWait(run);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void childrenAdded(final BeanContextMembershipEvent bcme) {
        try {
            this.invokeSync(new Runnable(){

                @Override
                public void run() {
                    DefaultBeanTreeModel.this.childrenAddedSync(bcme);
                }
            });
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void childrenAddedSync(BeanContextMembershipEvent bcme) {
        int count;
        BeanContext beanContext = bcme.getBeanContext();
        if (beanContext == null) {
            return;
        }
        BeanTreeNode btn = this.getContextNode(beanContext);
        if (btn == null) {
            logger.fine("DEBUG: No ContextNode found for BeanContext: " + beanContext);
            return;
        }
        if (!(btn instanceof AbstractBeanTreeBranchNode)) {
            throw new IllegalArgumentException("Invalid argument: " + btn);
        }
        AbstractBeanTreeBranchNode node = (AbstractBeanTreeBranchNode)btn;
        BeanContext context = (BeanContext)node.getBean();
        if (!node.isLoaded()) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
            return;
        }
        Object[] beans = bcme.toArray();
        int n = count = beans == null ? 0 : beans.length;
        if (count < 1) {
            return;
        }
        int[] childIndices = new int[count];
        Object[] children = new Object[count];
        Comparator comparator = this.getChildComparator(context);
        for (int c = 0; c < count; ++c) {
            int index = comparator == null ? node.getChildCount() : this.getNodeInsertIndex(node, beans[c], comparator);
            BeanTreeNode childNode = this.createBeanTreeNode(beans[c]);
            node.insertChildNodeAt(childNode, index);
            childIndices[c] = index;
            children[c] = childNode;
        }
        Object[] path = this.getPathToRoot(node);
        if (beanContext == this.rootBean && node.getChildCount() == count) {
            this.fireTreeStructureChanged(this, path, null, null);
        } else {
            this.fireTreeNodesInserted(this, path, childIndices, children);
        }
    }

    @Override
    public void childrenRemoved(final BeanContextMembershipEvent bcme) {
        this.invokeSync(new Runnable(){

            @Override
            public void run() {
                DefaultBeanTreeModel.this.childrenRemovedSync(bcme);
            }
        });
    }

    protected void childrenRemovedSync(BeanContextMembershipEvent bcme) {
        int i;
        int count;
        BeanContext beanContext = bcme.getBeanContext();
        if (beanContext == null) {
            return;
        }
        BeanTreeNode btn = this.getContextNode(beanContext);
        if (btn == null) {
            logger.fine("OOPS ==> No ContextNode found for BeanContext: " + beanContext);
            return;
        }
        if (!(btn instanceof AbstractBeanTreeBranchNode)) {
            throw new IllegalArgumentException("Invalid argument: " + btn);
        }
        AbstractBeanTreeBranchNode node = (AbstractBeanTreeBranchNode)btn;
        if (!node.isLoaded()) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
            return;
        }
        Object[] beans = bcme.toArray();
        int n = count = beans == null ? 0 : beans.length;
        if (count < 1) {
            return;
        }
        int[] childIndices = new int[count];
        Object[] children = new Object[count];
        int notFound = 0;
        for (int c = 0; c < count; ++c) {
            Object bean = beans[c];
            childIndices[c] = i = node.getChildIndexOfBean(bean);
            if (i < 0) {
                ++notFound;
                continue;
            }
            children[c] = node.getChildAt(i);
            node.removeChildNodeAt(i);
            if (!(bean instanceof BeanContext)) continue;
            this.uninstallBeanContextMembershipListener((BeanContext)bean);
        }
        if (notFound > 0) {
            int found = count - notFound;
            int[] foundChildIndices = new int[found];
            Object[] foundChildren = new Object[found];
            int index = 0;
            for (int c = 0; c < count; ++c) {
                i = childIndices[c];
                if (i < 0) continue;
                foundChildIndices[index] = i;
                foundChildren[index] = children[c];
                ++index;
            }
            if (index != found) {
                throw new RuntimeException("Internal error: " + index + " != " + found);
            }
            childIndices = foundChildIndices;
            children = foundChildren;
        }
        Object[] path = this.getPathToRoot(node);
        this.fireTreeNodesRemoved(this, path, childIndices, children);
    }

    @Override
    protected BeanTreeNode createBeanTreeNode(Object bean) {
        if (bean != null && bean instanceof BeanContext) {
            BeanContext context = (BeanContext)bean;
            BeanDescriptor descr = new BeanDescriptor(context.getClass());
            descr.setDisplayName(this.getDisplayName(context));
            DefaultBeanTreeNode node = new DefaultBeanTreeNode(context, descr);
            this.installBeanContextMembershipListener(node);
            return node;
        }
        BeansToolkit tk = this.getToolkit();
        DefaultBeanTreeNode rc = new DefaultBeanTreeNode();
        BeanDescriptor feature = null;
        if (bean != null) {
            try {
                BeanInfo info = tk.getBeanInfo(bean.getClass());
                if (info != null) {
                    feature = info.getBeanDescriptor();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        rc.setBean(bean);
        rc.setFeatureDescriptor(feature);
        return rc;
    }

    @Override
    protected Enumeration createChildNodes(Object bean, FeatureDescriptor feature, boolean onlyCheckLeaf) {
        if (bean != null && bean instanceof BeanContext) {
            return this.createChildNodes_BeanContext((BeanContext)bean, feature, onlyCheckLeaf);
        }
        if (feature instanceof BeanDescriptor) {
            return this.createChildNodes_BeanDescriptor(bean, (BeanDescriptor)feature, onlyCheckLeaf);
        }
        if (feature instanceof PropertyDescriptor) {
            return this.createChildNodes_PropertyDescriptor(bean, (PropertyDescriptor)feature, onlyCheckLeaf);
        }
        return null;
    }

    protected Enumeration createChildNodes_BeanContext(BeanContext ctx, FeatureDescriptor feature, boolean onlyCheckLeaf) {
        if (onlyCheckLeaf) {
            if (ctx.isEmpty()) {
                return AbstractBeanTreeModel.LEAF_ENUMERATION;
            }
            return AbstractBeanTreeModel.NONLEAF_ENUMERATION;
        }
        Vector<BeanTreeNode> rc = new Vector<BeanTreeNode>();
        Object[] o = ctx.toArray();
        if (o != null) {
            Comparator comparator = this.getChildComparator(ctx);
            if (comparator != null) {
                Arrays.sort(o, comparator);
            }
            int num = o.length;
            for (int c = 0; c < num; ++c) {
                if (o[c] == null) continue;
                try {
                    rc.add(this.createBeanTreeNode(o[c]));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return rc.elements();
    }

    protected Enumeration createChildNodes_BeanDescriptor(Object bean, BeanDescriptor feature, boolean onlyCheckLeaf) {
        if (bean == null) {
            return LEAF_ENUMERATION;
        }
        BeansToolkit tk = this.getToolkit();
        int total = 0;
        Vector<BeanTreeNode> rc = new Vector<BeanTreeNode>();
        try {
            BeanInfo info = tk.getBeanInfo(bean.getClass());
            if (info != null) {
                EventSetDescriptor[] events;
                MethodDescriptor[] meths;
                FeatureDescriptorFilter filter = this.getFeatureFilter();
                PropertyDescriptor[] props = info.getPropertyDescriptors();
                if (props != null) {
                    int num = props.length;
                    for (int c = 0; c < num; ++c) {
                        if (filter != null && !filter.accept(info, (FeatureDescriptor)props[c])) continue;
                        if (onlyCheckLeaf) {
                            ++total;
                            continue;
                        }
                        rc.add(this.createFeatureTreeNode(bean, props[c]));
                    }
                }
                if ((meths = info.getMethodDescriptors()) != null) {
                    int num = meths.length;
                    for (int c = 0; c < num; ++c) {
                        if (filter != null && !filter.accept(info, (FeatureDescriptor)meths[c])) continue;
                        if (onlyCheckLeaf) {
                            ++total;
                            continue;
                        }
                        rc.add(this.createFeatureTreeNode(bean, meths[c]));
                    }
                }
                if ((events = info.getEventSetDescriptors()) != null) {
                    int num = events.length;
                    for (int c = 0; c < num; ++c) {
                        if (filter != null && !filter.accept(info, (FeatureDescriptor)events[c])) continue;
                        if (onlyCheckLeaf) {
                            ++total;
                            continue;
                        }
                        rc.add(this.createFeatureTreeNode(bean, events[c]));
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (onlyCheckLeaf) {
            return total < 1 ? LEAF_ENUMERATION : NONLEAF_ENUMERATION;
        }
        return rc.elements();
    }

    protected Enumeration createChildNodes_PropertyDescriptor(Object bean, PropertyDescriptor feature, boolean onlyCheckLeaf) {
        PropertyDescriptor propertyDescr = feature;
        if (bean == null) {
            return LEAF_ENUMERATION;
        }
        BeansToolkit tk = this.getToolkit();
        try {
            Object propertyValue = tk.getValue(propertyDescr, bean);
            if (propertyValue != null) {
                BeanInfo info = tk.getBeanInfo(propertyValue.getClass());
                return this.createChildNodes(propertyValue, info.getBeanDescriptor(), onlyCheckLeaf);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return LEAF_ENUMERATION;
    }

    protected BeanTreeNode createFeatureTreeNode(Object bean, FeatureDescriptor descr) {
        DefaultBeanTreeNode node = new DefaultBeanTreeNode(bean, descr);
        return node;
    }

    @Override
    protected void finalize() {
        super.finalize();
        this.removeAllBeans();
    }

    public BeanTreeNode findNode(BeanTreeNode root, Object bean) {
        BeanTreeNode n;
        int c;
        BeanContextChild bcc;
        BeanContext bc;
        if (bean == null) {
            return null;
        }
        Object rootBean = root.getBean();
        if (rootBean == bean) {
            return root;
        }
        if (bean instanceof BeanContextChild && rootBean != null && rootBean instanceof BeanContext && (bc = (bcc = (BeanContextChild)bean).getBeanContext()) != null) {
            ArrayList<BeanContextChild> bccPath = new ArrayList<BeanContextChild>();
            bccPath.add(0, bcc);
            boolean rootReached = false;
            while (bc != null) {
                if (bc == rootBean) {
                    rootReached = true;
                    break;
                }
                bccPath.add(0, bc);
                bc = bc.getBeanContext();
            }
            if (rootReached) {
                int num = bccPath.size();
                bc = (BeanContext)rootBean;
                BeanTreeNode bcNode = root;
                for (int c2 = 0; c2 < num; ++c2) {
                    BeanContextChild x = (BeanContextChild)bccPath.get(c2);
                    int ci = bcNode.getChildIndexOfBean(x);
                    if (ci < 0) {
                        return null;
                    }
                    BeanTreeNode childNode = bcNode.getChildNode(ci);
                    bc = c2 < num - 1 ? (BeanContext)x : null;
                    bcNode = childNode;
                }
                return bcNode;
            }
            return null;
        }
        int count = root.getChildCount();
        for (c = 0; c < count; ++c) {
            n = root.getChildNode(c);
            if (n.getBean() != bean) continue;
            return n;
        }
        for (c = 0; c < count; ++c) {
            n = this.findNode(root.getChildNode(c), bean);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    public BeanTreeNode findNode(Object bean) {
        return this.findNode(this.getRootNode(), bean);
    }

    public BeanTreeComparator getBeanTreeComparator() {
        return this.beanTreeComparator;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((BeanTreeNode)parent).getChildAt(index);
    }

    protected Comparator getChildComparator(BeanContext bc) {
        return this.beanTreeComparator == null ? null : this.beanTreeComparator.getComparator(this, bc);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((BeanTreeNode)parent).getChildCount();
    }

    protected BeanTreeNode getContextNode(BeanContext beanContext) {
        return (BeanTreeNode)this.contexts.get(beanContext);
    }

    protected String getDisplayName(Object bean) {
        return String.valueOf(bean);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        BeanTreeNode node = (BeanTreeNode)parent;
        return node.getIndex((TreeNode)child);
    }

    protected int getNodeInsertIndex(BeanTreeNode parent, Object bean, Comparator cmp) {
        int rc;
        BeanTreeNode ch;
        int lo = 0;
        int hi = parent.getChildCount() - 1;
        if (hi < 0) {
            return 0;
        }
        while (lo < hi) {
            int mid = (lo + hi) / 2;
            ch = (BeanTreeNode)parent.getChildAt(mid);
            rc = cmp.compare(bean, ch.getBean());
            if (rc == 0) {
                return mid;
            }
            if (rc < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        ch = (BeanTreeNode)parent.getChildAt(lo);
        rc = cmp.compare(bean, ch.getBean());
        return rc < 1 ? lo : lo + 1;
    }

    public BeanTreeNode getPropertyChildNode(BeanTreeNode node, String propertyName) {
        if (node == null) {
            return null;
        }
        if (propertyName == null) {
            return null;
        }
        int count = node.getChildCount();
        for (int c = 0; c < count; ++c) {
            PropertyDescriptor property;
            BeanTreeNode child = (BeanTreeNode)node.getChildAt(c);
            FeatureDescriptor feature = child.getFeatureDescriptor();
            if (feature == null || !(feature instanceof PropertyDescriptor) || !propertyName.equals((property = (PropertyDescriptor)feature).getName())) continue;
            return child;
        }
        return null;
    }

    @Override
    public Object getRoot() {
        return this.getRootNode();
    }

    @Override
    public Object getRootBean() {
        return this.rootBean;
    }

    protected void installBeanContextMembershipListener(BeanTreeNode contextNode) {
        if (contextNode == null) {
            return;
        }
        BeanContext beanContext = (BeanContext)contextNode.getBean();
        if (beanContext == null) {
            return;
        }
        Object oldNode = this.contexts.get(beanContext);
        if (oldNode != contextNode) {
            this.contexts.put(beanContext, contextNode);
            if (oldNode == null) {
                beanContext.addBeanContextMembershipListener(this);
            }
        }
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((BeanTreeNode)node).isLeaf();
    }

    @Override
    public void propertyChange(BeanTreeNode node, PropertyChangeEvent ev) {
        Object bean = node.getBean();
        if (bean == null) {
            return;
        }
        FeatureDescriptor feature = node.getFeatureDescriptor();
        if (feature == null) {
            return;
        }
        if (feature instanceof PropertyDescriptor) {
            try {
                this.nodeChanged(node);
                BeanTreeNode propertyNode = this.getPropertyChildNode(node, ev.getPropertyName());
                if (propertyNode != null) {
                    this.nodeStructureChanged(propertyNode);
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        int i;
        Object bean = ev.getSource();
        String propertyName = ev.getPropertyName();
        int from = 0;
        while ((i = this.getBeanIndex(bean, from)) >= 0) {
            BeanTreeNode beanNode = (BeanTreeNode)this.getRootNode().getChildAt(i);
            this.nodeChanged(beanNode);
            BeanTreeNode propertyNode = this.getPropertyChildNode(beanNode, propertyName);
            if (propertyNode != null) {
                this.nodeStructureChanged(propertyNode);
            }
            from = i + 1;
        }
    }

    @Override
    public void removeAllBeans() {
        super.removeAllBeans();
        try {
            Enumeration en = this.contexts.keys();
            while (en.hasMoreElements()) {
                BeanContext beanContext = (BeanContext)en.nextElement();
                this.uninstallBeanContextMembershipListener(beanContext);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setBeanTreeComparator(BeanTreeComparator newBeanTreeComparator) {
        this.beanTreeComparator = newBeanTreeComparator;
    }

    public void setRootBean(Object newRoot) {
        if (newRoot == null) {
            logger.fine("OOPS!! set Root to null: " + this);
            return;
        }
        BeanTreeRootNode rootNode = (BeanTreeRootNode)this.getRootNode();
        if (rootNode == null) {
            logger.fine("OOPS!! No RootNode available for: " + this);
            return;
        }
        if (this.rootBean == newRoot) {
            return;
        }
        rootNode.setBean(newRoot);
        this.rootBean = newRoot;
        BeanDescriptor descr = new BeanDescriptor(newRoot.getClass());
        descr.setDisplayName(String.valueOf(newRoot));
        rootNode.setFeatureDescriptor(descr);
        rootNode.removeAllChildNodes();
        Enumeration en = this.createChildNodes(newRoot, descr, false);
        if (en != null) {
            while (en.hasMoreElements()) {
                rootNode.addChildNode((BeanTreeNode)en.nextElement());
            }
        }
        this.installBeanContextMembershipListener(rootNode);
    }

    protected void uninstallBeanContextMembershipListener(BeanContext context) {
        if (context != null) {
            this.contexts.remove(context);
            context.removeBeanContextMembershipListener(this);
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        BeanTreeNode node = (BeanTreeNode)path.getLastPathComponent();
        Object bean = node.getBean();
        if (bean == null) {
            return;
        }
        FeatureDescriptor feature = node.getFeatureDescriptor();
        if (feature == null) {
            return;
        }
        try {
            if (!(feature instanceof PropertyDescriptor)) {
                throw new IllegalAccessException("Feature is not a property: " + feature);
            }
            PropertyDescriptor property = (PropertyDescriptor)feature;
            this.getToolkit().setValue(property, bean, newValue);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }
}

