/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.BeanProperty;
import com.spacekiller.util.beans.model.AbstractBeanTreeBranchNode;
import com.spacekiller.util.beans.model.BeanTreeModel;
import com.spacekiller.util.beans.model.BeanTreeNode;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

public class DefaultBeanTreeNode
extends AbstractBeanTreeBranchNode
implements PropertyChangeListener {
    private BeanTreeNode parent;
    private boolean loaded = false;
    private Object propertyChangeSource;

    public DefaultBeanTreeNode() {
        this.unloadChildren();
    }

    public DefaultBeanTreeNode(Object bean, FeatureDescriptor feature) {
        super(bean, feature);
        this.unloadChildren();
    }

    protected Object findPropertyChangeSource(BeansToolkit tk) {
        Object bean = this.getBean();
        FeatureDescriptor descr = this.getFeatureDescriptor();
        if (bean != null && descr != null && descr instanceof PropertyDescriptor) {
            try {
                Class<?> clazz;
                PropertyDescriptor property = (PropertyDescriptor)descr;
                Object value = tk.getValue(property, bean);
                if (value != null && !(clazz = value.getClass()).isArray()) {
                    return value;
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
        return null;
    }

    @Override
    public BeanTreeModel getBeanTreeModel() {
        return this.parent.getBeanTreeModel();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    protected Object getPropertyChangeSource() {
        return this.propertyChangeSource;
    }

    @Override
    public void installPropertyChangeListener(BeansToolkit tk) {
        Object source = this.findPropertyChangeSource(tk);
        this.setPropertyChangeSource(tk, source);
    }

    @Override
    public boolean isLeaf() {
        if (this.isLoaded()) {
            return this.getChildCountInternal() < 1;
        }
        BeanTreeModel model = this.getBeanTreeModel();
        if (model != null) {
            boolean rc = !model.hasChildNodes(this);
            return rc;
        }
        return true;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    protected synchronized void loadChildren(boolean load) {
        if (this.loaded == load) {
            return;
        }
        if (load) {
            Enumeration en;
            this.removeAllChildNodesInternal();
            BeanTreeModel model = this.getBeanTreeModel();
            if (model != null && (en = model.getChildNodes(this)) != null) {
                while (en.hasMoreElements()) {
                    this.addChildNodeInternal((BeanTreeNode)en.nextElement());
                }
            }
        } else {
            this.unloadChildren();
        }
        this.loaded = load;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        BeanTreeModel model = this.getBeanTreeModel();
        if (model == null) {
            return;
        }
        model.propertyChange(this, ev);
    }

    @Override
    public void setParent(BeanTreeNode newParent) {
        this.parent = newParent;
    }

    protected void setPropertyChangeSource(BeansToolkit tk, Object newPropertyChangeSource) {
        Object oldSource = this.propertyChangeSource;
        this.propertyChangeSource = null;
        if (oldSource != null) {
            BeanProperty.uninstallPropertyChangeListener((Object)oldSource, (PropertyChangeListener)this);
        }
        if (newPropertyChangeSource != null && BeanProperty.installPropertyChangeListener((Object)newPropertyChangeSource, (PropertyChangeListener)this)) {
            this.propertyChangeSource = newPropertyChangeSource;
        }
    }

    @Override
    public void uninstallPropertyChangeListener(BeansToolkit tk) {
        this.setPropertyChangeSource(tk, null);
    }

    private void unloadChildren() {
        this.removeAllChildNodesInternal();
    }
}

