/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.components.DefaultFeatureHeaderRenderer;
import com.spacekiller.util.beans.components.DefaultPropertyEditorCellEditor;
import com.spacekiller.util.beans.components.DefaultPropertyEditorCellRenderer;
import com.spacekiller.util.beans.components.DefaultPropertyEditorCellToolkit;
import com.spacekiller.util.beans.model.AbstractBeanTableModel;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DefaultPropertyTableModel
extends AbstractBeanTableModel {
    public DefaultPropertyTableModel(BeansToolkit tk) {
        super(tk);
    }

    protected int computePreferredColumnWidth(TableCellRenderer renderer, int column, int spacing) {
        int rc = spacing * 2;
        int rows = this.getRowCount();
        for (int c = 0; c < rows; ++c) {
            int w;
            Dimension pref = this.computePreferredCellSize(renderer, c, column);
            if (pref == null || (w = pref.width + spacing) <= rc) continue;
            rc = w;
        }
        return rc;
    }

    protected TableColumn createTableColumn(int modelIndex, TableCellRenderer renderer, TableCellEditor editor, DefaultFeatureHeaderRenderer headerRenderer) throws Exception {
        TableColumn column = new TableColumn(modelIndex);
        column.setCellRenderer(renderer);
        column.setCellEditor(editor);
        int beanIndex = modelIndex;
        Object bean = beanIndex < this.getBeanCount() ? this.getBeanAt(beanIndex) : null;
        column.setHeaderValue(bean);
        column.setHeaderRenderer(headerRenderer);
        return column;
    }

    @Override
    protected TableColumnModel createTableColumnModel(Vector propertyDescriptors, Vector propertyEditors, Vector propertyEditorBeanContexts) throws Exception {
        DefaultPropertyEditorCellToolkit cellToolkit = new DefaultPropertyEditorCellToolkit(this.getToolkit(), this, 1, propertyDescriptors, propertyEditors, propertyEditorBeanContexts);
        DefaultPropertyEditorCellRenderer renderer = new DefaultPropertyEditorCellRenderer(cellToolkit);
        DefaultPropertyEditorCellEditor editor = new DefaultPropertyEditorCellEditor(cellToolkit);
        DefaultFeatureHeaderRenderer headerRenderer = new DefaultFeatureHeaderRenderer(this.getToolkit());
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        int spacing = 10;
        int titleWidth = this.getColumnCount() < 1 ? 0 : this.computePreferredColumnWidth(headerRenderer, 0, spacing);
        int defaultWidth = this.getColumnCount() < 2 ? 0 : this.computePreferredColumnWidth(headerRenderer, 1, spacing);
        int colCount = this.getColumnCount();
        for (int c = 0; c < colCount; ++c) {
            TableColumn col = this.createTableColumn(c, renderer, editor, headerRenderer);
            int w = c < 1 ? titleWidth : defaultWidth;
            col.setWidth(w);
            col.setPreferredWidth(w);
            columnModel.addColumn(col);
        }
        return columnModel;
    }

    @Override
    protected void fireBeansDeleted(int firstIndex, int lastIndex) {
        this.fireTableStructureChanged();
    }

    @Override
    protected void fireBeansInserted(int firstIndex, int lastIndex) {
        this.fireTableStructureChanged();
    }

    @Override
    protected void fireBeansUpdated(int firstIndex, int lastIndex) {
        this.fireTableStructureChanged();
    }

    @Override
    protected void firePropertyDescriptorsDeleted(int firstIndex, int lastIndex) {
        this.fireTableRowsDeleted(firstIndex, lastIndex);
    }

    @Override
    protected void firePropertyDescriptorsInserted(int firstIndex, int lastIndex) {
        this.fireTableRowsInserted(firstIndex, lastIndex);
    }

    @Override
    protected void firePropertyDescriptorsUpdated(int firstIndex, int lastIndex) {
        this.fireTableRowsUpdated(firstIndex, lastIndex);
    }

    public Class getColumnClass(int columnIndex) {
        int beanIndex = columnIndex;
        Object bean = this.getBeanAt(beanIndex);
        return bean == null ? String.class : bean.getClass();
    }

    @Override
    public int getColumnCount() {
        return this.getBeanCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        int beanIndex = columnIndex;
        return String.valueOf(this.getBeanAt(beanIndex));
    }

    @Override
    public int getRowCount() {
        return this.getPropertyDescriptorCount();
    }

    @Override
    public Object getValueAt(int row, int col) {
        PropertyDescriptor descr = this.getPropertyDescriptorAt(row);
        if (descr == null) {
            return null;
        }
        int beanIndex = col;
        if (beanIndex < 0) {
            return descr;
        }
        return this.getValue(beanIndex, descr);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        PropertyDescriptor descr = this.getPropertyDescriptorAt(row);
        return descr == null ? false : descr.getWriteMethod() != null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        int col;
        Object bean = ev.getSource();
        if (bean == null) {
            return;
        }
        int propertyIndex = this.getPropertyDescriptorIndex(ev.getPropertyName());
        if (propertyIndex < 0) {
            return;
        }
        int from = 0;
        while ((col = this.getBeanIndex(bean, from)) >= 0) {
            this.fireTableCellUpdated(propertyIndex, col);
            from = col + 1;
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        PropertyDescriptor descr = this.getPropertyDescriptorAt(row);
        if (descr == null) {
            return;
        }
        int beanIndex = col;
        this.setValue(beanIndex, descr, value);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptorAt(int row, int col) {
        return this.getPropertyDescriptorAt(row);
    }
}

