/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.tooling;

import com.spacekiller.util.beans.Property;
import com.spacekiller.util.tooling.AbstractTool;
import com.spacekiller.util.tooling.ToolContext;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;

public abstract class TAction
extends AbstractTool {
    private TActionHandler actionHandler = new TActionHandler();
    private static final Logger logger = Logger.getLogger(TAction.class.getName());

    @Override
    public Object createInstance(ToolContext context, Class type) {
        if (type == null) {
            type = JMenuItem.class;
        }
        if (JMenuItem.class.isAssignableFrom(type)) {
            JMenuItem rc = new JMenuItem();
            rc.addActionListener(this.actionHandler);
            this.addInstance(rc, context);
            this.installEnabledPropertyListener(rc);
            this.refreshInstance(rc);
            return rc;
        }
        if (AbstractButton.class.isAssignableFrom(type)) {
            JButton rc = new JButton();
            rc.addActionListener(this.actionHandler);
            this.addInstance(rc, context);
            this.installEnabledPropertyListener(rc);
            this.refreshInstance(rc);
            return rc;
        }
        return null;
    }

    protected void handleActionPerformed(ActionEvent ev) {
        Object instance = ev.getSource();
        this.invoke(instance);
    }

    public abstract void invoke(Object var1);

    @Override
    protected void refreshInstance(Object c) {
        if (c == null) {
            return;
        }
        try {
            String name = this.getName();
            String tooltip = this.getTooltip();
            String text = this.getText();
            boolean pref = this.isPreferred();
            Font font = pref ? this.preferredFont() : this.normalFont();
            Icon icon = this.getIcon();
            Icon pressedIcon = this.getPressedIcon();
            Icon disabledIcon = this.getDisabledIcon();
            Icon disabledSelectedIcon = this.getDisabledSelectedIcon();
            Icon rolloverIcon = this.getRolloverIcon();
            Icon rolloverSelectedIcon = this.getRolloverSelectedIcon();
            boolean enabled = true;
            Property enabledProperty = this.getEnabledProperty(c);
            if (enabledProperty != null) {
                enabled = this.getBooleanValue(enabledProperty);
            }
            if (c instanceof JMenuItem) {
                JMenuItem m = (JMenuItem)c;
                m.setName(name);
                m.setText(text);
                m.setToolTipText(tooltip);
                m.setOpaque(false);
                m.setEnabled(enabled);
                m.setFont(font);
                m.setIcon(icon);
                m.setPressedIcon(pressedIcon);
                m.setDisabledIcon(disabledIcon);
                m.setDisabledSelectedIcon(disabledSelectedIcon);
                m.setRolloverEnabled(rolloverIcon != null);
                m.setRolloverIcon(rolloverIcon);
                m.setRolloverSelectedIcon(rolloverSelectedIcon);
            } else if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                b.setName(name);
                b.setText("");
                b.setToolTipText(tooltip);
                b.setOpaque(false);
                b.setEnabled(enabled);
                b.setFont(font);
                b.setIcon(icon);
                b.setPressedIcon(pressedIcon);
                b.setDisabledIcon(disabledIcon);
                b.setDisabledSelectedIcon(disabledSelectedIcon);
                b.setRolloverEnabled(rolloverIcon != null);
                b.setRolloverIcon(rolloverIcon);
                b.setRolloverSelectedIcon(rolloverSelectedIcon);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected final TActionHandler getActionHandler() {
        return this.actionHandler;
    }

    void setActionHandler(TActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    public class TActionHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            TAction.this.handleActionPerformed(ev);
        }
    }
}

