/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.tooling;

import com.spacekiller.util.beans.Property;
import com.spacekiller.util.tooling.AbstractToolGroup;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolEvent;
import java.awt.Font;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class TMenu
extends AbstractToolGroup {
    private static final Logger logger = Logger.getLogger(TMenu.class.getName());

    @Override
    public Object createInstance(ToolContext context, Class type) {
        if (type != null && !type.isAssignableFrom(JMenu.class)) {
            return null;
        }
        JMenu rc = this.createMenu(context, type);
        this.addInstance(rc, context);
        this.installEnabledPropertyListener(rc);
        this.refreshInstance(rc);
        this.installContainerChildren(rc, JMenuItem.class);
        return rc;
    }

    protected JMenu createMenu(ToolContext context, Class type) {
        return new JMenu();
    }

    @Override
    protected void handleChildrenAdded(ToolEvent ev) {
        super.handleContainerChildrenAdded(ev, JMenuItem.class);
    }

    @Override
    protected void handleChildrenRemoved(ToolEvent ev) {
        super.handleContainerChildrenRemoved(ev);
    }

    @Override
    protected void refreshInstance(Object c) {
        if (c == null) {
            return;
        }
        try {
            String name = this.getName();
            String tooltip = this.getTooltip();
            String text = this.getText();
            Icon icon = this.getIcon();
            boolean pref = this.isPreferred();
            Font font = pref ? this.preferredFont() : this.normalFont();
            boolean enabled = true;
            Property enabledProperty = this.getEnabledProperty(c);
            if (enabledProperty != null) {
                enabled = this.getBooleanValue(enabledProperty);
            }
            if (c instanceof JMenu) {
                JMenu m = (JMenu)c;
                m.setName(name);
                m.setText(text);
                m.setIcon(icon);
                m.setToolTipText(tooltip);
                m.setEnabled(enabled);
                m.setFont(font);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

