/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.tooling;

import com.spacekiller.util.beans.Property;
import com.spacekiller.util.tooling.AbstractTool;
import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.ToolContext;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;

public abstract class TToggleAction
extends TAction {
    private static final Logger logger = Logger.getLogger(TToggleAction.class.getName());
    private String selectedPropertyName;

    @Override
    public Object createInstance(ToolContext context, Class type) {
        if (type == null) {
            type = JCheckBoxMenuItem.class;
        }
        if (JMenuItem.class.isAssignableFrom(type)) {
            JCheckBoxMenuItem rc = new JCheckBoxMenuItem();
            rc.addActionListener(this.getActionHandler());
            this.addInstance(rc, context);
            this.installEnabledPropertyListener(rc);
            this.installSelectedPropertyListener(rc);
            this.refreshInstance(rc);
            return rc;
        }
        if (AbstractButton.class.isAssignableFrom(type)) {
            JToggleButton rc = new JToggleButton();
            rc.addActionListener(this.getActionHandler());
            this.addInstance(rc, context);
            this.installEnabledPropertyListener(rc);
            this.installSelectedPropertyListener(rc);
            this.refreshInstance(rc);
            return rc;
        }
        return null;
    }

    @Override
    protected void refreshInstance(Object c) {
        super.refreshInstance(c);
        try {
            Property selectedProperty = this.getSelectedProperty(c);
            if (selectedProperty != null) {
                AbstractButton item;
                boolean selected = this.getBooleanValue(selectedProperty);
                if (c instanceof JCheckBoxMenuItem && (item = (JCheckBoxMenuItem)c).isSelected() != selected) {
                    item.setSelected(selected);
                }
                if (c instanceof JToggleButton && (item = (JToggleButton)c).isSelected() != selected) {
                    item.setSelected(selected);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public boolean isSelected(Object instance) {
        if (instance == null) {
            return false;
        }
        if (instance instanceof JToggleButton) {
            return ((JToggleButton)instance).isSelected();
        }
        if (instance instanceof JCheckBoxMenuItem) {
            return ((JCheckBoxMenuItem)instance).isSelected();
        }
        return false;
    }

    public String getSelectedPropertyName() {
        return this.selectedPropertyName;
    }

    public void setSelectedPropertyName(String selectedPropertyName) {
        this.selectedPropertyName = selectedPropertyName;
        this.refresh();
        this.fireToolChanged();
    }

    protected void installSelectedPropertyListener(Object instance) {
        Property selectedProperty;
        ToolContext context = this.getToolContext(instance);
        if (context != null && (selectedProperty = this.getSelectedProperty(instance)) != null) {
            selectedProperty.addPropertyChangeListener((PropertyChangeListener)new AbstractTool.PropertyChangeHandler(instance));
        }
    }

    protected Property getSelectedProperty(Object instance) {
        String selectedPropertyName;
        ToolContext context = this.getToolContext(instance);
        if (context != null && (selectedPropertyName = this.getSelectedPropertyName()) != null) {
            return context.getProperty(selectedPropertyName);
        }
        return null;
    }
}

