/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.tooling;

import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ToolProvider {
    private ToolGroup group;
    private List tools = new ArrayList();

    public ToolGroup getGroup() {
        return this.group;
    }

    public synchronized void setGroup(ToolGroup newGroup) {
        Iterator i;
        if (this.group == newGroup) {
            return;
        }
        if (this.group != null) {
            i = this.tools.iterator();
            while (i.hasNext()) {
                this.group.removeChild((Tool)i.next());
            }
        }
        this.group = newGroup;
        if (this.group != null) {
            i = this.tools.iterator();
            while (i.hasNext()) {
                this.group.addChild((Tool)i.next());
            }
        }
    }

    public Tool[] getTools() {
        Tool[] rc = new Tool[this.tools.size()];
        rc = this.tools.toArray(rc);
        return rc;
    }

    public synchronized void setTools(Tool[] t) {
        this.removeAllTools();
        if (t != null) {
            for (int c = 0; c < t.length; ++c) {
                this.addTool(t[c]);
            }
        }
    }

    public synchronized void addTool(Tool t) {
        if (t != null) {
            this.tools.add(t);
            if (this.group != null) {
                this.group.addChild(t);
            }
        }
    }

    public synchronized void removeTool(Tool t) {
        if (this.tools.remove(t) && this.group != null) {
            this.group.removeChild(t);
        }
    }

    public synchronized void removeAllTools() {
        int num = this.tools.size();
        if (this.group != null) {
            for (int c = 0; c < num; ++c) {
                Tool t = (Tool)this.tools.get(c);
                this.group.removeChild(t);
            }
        }
        this.tools.clear();
    }
}

