/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.jinput;

import com.spacekiller.game2d.InputManager;
import com.spacekiller.game2d.InputProvider;
import java.lang.reflect.Method;

public class JInputInputProvider
implements InputProvider {
    private static final String JINPUT_VERSION_CLASSNAME = "net.java.games.input.Version";
    private static final String JINPUT11_PROVIDER = "com.spacekiller.game2d.ext.jinput11.JInput11InputProvider";
    private static final String JINPUT20_PROVIDER = "com.spacekiller.game2d.ext.jinput20.JInput20InputProvider";
    private InputProvider provider;

    public InputManager[] getInputManagers() throws Exception {
        InputProvider prov = this.getProvider();
        if (prov == null) {
            return new InputManager[0];
        }
        return prov.getInputManagers();
    }

    protected InputProvider createProvider() throws Exception {
        String jinputVersion;
        String javaVersion = System.getProperty("java.version");
        System.out.println("Java version: " + javaVersion);
        boolean supportsJInput11 = false;
        boolean supportsJInput20 = true;
        if (javaVersion.startsWith("1.1")) {
            supportsJInput11 = true;
        }
        if (javaVersion.startsWith("1.2")) {
            supportsJInput11 = true;
        }
        if (javaVersion.startsWith("1.3")) {
            supportsJInput11 = true;
        }
        if (javaVersion.startsWith("1.4")) {
            supportsJInput11 = true;
        }
        if (javaVersion.startsWith("1.5")) {
            supportsJInput11 = true;
        }
        if ((jinputVersion = JInputInputProvider.getJInputVersion(this.getClass().getClassLoader())) == null) {
            if (supportsJInput20 || supportsJInput11) {
                // empty if block
            }
            System.out.println("TODO load JInput... ");
            throw new UnsupportedOperationException("TODO dynamically load JInput..");
        }
        System.out.println("JInput version: " + jinputVersion);
        String provClassName = JINPUT20_PROVIDER;
        if (jinputVersion.startsWith("1.0")) {
            provClassName = JINPUT11_PROVIDER;
        }
        if (jinputVersion.startsWith("1.1")) {
            provClassName = JINPUT11_PROVIDER;
        }
        if (jinputVersion.startsWith("2.0")) {
            provClassName = JINPUT20_PROVIDER;
        }
        System.out.println("Loading InputProvider class: " + provClassName);
        Class<?> provClass = Class.forName(provClassName);
        InputProvider prov = (InputProvider)provClass.newInstance();
        System.out.println("JInput provider: " + prov);
        return prov;
    }

    protected InputProvider getProvider() throws Exception {
        if (this.provider == null) {
            this.setProvider(this.createProvider());
        }
        return this.provider;
    }

    protected void setProvider(InputProvider provider) {
        this.provider = provider;
    }

    public static String getJInputVersion(ClassLoader loader) throws Exception {
        try {
            Class<?> versionClass = Class.forName(JINPUT_VERSION_CLASSNAME);
            System.out.println("JInput source: " + versionClass.getProtectionDomain());
            Method methodGetVersion = versionClass.getMethod("getVersion", new Class[0]);
            Object version = methodGetVersion.invoke(null, new Object[0]);
            return "" + version;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

