/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.jinput;

import com.spacekiller.game2d.util.Game2DUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;

public class JInputPluginClassLoader
extends URLClassLoader {
    private String[] libraryPath;

    public JInputPluginClassLoader(URL[] urls, String[] libraryPath, ClassLoader parent) {
        super(urls, parent);
        this.libraryPath = libraryPath;
    }

    @Override
    protected String findLibrary(String libname) {
        File file;
        String s = super.findLibrary(libname);
        if (s != null) {
            System.out.println("Library: " + s);
            return s;
        }
        System.out.println("findLibrary: " + libname);
        for (int c = 0; c < this.libraryPath.length; ++c) {
            file = new File(this.libraryPath[c], libname + ".dll");
            if (!file.exists()) continue;
            file = file.getAbsoluteFile();
            System.out.println("Library: " + file);
            return file.getPath();
        }
        URL url = this.getClass().getResource("/" + libname + ".dll");
        if (url != null) {
            System.out.println("Library resource: " + url);
            file = new File(libname + ".dll ").getAbsoluteFile();
            if (!file.exists()) {
                System.out.println("Extracting library: " + file);
                try {
                    Game2DUtil.extract((URL)url, (File)file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return file.getPath();
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        System.out.println("" + this + ".getPermissions: " + codesource);
        PermissionCollection rc = super.getPermissions(codesource);
        if (rc != null) {
            rc.add(new AllPermission());
            System.out.println("" + this + ".getPermission: granted AllPermissions");
        }
        return rc;
    }
}

