/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.sound;

import com.spacekiller.game2d.ext.sound.Mp3Util;
import com.spacekiller.game2d.sound.AudioSequence;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;

public class Mp3DecoderAudioSequence
implements AudioSequence {
    private URL mp3URL;
    private Mp3Util mp3Util;
    private File wavFile;
    private AudioSequence wavSequence;
    private boolean decoded = false;
    private boolean decodeEnabled = true;

    public Mp3DecoderAudioSequence(URL mp3URL, Mp3Util mp3Util, File wavFile, AudioSequence wavSequence) {
        this.mp3URL = mp3URL;
        this.mp3Util = mp3Util;
        this.wavFile = wavFile;
        this.wavSequence = wavSequence;
        this.decoded = wavFile.exists();
        this.decodeEnabled = true;
    }

    public AudioInputStream nextAudioInputStream() throws Exception {
        if (!this.decoded) {
            if (!this.decodeEnabled) {
                return null;
            }
            this.decodeMp3();
        }
        return this.wavSequence.nextAudioInputStream();
    }

    public void reset() {
        this.wavSequence.reset();
    }

    public boolean isDecodeEnabled() {
        return this.decodeEnabled;
    }

    public void setDecodeEnabled(boolean decodeEnabled) {
        this.decodeEnabled = decodeEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeMp3() throws Exception {
        System.out.println("" + this + ".decodeMp3: " + this.mp3URL + " >> " + this.wavFile);
        InputStream mp3Stream = this.mp3URL.openStream();
        try {
            this.mp3Util.convertMp3ToWav(mp3Stream, this.wavFile);
            this.decoded = this.wavFile.exists();
        }
        finally {
            mp3Stream.close();
        }
    }
}

