/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.sound;

import com.spacekiller.game2d.ext.sound.WaveHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.converter.Converter;

public class Mp3Util {
    public static int pcmS(byte[] b, int ofs) {
        int i = b[ofs];
        if (i < 0) {
            i = 256 - Math.abs(i);
        }
        byte j = b[ofs + 1];
        return i + j * 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertMp3ToWav(File sourceFile, File targetFile) throws Exception {
        FileInputStream fin = new FileInputStream(sourceFile);
        try {
            this.convertMp3ToWav(fin, targetFile);
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertMp3ToWav(InputStream mp3Stream, File targetFile) throws Exception {
        if (targetFile.exists()) {
            throw new IOException("Target file already exists: " + targetFile);
        }
        File tempFile = new File(targetFile.getPath() + ".temp.wav");
        Converter converter = new Converter();
        converter.convert(mp3Stream, tempFile.getPath(), null, null);
        FileInputStream fin = new FileInputStream(tempFile);
        try {
            WaveHeader waveHeader = WaveHeader.read("dir", "name", fin);
            int channels = waveHeader.getSamplingChannels();
            System.out.println("Channels: " + channels);
            System.out.println("Rate: " + waveHeader.getSamplingRate());
            int sampleSize = waveHeader.getSamplingBytes();
            int frameSize = sampleSize * channels;
            System.out.println("Frame-Size: " + frameSize);
            int dataSize = waveHeader.getDataSize();
            FileOutputStream fout = new FileOutputStream(targetFile);
            try {
                long skipped;
                long toSkip;
                byte[] buf = new byte[65536];
                int num = fin.read(buf);
                int silenceSize = 0;
                if (num > 0 && sampleSize == 2) {
                    silenceSize = -1;
                    int frames = num / frameSize;
                    System.out.println("Frames: " + frames);
                    int j = 0;
                    for (int i = 0; i < frames; ++i) {
                        int v = Mp3Util.pcmS(buf, j);
                        j += 2;
                        if (v <= 1000 && v >= -1000) continue;
                        silenceSize = Math.max(j - 10, 0);
                        break;
                    }
                    if (silenceSize < 0) {
                        silenceSize = num;
                    }
                    silenceSize = silenceSize / frameSize * frameSize;
                }
                System.out.println("Start-Silence: " + silenceSize + " bytes");
                int endSilenceSize = 0;
                if (num > 0 && sampleSize == 2 && (toSkip = (long)(dataSize - num - buf.length)) >= 0L) {
                    long skipped2;
                    while (toSkip > 0L && (skipped2 = fin.skip(toSkip)) >= 0L) {
                        toSkip -= skipped2;
                    }
                    int siz = fin.read(buf);
                    if (siz == buf.length) {
                        int frames = siz / frameSize;
                        int j = buf.length;
                        for (int i = frames - 1; i >= 0; --i) {
                            int v = Mp3Util.pcmS(buf, j -= 2);
                            if (v <= 1000 && v >= -1000) continue;
                            endSilenceSize = Math.max(buf.length - j - 10, 0);
                            break;
                        }
                    }
                }
                endSilenceSize = endSilenceSize / frameSize * frameSize;
                System.out.println("End-Silence: " + endSilenceSize + " bytes");
                int newDataSize = waveHeader.getDataSize() - silenceSize - endSilenceSize;
                waveHeader.setDataSize(newDataSize);
                waveHeader.write(fout);
                fin.close();
                fin = new FileInputStream(tempFile);
                WaveHeader.read("dir", "name", fin);
                for (long toSkip2 = (long)silenceSize; toSkip2 > 0L && (skipped = fin.skip(toSkip2)) >= 1L; toSkip2 -= skipped) {
                }
                for (int todo = newDataSize; todo > 0; todo -= num) {
                    num = fin.read(buf, 0, Math.min(buf.length, todo));
                    if (num < 0) {
                        break;
                    }
                    fout.write(buf, 0, num);
                }
            }
            finally {
                fout.close();
            }
        }
        finally {
            fin.close();
            tempFile.delete();
        }
    }
}

