/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.sound;

import com.spacekiller.game2d.ext.sound.AudioToolkit;
import java.io.InputStream;
import java.io.OutputStream;

public class WaveHeader {
    private String fileName;
    private String fileDirectory;
    public int headerTag = 0;
    public int headerBPS = 0;
    public int headerBPS2 = 0;
    public int headerAlign = 0;
    public int fileSize = 0;
    public int samples = 0;
    public int dataSize = 0;
    public int sampleBytes = 0;
    public int channels = 0;
    public int rate = 0;

    private void calcHeader() {
        this.headerAlign = this.getSamplingBytes() * this.getSamplingChannels();
        this.headerBPS2 = this.getSamplingRate() * this.headerAlign;
        this.headerBPS = this.getSamplingBytes() * 8;
    }

    public String getFormat() {
        return "wave audio file";
    }

    private int getHeaderAlign() {
        return this.headerAlign;
    }

    private int getHeaderBPS() {
        return this.headerBPS;
    }

    private int getHeaderBPS2() {
        return this.headerBPS2;
    }

    private int getHeaderTag() {
        return this.headerTag;
    }

    public void read(InputStream io) throws Exception {
        byte[] x = new byte[4];
        io.read(x);
        if (!new String(x).equals("RIFF")) {
            throw new IllegalArgumentException("File does not contain wave data.");
        }
        io.read(x);
        io.read(x);
        while (io.available() > 0) {
            int len;
            io.read(x);
            String s = new String(x);
            if (s.equals("fmt ")) {
                io.read(x);
                len = AudioToolkit.getLong1(x, 0);
                byte[] dat = new byte[len];
                io.read(dat);
                this.setHeaderTag(AudioToolkit.getInt1(dat, 0));
                this.setSamplingChannels(AudioToolkit.getInt1(dat, 2));
                this.setSamplingRate(AudioToolkit.getLong1(dat, 4));
                this.setHeaderBPS2(AudioToolkit.getLong1(dat, 8));
                this.setHeaderAlign(AudioToolkit.getInt1(dat, 12));
                this.setHeaderBPS(AudioToolkit.getInt1(dat, 14));
                this.setSamplingBytes(this.getHeaderBPS() / 8);
            }
            if (!s.equals("data")) continue;
            io.read(x);
            len = AudioToolkit.getLong1(x, 0);
            this.setDataSize(len);
            break;
        }
    }

    public static WaveHeader read(String fdir, String fn, InputStream io) throws Exception {
        WaveHeader wave = new WaveHeader();
        wave.setFileDirectory(fdir);
        wave.setFileName(fn);
        wave.read(io);
        return wave;
    }

    public void write(OutputStream io) throws Exception {
        io.write("RIFF".getBytes());
        byte[] x = new byte[4];
        AudioToolkit.setLong1(x, 0, this.getDataSize() + 8 + 16 + 8 + 4);
        io.write(x);
        io.write("WAVE".getBytes());
        io.write("fmt ".getBytes());
        AudioToolkit.setLong1(x, 0, 16);
        io.write(x);
        AudioToolkit.setInt1(x, 0, 1);
        io.write(x, 0, 2);
        AudioToolkit.setInt1(x, 0, this.getSamplingChannels());
        io.write(x, 0, 2);
        AudioToolkit.setLong1(x, 0, this.getSamplingRate());
        io.write(x);
        this.calcHeader();
        AudioToolkit.setLong1(x, 0, this.getHeaderBPS2());
        io.write(x);
        AudioToolkit.setInt1(x, 0, this.getHeaderAlign());
        io.write(x, 0, 2);
        AudioToolkit.setInt1(x, 0, this.getHeaderBPS());
        io.write(x, 0, 2);
        io.write("data".getBytes());
        AudioToolkit.setLong1(x, 0, this.getDataSize());
        io.write(x);
    }

    private void setHeaderAlign(int i) {
        this.headerAlign = i;
    }

    private void setHeaderBPS(int i) {
        this.headerBPS = i;
    }

    private void setHeaderBPS2(int i) {
        this.headerBPS2 = i;
    }

    private void setHeaderTag(int i) {
        this.headerTag = i;
    }

    public String toString() {
        return "Waveform " + this.getFileName();
    }

    public String getFileDirectory() {
        return this.fileDirectory;
    }

    public void setFileDirectory(String fileDirectory) {
        this.fileDirectory = fileDirectory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getSamplingBytes() {
        return this.sampleBytes;
    }

    public int getSamplingChannels() {
        return this.channels;
    }

    public int getSamplingRate() {
        return this.rate;
    }

    public void setSamplingBytes(int b) {
        this.sampleBytes = b;
        this.setSamples();
    }

    public void setSamplingChannels(int ch) {
        this.channels = ch;
        this.setSamples();
    }

    public void setSamplingRate(int r) {
        this.rate = r;
        this.setSamples();
    }

    private void setSamples() {
        if (this.channels < 1 || this.sampleBytes < 1) {
            this.samples = 0;
            return;
        }
        this.samples = this.dataSize / this.sampleBytes / this.channels;
    }

    public void setDataSize(int siz) {
        this.dataSize = siz;
        this.setSamples();
    }

    public int getDataSize() {
        return this.dataSize;
    }
}

