/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.todo;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.EmptyStackException;
import sun.awt.SunToolkit;

public class BeneEventQueue
extends EventQueue {
    private MouseListener mouseListener;
    private MouseMotionListener motionListener;
    private MouseWheelListener wheelListener;
    private KeyListener keyListener;

    @Override
    protected void dispatchEvent(AWTEvent event) {
        System.out.println("" + this + ".dispatch >> id=" + event.getID() + " >> " + event);
        if (event.getID() == 0) {
            super.dispatchEvent(event);
        }
    }

    @Override
    public AWTEvent getNextEvent() throws InterruptedException {
        AWTEvent ev;
        System.out.println("" + this + ".getNextEvent..");
        int count = 0;
        while ((ev = super.getNextEvent()) != null) {
            System.out.println("process: " + ev);
            ++count;
            if (ev instanceof MouseEvent) {
                Thread.sleep(10000L);
                continue;
            }
            if (!(ev instanceof KeyEvent)) break;
            Thread.sleep(10000L);
        }
        System.out.println("processed: " + count);
        AWTEvent next = ev;
        System.out.println("" + this + ".getNextEvent: " + next);
        return next;
    }

    @Override
    public synchronized AWTEvent peekEvent() {
        System.out.println("" + this + ".peekEvent()");
        return null;
    }

    @Override
    public synchronized AWTEvent peekEvent(int id) {
        System.out.println("" + this + ".peekEvent(" + id + ")");
        return null;
    }

    @Override
    protected void pop() throws EmptyStackException {
        System.out.println("" + this + ".pop()");
        super.pop();
    }

    @Override
    public void postEvent(AWTEvent theEvent) {
        System.out.println("" + this + ".post >> " + theEvent);
        super.postEvent(theEvent);
    }

    @Override
    public synchronized void push(EventQueue newEventQueue) {
        System.out.println("" + this + ".push >> " + newEventQueue);
    }

    public void dispose() {
        this.pop();
    }

    public AWTEvent nextBeneEvent() throws InterruptedException {
        SunToolkit.flushPendingEvents();
        AWTEvent ev = super.peekEvent();
        if (ev != null) {
            return super.getNextEvent();
        }
        return null;
    }

    public void process() {
        try {
            AWTEvent ev;
            SunToolkit.flushPendingEvents();
            while ((ev = super.peekEvent()) != null) {
                ev = super.getNextEvent();
                if (ev instanceof MouseEvent) {
                    MouseEvent mev = (MouseEvent)ev;
                    switch (mev.getID()) {
                        case 503: {
                            this.motionListener.mouseMoved(mev);
                            break;
                        }
                        case 506: {
                            this.motionListener.mouseDragged(mev);
                            break;
                        }
                        case 504: {
                            this.mouseListener.mouseEntered(mev);
                            break;
                        }
                        case 505: {
                            this.mouseListener.mouseExited(mev);
                            break;
                        }
                        case 501: {
                            this.mouseListener.mousePressed(mev);
                            break;
                        }
                        case 502: {
                            this.mouseListener.mouseReleased(mev);
                            break;
                        }
                        case 500: {
                            this.mouseListener.mouseClicked(mev);
                        }
                    }
                }
                if (ev instanceof MouseWheelEvent) {
                    MouseWheelEvent mwe = (MouseWheelEvent)ev;
                    switch (mwe.getID()) {
                        case 507: {
                            this.wheelListener.mouseWheelMoved(mwe);
                        }
                    }
                }
                if (!(ev instanceof KeyEvent)) continue;
                KeyEvent kev = (KeyEvent)ev;
                switch (kev.getID()) {
                    case 401: {
                        this.keyListener.keyPressed(kev);
                    }
                    case 400: {
                        this.keyListener.keyTyped(kev);
                    }
                    case 402: {
                        this.keyListener.keyReleased(kev);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MouseMotionListener getMotionListener() {
        return this.motionListener;
    }

    public void setMotionListener(MouseMotionListener motionListener) {
        this.motionListener = motionListener;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public void setMouseListener(MouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void setKeyListener(KeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public MouseWheelListener getWheelListener() {
        return this.wheelListener;
    }

    public void setWheelListener(MouseWheelListener wheelListener) {
        this.wheelListener = wheelListener;
    }
}

