/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.todo;

import com.spacekiller.game2d.InputAxis;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.Rumbler;
import com.spacekiller.game2d.input.AbstractInputAxis;
import com.spacekiller.game2d.input.AbstractInputButton;
import com.spacekiller.game2d.todo.BeneEventQueue;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class BeneMouseController
implements InputController,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private BeneEventQueue queue;
    private int x;
    private int y;
    private int w;
    private BeneMouseXAxis xAxis;
    private BeneMouseYAxis yAxis;
    private BeneMouseWheel wheel;
    private BeneMouseButton[] buttons;
    private InputAxis[] axes;

    public BeneMouseController(BeneEventQueue queue, int buttonCount) {
        int c;
        this.queue = queue;
        this.xAxis = new BeneMouseXAxis("x-axis");
        this.yAxis = new BeneMouseYAxis("y-axis");
        this.wheel = new BeneMouseWheel("wheel");
        this.buttons = new BeneMouseButton[buttonCount];
        for (c = 0; c < buttonCount; ++c) {
            this.buttons[c] = new BeneMouseButton("button" + (c + 1));
        }
        this.axes = new InputAxis[buttonCount + 3];
        this.axes[0] = this.xAxis;
        this.axes[1] = this.yAxis;
        this.axes[2] = this.wheel;
        for (c = 0; c < buttonCount; ++c) {
            this.axes[3 + c] = this.buttons[c];
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int b = e.getButton() - 1;
        if (b >= 0 && b < this.buttons.length) {
            this.buttons[b].setPressed(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int b = e.getButton() - 1;
        if (b >= 0 && b < this.buttons.length) {
            this.buttons[b].setPressed(false);
        }
    }

    public InputAxis getAxisAt(int i) {
        return this.axes[i];
    }

    public int getAxisCount() {
        return this.axes.length;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.w = e.getWheelRotation();
    }

    public void poll() {
        this.queue.process();
    }

    public int getType() {
        return 2;
    }

    public InputAxis getAxisForKey(int keyCode) {
        return null;
    }

    public int getRumblerCount() {
        return 0;
    }

    public Rumbler getRumblerAt(int i) {
        return null;
    }

    protected class BeneMouseWheel
    extends AbstractInputAxis {
        public BeneMouseWheel(String name) {
            super((InputController)BeneMouseController.this, name, 2020);
        }

        public float getValue() {
            return BeneMouseController.this.w;
        }

        public boolean isAnalog() {
            return true;
        }

        public boolean isNormalized() {
            return false;
        }

        public boolean isRelative() {
            return false;
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class BeneMouseYAxis
    extends AbstractInputAxis {
        public BeneMouseYAxis(String name) {
            super((InputController)BeneMouseController.this, name, 2001);
        }

        public float getValue() {
            return BeneMouseController.this.y;
        }

        public boolean isAnalog() {
            return true;
        }

        public boolean isNormalized() {
            return false;
        }

        public boolean isRelative() {
            return false;
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class BeneMouseXAxis
    extends AbstractInputAxis {
        public BeneMouseXAxis(String name) {
            super((InputController)BeneMouseController.this, name, 2000);
        }

        public float getValue() {
            return BeneMouseController.this.x;
        }

        public boolean isAnalog() {
            return true;
        }

        public boolean isNormalized() {
            return false;
        }

        public boolean isRelative() {
            return false;
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class BeneMouseButton
    extends AbstractInputButton {
        public BeneMouseButton(String name) {
            super((InputController)BeneMouseController.this, name, 1000, -1);
        }

        public boolean isPolling() {
            return true;
        }

        protected void setPressed(boolean b) {
            this.pressed = b;
        }
    }
}

