/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public class DefaultRuntimeContext
implements RuntimeContext {
    private static RuntimeContext defaultRuntimeContext;
    private File defaultDirectory = null;
    private ExecutionManager executionManager;
    private Logger logger = Logger.getLogger(DefaultRuntimeContext.class.getName());
    private boolean headless = false;

    protected JDialog createFileDialog(String title, JFileChooser fileChooser) {
        JDialog fileDialog = new JDialog();
        fileDialog.setTitle(title);
        fileDialog.setContentPane(fileChooser);
        fileDialog.pack();
        Tools.centerWindow((Window)fileDialog);
        return fileDialog;
    }

    public Reader getClipboardReader() throws Exception {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable f = cb.getContents(this);
        Object o = null;
        if (f.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            o = f.getTransferData(DataFlavor.stringFlavor);
        }
        if (f.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor())) {
            return DataFlavor.getTextPlainUnicodeFlavor().getReaderForText(f);
        }
        if (o == null) {
            this.logger.fine("DEBUG: unsupported transferable=" + f);
            return null;
        }
        if (o instanceof Reader) {
            return (Reader)o;
        }
        if (o instanceof InputStream) {
            return new InputStreamReader((InputStream)o);
        }
        if (o instanceof String) {
            return new StringReader((String)o);
        }
        this.logger.fine("DEBUG: unsupported transferData=" + o);
        return null;
    }

    public String getClipboardText() throws Exception {
        String s;
        Reader reader = this.getClipboardReader();
        if (reader == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(reader);
        StringBuffer rc = new StringBuffer();
        int line = 0;
        while ((s = br.readLine()) != null) {
            rc.append(s);
            if (line > 0) {
                rc.append("\n");
            }
            ++line;
        }
        br.close();
        reader.close();
        return rc.toString();
    }

    public File getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public static RuntimeContext getDefaultRuntimeContext() {
        if (defaultRuntimeContext == null) {
            defaultRuntimeContext = new DefaultRuntimeContext();
        }
        return defaultRuntimeContext;
    }

    public File getInputFile(String title, FileFilter[] fileFilters) {
        return this.getInputFile(title, fileFilters, null);
    }

    public File getInputFile(String title, FileFilter[] fileFilters, File currentDir) {
        File[] files = this.getInputFiles(title, false, 0, fileFilters, currentDir);
        File f = null;
        if (files != null && files.length > 0) {
            f = files[0];
        }
        return f;
    }

    public File[] getInputFiles(String title, FileFilter[] fileFilters) {
        return this.getInputFiles(title, fileFilters, null);
    }

    public File[] getInputFiles(String title, FileFilter[] fileFilters, File currentDir) {
        return this.getInputFiles(title, true, 0, fileFilters, currentDir);
    }

    public File[] getInputFiles(String title, boolean multiple, int selectionMode, FileFilter[] fileFilters, File currentDir) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(selectionMode);
        fileChooser.setDialogType(0);
        fileChooser.setMultiSelectionEnabled(multiple);
        if (currentDir == null) {
            currentDir = this.getDefaultDirectory();
        }
        if (currentDir != null) {
            fileChooser.setCurrentDirectory(currentDir);
        }
        if (fileFilters != null) {
            for (int c = 0; c < fileFilters.length; ++c) {
                fileChooser.addChoosableFileFilter(fileFilters[c]);
            }
        }
        if (!this.showFileDialog(title, fileChooser)) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        File[] files = fileChooser.getSelectedFiles();
        if (files == null) {
            files = new File[]{};
        }
        if (files.length == 0 && file != null) {
            files = new File[]{file};
        }
        return files;
    }

    public InputStream getInputStream(String title, FileFilter[] fileFilters) throws IOException {
        File file = this.getInputFile(title, fileFilters);
        return file == null ? null : new FileInputStream(file);
    }

    public File getOutputDirectory(String title, String buttonText, FileFilter[] fileFilters) throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(2);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setApproveButtonText(buttonText);
        if (fileFilters != null) {
            for (int c = 0; c < fileFilters.length; ++c) {
                fileChooser.addChoosableFileFilter(fileFilters[c]);
            }
        }
        if (!this.showFileDialog(title, fileChooser)) {
            return null;
        }
        File dir = fileChooser.getCurrentDirectory();
        return dir;
    }

    public File getOutputFile(String title, FileFilter[] fileFilters) throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(1);
        fileChooser.setMultiSelectionEnabled(false);
        if (fileFilters != null) {
            for (int c = 0; c < fileFilters.length; ++c) {
                fileChooser.addChoosableFileFilter(fileFilters[c]);
            }
        }
        if (!this.showFileDialog(title, fileChooser)) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        return file;
    }

    public OutputStream getOutputStream(String title, FileFilter[] fileFilters) throws IOException {
        File file = this.getOutputFile(title, fileFilters);
        return file == null ? null : new FileOutputStream(file);
    }

    public boolean prompt(String title, Object message) {
        return this.prompt(title, message, new String[]{"Ok", "Cancel"}) == 0;
    }

    public int prompt(String title, Object message, String[] buttons) {
        AbstractButton[] b = new AbstractButton[buttons.length];
        for (int c = 0; c < b.length; ++c) {
            b[c] = new JButton(buttons[c]);
        }
        return this.prompt(title, message, b);
    }

    public int prompt(String title, Object message, AbstractButton[] buttons) {
        JDialog dialog = new JDialog();
        dialog.setTitle(title);
        Component content = null;
        if (message == null) {
            message = "";
        }
        if (message instanceof Component) {
            content = (Component)message;
        } else {
            String text = String.valueOf(message);
            JTextArea textArea = new JTextArea();
            textArea.setEditable(false);
            textArea.setText(text);
            content = textArea;
        }
        PromptActionListener promptActionListener = new PromptActionListener(dialog, buttons);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        for (int c = 0; c < buttons.length; ++c) {
            buttonPanel.add(buttons[c]);
            buttons[c].addActionListener(promptActionListener);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", content);
        panel.add("South", buttonPanel);
        dialog.setContentPane(panel);
        dialog.pack();
        Tools.centerWindow((Window)dialog);
        dialog.setModal(true);
        dialog.setVisible(true);
        int rc = promptActionListener.getReturnCode();
        for (int c = 0; c < buttons.length; ++c) {
            buttons[c].removeActionListener(promptActionListener);
        }
        return rc;
    }

    public void setClipboardText(String s) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(s);
        cb.setContents(ss, ss);
    }

    public void setDefaultDirectory(File newDefaultDirectory) {
        this.defaultDirectory = newDefaultDirectory;
    }

    public static void setDefaultRuntimeContext(RuntimeContext newDefaultRuntimeContext) {
        defaultRuntimeContext = newDefaultRuntimeContext;
    }

    public void setLogger(Logger newLogger) {
        this.logger = newLogger;
    }

    protected boolean showFileDialog(String title, JFileChooser fileChooser) {
        JDialog fileDialog = this.createFileDialog(title, fileChooser);
        class FileDialogListener
        implements ActionListener {
            private JDialog dialog;
            private boolean confirm = false;

            public FileDialogListener(JDialog dlg) {
                this.dialog = dlg;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                this.confirm = true;
                this.dialog.dispose();
            }

            public boolean isConfirm() {
                return this.confirm;
            }
        }
        FileDialogListener listener = new FileDialogListener(fileDialog);
        fileChooser.addActionListener(listener);
        fileDialog.setModal(true);
        fileDialog.setVisible(true);
        boolean rc = listener.isConfirm();
        fileChooser.removeActionListener(listener);
        return rc;
    }

    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public void setExecutionManager(ExecutionManager executionManager) {
        this.executionManager = executionManager;
    }

    public void notify(Object source, Object message, long millis) {
        String title;
        String string = title = source == null ? null : String.valueOf(source);
        if (title == null) {
            title = "Message";
        }
        this.prompt(title, message, new String[]{"Ok"});
    }

    public void notify(Object source, Object message) {
        this.notify(source, message, 10000L);
    }

    public void notifyError(Object source, Throwable error) {
        this.notify(source, error, 10000L);
    }

    public void notifyError(Object source, Throwable error, long millis) {
        this.notify(source, error, millis);
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public class PromptActionListener
    implements ActionListener {
        private AbstractButton[] buttons;
        private JDialog dialog;
        private int rc = -1;

        public PromptActionListener(JDialog dialog, AbstractButton[] buttons) {
            this.dialog = dialog;
            this.buttons = buttons;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object src = ev.getSource();
            for (int c = 0; c < this.buttons.length; ++c) {
                if (src != this.buttons[c]) continue;
                this.rc = c;
                this.dialog.dispose();
                return;
            }
        }

        public int getReturnCode() {
            return this.rc;
        }
    }
}

