/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.platform.util.ClassDescriptorImpl;
import com.spacekiller.infection.platform.util.ClassFile;
import com.spacekiller.infection.platform.util.ClassScanner;
import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.ClassDescriptor;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Parameter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class InfectionClassRegistry
implements ClassRegistry {
    private static final int FILE_MAGIC = 37583453;
    private static final int FILE_VERSION = 2;
    private static final int FILE_ENTRY = 367954943;
    private static final int FILE_END = 948369387;
    private static final int DEFAULT_READ_BUFFER_SIZE = 131072;
    private static final int DEFAULT_SCAN_BUFFER_SIZE = 262144;
    private static final int MAX_SCAN_BUFFER_SIZE = 0x200000;
    private static final String CLASS_FILE_SUFFIX = ".class";
    private ClassLoader classLoader;
    private String classPath;
    private File classRegistryFile;
    private int nextEntryOfs = -1;
    private Map libraries = new HashMap();
    private Hashtable classes;
    private Map subClasses;
    private Map innerClasses;
    private int readBufferSize = 131072;
    private byte[] readBuf;
    private ClassScanner classScanner;
    private byte[] scanBuf;
    private ClassRegistryExec classRegistryExec;
    private Method getParameterNamesMethod;
    private static final Logger logger = Logger.getLogger(InfectionClassRegistry.class.getName());

    public InfectionClassRegistry(ClassLoader classLoader, String classPath, File classRegistryFile) {
        this.setClassLoader(classLoader);
        this.setClassPath(classPath);
        this.setClassRegistryFile(classRegistryFile);
        this.initGetMethodParameterNames();
    }

    protected void addClassDescriptor(ClassDescriptor entry) {
        String outerClassName;
        String[] interfaceClassNames;
        String className = entry.getClassName();
        if (className == null) {
            return;
        }
        this.classes.put(className, entry);
        String superClassName = entry.getSuperClassName();
        if (superClassName != null) {
            this.registerSubClass(superClassName, className);
        }
        if ((interfaceClassNames = entry.getInterfaceClassNames()) != null) {
            int count = interfaceClassNames.length;
            for (int c = 0; c < count; ++c) {
                this.registerSubClass(interfaceClassNames[c], className);
            }
        }
        if ((outerClassName = entry.getOuterClassName()) != null) {
            this.registerInnerClass(outerClassName, className);
        }
    }

    public Class getClass(String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(className);
    }

    public ClassDescriptor getClassDescriptor(String className) {
        if (this.classes == null) {
            this.initClassRegistry();
        }
        return (ClassDescriptor)this.classes.get(className);
    }

    public Enumeration getClassDescriptors() {
        if (this.classes == null) {
            this.initClassRegistry();
        }
        return this.classes.elements();
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class[] getInnerClasses(String className) {
        String[] names = this.getInnerClassNames(className);
        if (names == null) {
            return null;
        }
        Class[] classes = new Class[names.length];
        for (int c = 0; c < classes.length; ++c) {
            try {
                classes[c] = this.getClass(names[c]);
                continue;
            }
            catch (ClassNotFoundException e) {
                classes[c] = null;
            }
        }
        return classes;
    }

    public String[] getInnerClassNames(String className) {
        Vector v;
        if (this.classes == null) {
            this.initClassRegistry();
        }
        int count = (v = (Vector)this.innerClasses.get(className)) == null ? 0 : v.size();
        String[] rc = new String[count];
        for (int c = 0; c < count; ++c) {
            rc[c] = String.valueOf(v.get(c));
        }
        return rc;
    }

    public String[] getInterfaceNames(String className) {
        ClassDescriptor entry = this.getClassDescriptor(className);
        return entry == null ? null : entry.getInterfaceClassNames();
    }

    public Class[] getInterfaces(String className) {
        String[] names = this.getInterfaceNames(className);
        if (names == null) {
            return null;
        }
        Class[] classes = new Class[names.length];
        for (int c = 0; c < classes.length; ++c) {
            try {
                classes[c] = this.getClass(names[c]);
                continue;
            }
            catch (ClassNotFoundException e) {
                classes[c] = null;
            }
        }
        return classes;
    }

    public Class getOuterClass(String className) throws ClassNotFoundException {
        String outerClassName = this.getOuterClassName(className);
        return outerClassName == null ? null : this.getClass(outerClassName);
    }

    public String getOuterClassName(String className) {
        ClassDescriptor entry = this.getClassDescriptor(className);
        return entry == null ? null : entry.getOuterClassName();
    }

    public Class[] getSubClasses(String className) {
        String[] names = this.getSubClassNames(className);
        if (names == null) {
            return null;
        }
        Class[] classes = new Class[names.length];
        for (int c = 0; c < classes.length; ++c) {
            try {
                classes[c] = this.getClass(names[c]);
                continue;
            }
            catch (ClassNotFoundException e) {
                classes[c] = null;
            }
        }
        return classes;
    }

    public String[] getSubClassNames(String className) {
        Vector v;
        if (this.classes == null) {
            this.initClassRegistry();
        }
        int count = (v = (Vector)this.subClasses.get(className)) == null ? 0 : v.size();
        String[] rc = new String[count];
        for (int c = 0; c < count; ++c) {
            rc[c] = String.valueOf(v.get(c));
        }
        return rc;
    }

    public Class getSuperClass(String className) throws ClassNotFoundException {
        String superClassName = this.getSuperClassName(className);
        return superClassName == null ? null : this.getClass(superClassName);
    }

    public String getSuperClassName(String className) {
        ClassDescriptor entry = this.getClassDescriptor(className);
        return entry == null ? null : entry.getSuperClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initClassRegistry() {
        if (this.classes != null) {
            return;
        }
        Logger log = logger;
        this.classRegistryExec = new ClassRegistryExec();
        this.classRegistryExec.setClassRegistryProgress(0.0);
        this.classRegistryExec.setStartMillis(System.currentTimeMillis());
        this.classRegistryExec.setRunning(true);
        ExecutionManager execMan = Platform.getInstance().getExecutionManager();
        if (execMan != null) {
            execMan.addExecution((Execution)this.classRegistryExec);
            this.classRegistryExec.fireExecutionStarted();
        }
        this.classes = new Hashtable();
        this.subClasses = new HashMap();
        this.innerClasses = new HashMap();
        this.readBuf = new byte[this.readBufferSize];
        long ms = -System.currentTimeMillis();
        try {
            String javaHome;
            log.info("Reading class registry: " + this.classRegistryFile);
            if (this.classRegistryFile != null && this.classRegistryFile.exists()) {
                try {
                    this.nextEntryOfs = (int)this.classRegistryFile.length();
                    boolean deleteFile = false;
                    FileInputStream in = new FileInputStream(this.classRegistryFile);
                    try {
                        DataInputStream din = new DataInputStream(in);
                        if (!this.readClassRegistry(din)) {
                            deleteFile = true;
                        }
                        din.close();
                    }
                    finally {
                        in.close();
                    }
                    if (deleteFile) {
                        this.classRegistryFile.delete();
                        this.nextEntryOfs = -1;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            log.info("Libraries in registry: " + this.libraries.size());
            this.classRegistryExec.setClassRegistryProgress(0.05);
            if (this.classPath == null) {
                this.classPath = "";
            }
            if ((javaHome = System.getProperty("java.home")) != null) {
                File javaLibDir;
                log.fine("JavaHome: " + javaHome);
                File javaHomeDir = new File(javaHome);
                if (javaHomeDir.exists() && (javaLibDir = new File(javaHomeDir, "lib")).exists()) {
                    log.fine("Lib directory: " + javaLibDir);
                    File[] files = javaLibDir.listFiles();
                    for (int c = 0; c < files.length; ++c) {
                        String path = files[c].getPath();
                        if (!path.endsWith(".jar")) continue;
                        log.finer("System library: " + path);
                        if (!this.classPath.endsWith(File.pathSeparator)) {
                            this.classPath = this.classPath + File.pathSeparator;
                        }
                        this.classPath = this.classPath + path;
                    }
                }
            }
            this.classRegistryExec.setClassRegistryProgress(0.1);
            String[] cp = this.parseClassPath(this.classPath);
            for (int c = 0; c < cp.length; ++c) {
                double progress = 0.1 + 0.9 * (double)c / (double)cp.length;
                this.classRegistryExec.setClassRegistryProgress(progress);
                this.classRegistryExec.setStatus("" + cp[c]);
                try {
                    File file = new File(cp[c]);
                    if (file.exists()) {
                        String path = file.getAbsolutePath();
                        if (file.isFile()) {
                            log.fine("Scan archive: " + path);
                            long flen = file.length();
                            long crc = this.computeChecksum(file, this.readBuf);
                            log.finer("   -> Size: " + flen);
                            log.finer("   -> Checksum: " + crc);
                            LibraryEntry search = new LibraryEntry(path, flen, crc, 0, 0);
                            LibraryEntry entry = (LibraryEntry)this.libraries.get(search);
                            if (entry != null) {
                                int ofs = entry.getDataOfs();
                                int len = entry.getDataLen();
                                log.finer("Reading entry: " + entry + " => offset=" + ofs);
                                byte[] data = new byte[len];
                                RandomAccessFile raf = new RandomAccessFile(this.classRegistryFile, "r");
                                try {
                                    raf.seek(ofs);
                                    raf.readFully(data);
                                }
                                finally {
                                    raf.close();
                                }
                                ByteArrayInputStream bin = new ByteArrayInputStream(data, 0, len);
                                List descrList = this.parseClassDescriptors(entry, bin);
                                bin.close();
                                int num = descrList.size();
                                for (int k = 0; k < num; ++k) {
                                    this.addClassDescriptor((ClassDescriptor)descrList.get(k));
                                }
                                continue;
                            }
                            List descrList = this.scanJarFile(file);
                            int num = descrList.size();
                            for (int k = 0; k < num; ++k) {
                                this.addClassDescriptor((ClassDescriptor)descrList.get(k));
                            }
                            this.appendLibraryEntry(search, descrList);
                            continue;
                        }
                        log.fine("Scan directory: " + path);
                        this.scanClassFiles(file, file);
                        continue;
                    }
                    log.info(" - File not found: " + cp[c]);
                    continue;
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            this.classRegistryExec.setClassRegistryProgress(1.0);
        }
        finally {
            if (execMan != null) {
                this.classRegistryExec.setRunning(false);
                this.classRegistryExec.fireExecutionStopped();
                execMan.removeExecution((Execution)this.classRegistryExec);
            }
            this.readBuf = null;
            this.scanBuf = null;
        }
        log.info("" + this.classes.size() + " classes scanned in " + (ms += System.currentTimeMillis()) + " ms.");
    }

    public Object instantiate(Class beanClass) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        return Tools.newInstance((Class)beanClass);
    }

    public Object instantiate(Class beanClass, Parameter[] constructorParams) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        int count = constructorParams.length;
        Class[] paramTypes = new Class[count];
        Object[] paramValues = new Object[count];
        for (int c = 0; c < count; ++c) {
            paramTypes[c] = constructorParams[c].getType();
            paramValues[c] = constructorParams[c].getValue();
        }
        Constructor constructor = beanClass.getConstructor(paramTypes);
        return constructor.newInstance(paramValues);
    }

    protected void registerInnerClass(String className, String innerClassName) {
        if (className == null || innerClassName == null) {
            return;
        }
        Vector<String> sub = (Vector<String>)this.innerClasses.get(className);
        if (sub == null) {
            sub = new Vector<String>();
            this.innerClasses.put(className, sub);
        }
        if (!sub.contains(innerClassName)) {
            sub.addElement(innerClassName);
        }
    }

    protected void registerSubClass(String className, String subClassName) {
        if (className == null || subClassName == null) {
            return;
        }
        Vector<String> sub = (Vector<String>)this.subClasses.get(className);
        if (sub == null) {
            sub = new Vector<String>();
            this.subClasses.put(className, sub);
        }
        if (!sub.contains(subClassName)) {
            sub.addElement(subClassName);
        }
    }

    protected void removeClassDescriptor(ClassDescriptor entry) {
        Vector sub;
        String superClassName;
        String className = entry.getClassName();
        this.classes.remove(className);
        if (entry != null && (superClassName = entry.getSuperClassName()) != null && (sub = (Vector)this.subClasses.get(superClassName)) != null) {
            sub.removeElement(className);
            if (sub.isEmpty()) {
                this.subClasses.remove(superClassName);
            }
        }
    }

    protected void setClassLoader(ClassLoader newClassLoader) {
        this.classLoader = newClassLoader;
    }

    protected String getClassPath() {
        return this.classPath;
    }

    protected void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public byte[] getJavaByteCode(Class clazz) throws Exception {
        return null;
    }

    public byte[] getJavaSourceCode(Class clazz) throws Exception {
        return null;
    }

    protected File getClassRegistryFile() {
        return this.classRegistryFile;
    }

    protected void setClassRegistryFile(File classRegistryFile) {
        this.classRegistryFile = classRegistryFile;
    }

    protected String[] parseClassPath(String cp) {
        if (cp == null) {
            return new String[0];
        }
        String sep = File.pathSeparator;
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(cp, sep, false);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s == null) continue;
            list.add(s);
        }
        String[] rc = new String[list.size()];
        rc = list.toArray(rc);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long computeChecksum(File f, byte[] buf) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        try {
            int n;
            CRC32 crc = new CRC32();
            while ((n = fin.read(buf)) >= 0) {
                crc.update(buf, 0, n);
            }
            long l = crc.getValue();
            return l;
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List scanJarFile(File file) throws Exception {
        Logger log = logger;
        if (this.scanBuf == null) {
            this.scanBuf = new byte[262144];
        }
        ArrayList<ClassDescriptor> classDescriptors = new ArrayList<ClassDescriptor>();
        ZipFile zip = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze = en.nextElement();
                String name = ze.getName();
                if (name == null || !name.endsWith(CLASS_FILE_SUFFIX)) continue;
                String cname = name.substring(0, name.length() - CLASS_FILE_SUFFIX.length());
                cname = cname.replace('/', '.');
                try {
                    InputStream in = zip.getInputStream(ze);
                    int len = 0;
                    try {
                        int n;
                        while ((n = in.read(this.readBuf, 0, this.readBuf.length)) >= 0) {
                            if (len + n > this.scanBuf.length) {
                                int x = Math.max(len + n, this.scanBuf.length * 2);
                                if (x > 0x200000) {
                                    throw new RuntimeException("Scan buffer size limit reached: " + x + " > " + 0x200000);
                                }
                                this.growScanBuf(len, x);
                            }
                            System.arraycopy(this.readBuf, 0, this.scanBuf, len, n);
                            len += n;
                        }
                    }
                    finally {
                        in.close();
                    }
                    ClassDescriptor descr = this.getClassScanner().createClassDescriptor(cname, this.scanBuf, 0, len);
                    if (descr == null) {
                        throw new NullPointerException("ClassDescriptor: " + cname);
                    }
                    classDescriptors.add(descr);
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "Error while scanning class: " + cname, e);
                }
            }
        }
        finally {
            zip.close();
        }
        return classDescriptors;
    }

    protected ClassScanner createClassScanner() {
        ClassScanner scanner = new ClassScanner();
        return scanner;
    }

    protected ClassScanner getClassScanner() {
        if (this.classScanner == null) {
            this.setClassScanner(this.createClassScanner());
        }
        return this.classScanner;
    }

    protected void setClassScanner(ClassScanner classScanner) {
        this.classScanner = classScanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void scanClassFiles(File base, File dir) throws Exception {
        Logger log = logger;
        File[] files = dir.listFiles();
        int num = files.length;
        String basePath = base.getPath();
        int baseLen = basePath.length();
        for (int c = 0; c < num; ++c) {
            File f = files[c];
            if (f.isFile()) {
                String path = f.getPath();
                if (!path.endsWith(CLASS_FILE_SUFFIX)) continue;
                String cname = path.substring(0, path.length() - CLASS_FILE_SUFFIX.length());
                if (cname.startsWith(basePath) && (cname = cname.substring(baseLen)).startsWith(File.separator)) {
                    cname = cname.substring(File.separator.length());
                }
                cname = cname.replace(File.separatorChar, '.');
                if (this.scanBuf == null) {
                    this.scanBuf = new byte[262144];
                }
                try {
                    FileInputStream fin = new FileInputStream(f);
                    int len = 0;
                    try {
                        int n;
                        while ((n = fin.read(this.readBuf, 0, this.readBuf.length)) >= 0) {
                            if (len + n > this.scanBuf.length) {
                                int x = Math.max(len + n, this.scanBuf.length * 2);
                                if (x > 0x200000) {
                                    throw new RuntimeException("Scan buffer size limit reached: " + x + " > " + 0x200000);
                                }
                                this.growScanBuf(len, x);
                            }
                            System.arraycopy(this.readBuf, 0, this.scanBuf, len, n);
                            len += n;
                        }
                    }
                    finally {
                        fin.close();
                    }
                    ClassDescriptor descr = this.getClassScanner().createClassDescriptor(cname, this.scanBuf, 0, len);
                    if (descr == null) {
                        throw new NullPointerException("ClassDescriptor: " + cname);
                    }
                    this.addClassDescriptor(descr);
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "Error while scanning class: " + cname, e);
                }
                continue;
            }
            this.scanClassFiles(base, f);
        }
    }

    protected void growScanBuf(int len, int newSize) {
        byte[] buf = new byte[newSize];
        System.arraycopy(this.scanBuf, 0, buf, 0, len);
        this.scanBuf = buf;
    }

    protected boolean readClassRegistry(DataInput in) throws IOException {
        int n;
        this.libraries.clear();
        int magic = in.readInt();
        if (magic != 37583453) {
            throw new StreamCorruptedException("Invalid file magic: " + magic + " != " + 37583453);
        }
        int version = in.readInt();
        if (version != 2) {
            if (version < 2) {
                logger.fine("WARNING: Invalid file version: " + version + " != " + 2);
                return false;
            }
            throw new IOException("Invalid file version: " + version + " != " + 2);
        }
        int pos = 12;
        int headerSize = in.readInt();
        if (pos < headerSize && in.skipBytes(n = headerSize - pos) != n) {
            throw new IOException("Unable to skip header: " + n + " bytes.");
        }
        pos = headerSize;
        boolean todo = true;
        while (todo) {
            int type = in.readInt();
            pos += 4;
            switch (type) {
                case 367954943: {
                    int entryHeaderSize = in.readInt();
                    int pathLen = in.readChar();
                    char[] ch = new char[pathLen];
                    for (int x = 0; x < pathLen; ++x) {
                        ch[x] = in.readChar();
                    }
                    String path = new String(ch);
                    long fsize = in.readLong();
                    long crc = in.readLong();
                    int dataLen = in.readInt();
                    LibraryEntry entry = new LibraryEntry(path, fsize, crc, pos += entryHeaderSize, dataLen);
                    this.libraries.put(entry, entry);
                    if (in.skipBytes(dataLen) != dataLen) {
                        throw new IOException("Unable to skip: " + dataLen + " bytes.");
                    }
                    pos += dataLen;
                    break;
                }
                case 948369387: {
                    todo = false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendLibraryEntry(LibraryEntry entry, List classDescriptors) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.classRegistryFile, "rw");
        try {
            String path = entry.getPath();
            long fsize = entry.getSize();
            long check = entry.getChecksum();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ZipOutputStream zout = new ZipOutputStream(bout);
            ZipEntry ze = new ZipEntry("data");
            zout.putNextEntry(ze);
            DataOutputStream dout = new DataOutputStream(zout);
            int n = classDescriptors.size();
            dout.writeInt(n);
            for (int c = 0; c < n; ++c) {
                ClassDescriptor descr = (ClassDescriptor)classDescriptors.get(c);
                dout.writeUTF(descr.getClassName());
                dout.writeInt(descr.getModifiers());
                dout.writeInt(descr.getFlags());
                String supr = descr.getSuperClassName();
                if (supr == null) {
                    supr = "";
                }
                dout.writeUTF(supr);
                String outr = descr.getOuterClassName();
                if (outr == null) {
                    outr = "";
                }
                dout.writeUTF(outr);
                String[] ifcs = descr.getInterfaceClassNames();
                int ifcCount = ifcs == null ? 0 : ifcs.length;
                dout.writeInt(ifcCount);
                for (int k = 0; k < ifcCount; ++k) {
                    dout.writeUTF(ifcs[k]);
                }
            }
            dout.flush();
            zout.closeEntry();
            zout.flush();
            bout.flush();
            byte[] data = bout.toByteArray();
            bout.close();
            int dataLen = data.length;
            if (this.nextEntryOfs <= 0) {
                if (raf.length() > 0L) {
                    throw new IOException("Cannot write first entry because file already exists: " + this.classRegistryFile);
                }
                raf.seek(0L);
                int headerSize = 12;
                raf.writeInt(37583453);
                raf.writeInt(2);
                raf.writeInt(headerSize);
                this.nextEntryOfs = headerSize;
            }
            raf.seek(this.nextEntryOfs);
            raf.writeInt(367954943);
            int entryHeaderSize = 6 + path.length() * 2 + 8 + 8 + 4;
            raf.writeInt(entryHeaderSize);
            raf.writeChar(path.length());
            raf.writeChars(path);
            raf.writeLong(fsize);
            raf.writeLong(check);
            raf.writeInt(dataLen);
            raf.write(data, 0, dataLen);
            this.nextEntryOfs = (int)raf.getFilePointer();
            raf.writeInt(948369387);
        }
        finally {
            raf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List parseClassDescriptors(LibraryEntry entry, InputStream in) throws IOException {
        Logger log = logger;
        ArrayList<ClassDescriptorImpl> list = new ArrayList<ClassDescriptorImpl>();
        ZipInputStream zin = new ZipInputStream(in);
        ZipEntry ze = zin.getNextEntry();
        log.finer("ZipEntry: " + ze);
        DataInputStream din = new DataInputStream(zin);
        try {
            int count = din.readInt();
            for (int c = 0; c < count; ++c) {
                String outr;
                String className = din.readUTF();
                int modifiers = din.readInt();
                int flags = din.readInt();
                String supr = din.readUTF();
                if (supr.length() < 1) {
                    supr = null;
                }
                if ((outr = din.readUTF()).length() < 1) {
                    outr = null;
                }
                int numIfcs = din.readInt();
                String[] ifcs = null;
                if (numIfcs > 0) {
                    ifcs = new String[numIfcs];
                    for (int k = 0; k < numIfcs; ++k) {
                        ifcs[k] = din.readUTF();
                    }
                }
                ClassDescriptorImpl descr = new ClassDescriptorImpl();
                descr.setClassName(className);
                descr.setModifiers(modifiers);
                descr.setFlags(flags);
                descr.setSuperClassName(supr);
                descr.setOuterClassName(outr);
                descr.setInterfaceClassNames(ifcs);
                list.add(descr);
            }
        }
        finally {
            din.close();
        }
        return list;
    }

    public boolean isTypeAssignableFrom(Class type, ClassDescriptor descr) {
        return this.isTypeAssignableFrom(type.getName(), descr);
    }

    public boolean isTypeAssignableFrom(String type, ClassDescriptor descr) {
        ClassDescriptor cd = this.getClassDescriptor(type);
        if (cd == null) {
            return false;
        }
        if (cd.isInterface()) {
            return this.isInterfaceAssignableFrom(cd, descr);
        }
        return this.isClassAssignableFrom(cd, descr);
    }

    public boolean isTypeAssignableFrom(ClassDescriptor type, ClassDescriptor descr) {
        if (type.isInterface()) {
            return this.isInterfaceAssignableFrom(type, descr);
        }
        return this.isClassAssignableFrom(type, descr);
    }

    private boolean isClassAssignableFrom(ClassDescriptor type, ClassDescriptor descr) {
        if (type == null) {
            return false;
        }
        String typeName = type.getClassName();
        if (typeName.equals(descr.getClassName())) {
            return true;
        }
        String superName = descr.getSuperClassName();
        if (superName == null) {
            return false;
        }
        if (typeName.equals(superName)) {
            return true;
        }
        ClassDescriptor sup = this.getClassDescriptor(superName);
        if (sup != null) {
            return this.isClassAssignableFrom(type, sup);
        }
        return false;
    }

    private boolean isInterfaceAssignableFrom(ClassDescriptor type, ClassDescriptor descr) {
        String superName;
        if (type == null) {
            return false;
        }
        String typeName = type.getClassName();
        if (typeName.equals(descr.getClassName())) {
            return true;
        }
        String[] ifs = descr.getInterfaceClassNames();
        if (ifs != null) {
            int i;
            for (i = 0; i < ifs.length; ++i) {
                if (!typeName.equals(ifs[i])) continue;
                return true;
            }
            for (i = 0; i < ifs.length; ++i) {
                ClassDescriptor icd = this.getClassDescriptor(ifs[i]);
                if (icd == null || !this.isInterfaceAssignableFrom(type, icd)) continue;
                return true;
            }
        }
        if ((superName = descr.getSuperClassName()) == null) {
            return false;
        }
        if (superName.equals(descr.getClassName())) {
            return false;
        }
        ClassDescriptor sup = this.getClassDescriptor(superName);
        if (sup != null) {
            return this.isInterfaceAssignableFrom(type, sup);
        }
        return false;
    }

    public String[] getParameterNames(Constructor constr) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParameterNames(Method method) throws Exception {
        Class<?>[] paramTypes = method.getParameterTypes();
        int paramCount = paramTypes.length;
        if (paramCount < 1) {
            return null;
        }
        String className = method.getDeclaringClass().getName();
        String classFileName = className.replace('.', '/') + CLASS_FILE_SUFFIX;
        URL classURL = this.getClass().getResource("/" + classFileName);
        if (classURL != null) {
            logger.fine("Scanning class: " + classURL);
            InputStream in = classURL.openStream();
            try {
                String[] paramNames;
                DataInputStream din = new DataInputStream(in);
                ClassFile byteCode = new ClassFile();
                byteCode.setResolveMethodInfo(true);
                byteCode.read(className, din);
                ClassFile.MethodInfo methInfo = byteCode.getMethodInfo(method);
                if (methInfo != null && (paramNames = methInfo.getParameterNames()) != null && paramNames.length == paramCount) {
                    String[] stringArray = paramNames;
                    return stringArray;
                }
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    protected void initGetMethodParameterNames() {
        try {
            this.getParameterNamesMethod = Method.class.getMethod("getParameterNames", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.getParameterNamesMethod = null;
        }
        logger.fine("getParameterNames-Method: " + this.getParameterNamesMethod);
    }

    protected class ClassRegistryExec
    extends AbstractExecution {
        public ClassRegistryExec() {
            this.setName("Scanning classes");
            this.setDescription("Loading class registry");
        }

        protected void execute() throws Exception {
        }

        protected void setClassRegistryProgress(double progress) {
            super.setProgress(progress);
        }

        protected synchronized void fireExecutionStarted() {
            super.fireExecutionStarted();
        }

        protected synchronized void fireExecutionStopped() {
            super.fireExecutionStopped();
        }

        protected void setStartMillis(long newStartMillis) {
            super.setStartMillis(newStartMillis);
        }

        protected void setRunning(boolean running) {
            super.setRunning(running);
        }

        protected void setStatus(String newStatus) {
            super.setStatus(newStatus);
        }
    }

    protected static class LibraryEntry {
        private String path;
        private long size;
        private long checksum;
        private int dataOfs;
        private int dataLen;

        public LibraryEntry(String path, long size, long checksum, int dataOfs, int dataLen) {
            this.setPath(path);
            this.setSize(size);
            this.setChecksum(checksum);
            this.setDataOfs(dataOfs);
            this.setDataLen(dataLen);
        }

        public long getChecksum() {
            return this.checksum;
        }

        private void setChecksum(long checksum) {
            this.checksum = checksum;
        }

        public String getPath() {
            return this.path;
        }

        private void setPath(String path) {
            this.path = path;
        }

        public long getSize() {
            return this.size;
        }

        private void setSize(long size) {
            this.size = size;
        }

        public String toString() {
            return super.toString() + "[path=" + this.path + ", size=" + this.size + ", crc=" + this.checksum + "]";
        }

        public int hashCode() {
            return (int)(this.size * 23L + this.checksum * 13L + (long)this.path.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof LibraryEntry) {
                LibraryEntry e = (LibraryEntry)obj;
                if (!this.path.equals(e.getPath())) {
                    return false;
                }
                if (this.size != e.getSize()) {
                    return false;
                }
                return this.checksum == e.getChecksum();
            }
            return false;
        }

        public int getDataLen() {
            return this.dataLen;
        }

        private void setDataLen(int dataLen) {
            this.dataLen = dataLen;
        }

        public int getDataOfs() {
            return this.dataOfs;
        }

        private void setDataOfs(int dataOfs) {
            this.dataOfs = dataOfs;
        }
    }
}

