/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.platform.InfectionFileLocatorPanel;
import com.spacekiller.util.FileLocator;
import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;
import java.util.List;

public class InfectionFileLocator
implements FileLocator {
    public static final DefaultFileLocator DEFAULT_FILE_LOCATOR = new DefaultFileLocator();
    private List locators = new LinkedList();

    public InfectionFileLocator() {
        this.locators.add(DEFAULT_FILE_LOCATOR);
    }

    public File locateFile(String path) {
        List list = this.locators;
        do {
            for (FileLocator locator : list) {
                File file = locator.locateFile(path);
                if (file == null) continue;
                return file;
            }
        } while ((list = this.showFileLocatorDialog(path, list)) != null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List showFileLocatorDialog(String path, List locatorList) {
        InfectionFileLocatorPanel panel = new InfectionFileLocatorPanel();
        panel.setFilePath(path);
        if (!panel.showFileLocatorDialog()) {
            return null;
        }
        File selectedFile = panel.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        boolean recursive = panel.isRecursiveSearch();
        boolean remember = panel.isRememberDirectory();
        LinkedList<Object> newList = new LinkedList<Object>();
        if (selectedFile.exists() && selectedFile.isFile()) {
            newList.add(new TargetFileLocator(path, selectedFile));
        } else {
            newList.add(new SubPathFileLocator(selectedFile));
            if (recursive) {
                newList.add(new RecursiveFileLocator(selectedFile));
            }
        }
        if (remember) {
            InfectionFileLocator infectionFileLocator = this;
            synchronized (infectionFileLocator) {
                this.locators.addAll(newList);
            }
        }
        newList.addFirst(DEFAULT_FILE_LOCATOR);
        return newList;
    }

    public int getFileLocatorCount() {
        return this.locators.size();
    }

    public FileLocator getFileLocatorAt(int index) {
        return (FileLocator)this.locators.get(index);
    }

    public synchronized void addFileLocator(FileLocator locator) {
        this.addFileLocator(this.locators.size(), locator);
    }

    public synchronized void addFileLocator(int index, FileLocator locator) {
        if (locator == null) {
            return;
        }
        if (locator == this) {
            throw new IllegalArgumentException("Cannot add FileLocator to itself");
        }
        this.locators.add(index, locator);
    }

    public synchronized void removeFileLocator(FileLocator locator) {
        this.locators.remove(locator);
    }

    public synchronized void removeFileLocatorAt(int index) {
        this.locators.remove(index);
    }

    public synchronized void removeAllFileLocators() {
        this.locators.clear();
    }

    public static class RecursiveFileLocator
    implements FileLocator {
        private File root;

        public RecursiveFileLocator(File root) {
            this.root = root;
        }

        public File getRoot() {
            return this.root;
        }

        public void setRoot(File root) {
            this.root = root;
        }

        public File locateFile(String path) {
            File root = this.root;
            if (root == null) {
                return null;
            }
            if (!root.exists()) {
                return null;
            }
            if (!root.isDirectory()) {
                return null;
            }
            File file = new File(path);
            final String name = file.getName();
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.isFile() && name.equals(f.getName());
                }
            };
            return this.locateFileRecursive(root, filter);
        }

        protected File locateFileRecursive(File dir, FileFilter filter) {
            for (File file : dir.listFiles(filter)) {
                if (file.isDirectory()) {
                    if ((file = this.locateFileRecursive(file, filter)) == null) continue;
                    return file;
                }
                if (!file.isFile()) continue;
                return file;
            }
            return null;
        }
    }

    public static class SubPathFileLocator
    implements FileLocator {
        private File root;

        public SubPathFileLocator(File root) {
            this.root = root;
        }

        public File getRoot() {
            return this.root;
        }

        public void setRoot(File root) {
            this.root = root;
        }

        public File locateFile(String path) {
            File root = this.root;
            if (root == null) {
                return null;
            }
            if (!root.exists()) {
                return null;
            }
            if (!root.isDirectory()) {
                return null;
            }
            File file = new File(path);
            String fileName = file.getName();
            LinkedList<String> parentList = new LinkedList<String>();
            File parent = file.getParentFile();
            if (parent == null) {
                return null;
            }
            while (true) {
                String parentName = parent.getName();
                if ((parent = parent.getParentFile()) == null) break;
                parentList.addFirst(parentName);
            }
            int nParents = parentList.size();
            String[] parents = parentList.toArray(new String[nParents]);
            for (int k = 0; k <= nParents; ++k) {
                File f;
                File base = root;
                boolean found = true;
                for (int i = k; i < nParents; ++i) {
                    String dirName = parents[i];
                    File dir = new File(base, dirName);
                    if (!dir.exists() || !dir.isDirectory()) {
                        found = false;
                        break;
                    }
                    base = dir;
                    found = true;
                }
                if (!found || !(f = new File(base, fileName)).exists() || !f.isFile()) continue;
                return f;
            }
            return null;
        }
    }

    public static class TargetFileLocator
    implements FileLocator {
        private String sourcePath;
        private File targetFile;

        public TargetFileLocator(String sourcePath, File targetFile) {
            this.sourcePath = sourcePath;
            this.targetFile = targetFile;
        }

        public File locateFile(String path) {
            if (path.equals(this.sourcePath)) {
                return this.targetFile;
            }
            return null;
        }
    }

    public static class DefaultFileLocator
    implements FileLocator {
        public File locateFile(String path) {
            File file = new File(path);
            if (file.exists() && file.isFile()) {
                return file;
            }
            return null;
        }
    }
}

