/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionRuntime;
import com.spacekiller.infection.InfectionRuntimeListener;
import com.spacekiller.infection.InfectionRuntimeListenerAdapter;
import com.spacekiller.infection.old.ErrorDialog;
import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.platform.InfectionPreferencesConstants;
import com.spacekiller.infection.platform.PlatformRuntimeContext;
import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.FileType;
import com.spacekiller.util.FileTypeRegistry;
import com.spacekiller.util.PluginDescriptor;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.beans.BeanDropManager;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.CustomizerProvider;
import com.spacekiller.util.beans.DefaultBeansToolkit;
import com.spacekiller.util.beans.FileCustomizerProvider;
import com.spacekiller.util.beans.FileIconProvider;
import com.spacekiller.util.beans.IconProvider;
import com.spacekiller.util.beans.TypeMapping;
import com.spacekiller.util.beans.editors.ColorPropertyEditor;
import com.spacekiller.util.beans.editors.DimensionPropertyEditor;
import com.spacekiller.util.beans.editors.FileTargetPropertyEditor;
import com.spacekiller.util.beans.editors.LocalePropertyEditor;
import com.spacekiller.util.beans.editors.PaintPropertyEditor;
import com.spacekiller.util.beans.editors.PointPropertyEditor;
import com.spacekiller.util.beans.editors.RectanglePropertyEditor;
import com.spacekiller.util.beans.editors.URLPropertyEditor;
import com.spacekiller.util.platform.AbstractLauncher;
import com.spacekiller.util.platform.AbstractPlatform;
import com.spacekiller.util.platform.DefaultExecutionManager;
import com.spacekiller.util.platform.RuntimePluginDescriptor;
import com.spacekiller.util.swing.LookAndFeelManager;
import com.spacekiller.util.swing.LookAndFeelStyle;
import com.spacekiller.util.swing.LookAndFeelType;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchPlugin;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.spacekiller.util.workspace.WorkspacePlugin;
import com.spacekiller.util.workspace.WorkspaceUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.io.File;
import java.net.URL;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.undo.UndoManager;

public abstract class InfectionLauncher
extends AbstractLauncher
implements InfectionPreferencesConstants {
    public static final String INFECTION_XML = "infection.xml";
    private static final Logger logger = Logger.getLogger(InfectionLauncher.class.getName());
    private DefaultBeansToolkit defaultBeansToolkit;
    private boolean shutdown = false;

    protected InfectionLauncher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shutdown() throws Throwable {
        if (this.shutdown) {
            return;
        }
        InfectionLauncher infectionLauncher = this;
        synchronized (infectionLauncher) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        AbstractPlatform platform = this.getPlatform();
        if (platform != null && !platform.isShutdownInProgress()) {
            logger.fine("Shutdown Platform: " + platform);
            platform.shutdown();
        }
    }

    protected boolean shutdownNormally() {
        try {
            this.shutdown();
            return true;
        }
        catch (Throwable e) {
            this.handleException(e);
            return false;
        }
    }

    private void handleException(Throwable exception) {
        logger.log(Level.SEVERE, exception.getMessage(), exception);
    }

    public final void launch(String[] args) {
        InfectionRuntime runtime = null;
        try {
            runtime = Infection.getInstance().getInfectionRuntime();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            ErrorDialog.showErrorDialog((Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            this.launch(runtime);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error catched: " + e, e);
            ErrorDialog.showErrorDialog((Throwable)e);
            try {
                runtime.openUpdateManager();
            }
            catch (Throwable e2) {
                logger.log(Level.SEVERE, e2.getMessage(), e2);
            }
            throw new RuntimeException(e);
        }
    }

    protected final void launch(InfectionRuntime access) throws Exception {
        InfectionPlatform platform;
        boolean fine;
        boolean config;
        boolean info;
        Logger log;
        block47: {
            log = logger;
            info = log.isLoggable(Level.INFO);
            config = log.isLoggable(Level.CONFIG);
            fine = log.isLoggable(Level.FINE);
            if (fine) {
                log.fine("Infection Runtime: " + access);
            }
            access.setStartupProgress(0.1);
            try {
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    security.checkPermission(new AllPermission());
                }
            }
            catch (Throwable e) {
                if (!info) break block47;
                log.info("Note: AllPermissions not granted!");
            }
        }
        File platformHome = access.getWorkingDir();
        File dataDir = access.getDataDir();
        File logDir = access.getLogDir();
        File configDir = access.getConfigDir();
        File tempDir = access.getTempDir();
        if (fine) {
            log.fine("Working directory: " + platformHome);
            log.fine("Data directory:    " + dataDir);
            log.fine("Config directory:  " + configDir);
            log.fine("Log directory:     " + logDir);
            log.fine("Temp directory:    " + tempDir);
        }
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        ClassLoader platformClassLoader = this.getClass().getClassLoader();
        String infectionClassPath = access.getClassPath();
        if (infectionClassPath == null) {
            infectionClassPath = "";
        }
        if (fine) {
            log.fine("Infection classpath: " + infectionClassPath);
        }
        Thread hook = new Thread((Runnable)new PlatformShutdownHook(), "InfectionPlatformShutdownHook");
        Runtime.getRuntime().addShutdownHook(hook);
        Thread hook2 = new Thread(new PlatformShutdownHook());
        access.setShutdownHook(hook2);
        InfectionRuntimeListenerAdapter irl = new InfectionRuntimeListenerAdapter(){

            public boolean shutdownNormally() {
                return InfectionLauncher.this.shutdownNormally();
            }
        };
        access.setInfectionRuntimeListener((InfectionRuntimeListener)irl);
        access.setStartupProgress(0.2);
        ArrayList<PluginDescriptor> listPluginDescr = new ArrayList<PluginDescriptor>();
        long ms = -System.currentTimeMillis();
        ClassLoader[] pluginDescriptorLoaders = new ClassLoader[]{platformClassLoader};
        PluginDescriptor[] pluginDescriptorArray = this.lookupPluginDescriptors(pluginDescriptorLoaders);
        if (pluginDescriptorArray != null) {
            for (PluginDescriptor pluginDescriptor : pluginDescriptorArray) {
                if (pluginDescriptor == null) continue;
                listPluginDescr.add(pluginDescriptor);
                if (!config) continue;
                log.config(" - PluginDescriptor: " + pluginDescriptor);
            }
        }
        if (fine) {
            log.fine("PluginDescriptor(s): " + listPluginDescr.size());
        }
        access.setStartupProgress(0.3);
        ms += System.currentTimeMillis();
        int pluginCount = listPluginDescr.size();
        if (fine) {
            log.fine("Plugins loaded: " + pluginCount + " (" + ms + " ms.)");
        }
        RuntimePluginDescriptor[] pluginDescrs = new RuntimePluginDescriptor[pluginCount];
        for (int c = 0; c < pluginCount; ++c) {
            RuntimePluginDescriptor rd;
            PluginDescriptor pd = (PluginDescriptor)listPluginDescr.get(c);
            platform = null;
            pluginDescrs[c] = rd = new RuntimePluginDescriptor(platform, pd);
        }
        try {
            DefaultBeansToolkit dbtk;
            if (fine) {
                log.fine("Starting the Infection Platform...");
            }
            ms = -System.currentTimeMillis();
            DefaultExecutionManager execManager = new DefaultExecutionManager();
            PlatformRuntimeContext runtimeContext = new PlatformRuntimeContext();
            runtimeContext.setExecutionManager((ExecutionManager)execManager);
            platform = new InfectionPlatform(access, platformHome, dataDir, logDir, configDir, tempDir, platformClassLoader, infectionClassPath, pluginDescrs, runtimeContext, (ExecutionManager)execManager);
            this.setPlatform(platform);
            access.setStartupProgress(0.4);
            platform.getInstanceId();
            BeansToolkit btk = platform.getBeansToolkit();
            if (config) {
                log.config("BeansToolkit: " + btk);
            }
            this.defaultBeansToolkit = dbtk = (DefaultBeansToolkit)btk;
            this.initBeansToolkit(dbtk);
            WorkspacePlugin workspacePlugin = WorkbenchUtilities.getWorkspacePlugin();
            if (config) {
                log.config("WorkspacePlugin: " + workspacePlugin);
            }
            FileCustomizerProvider fileCustomizerProvider = null;
            if (workspacePlugin != null) {
                if (config) {
                    log.config("CipherManager: " + workspacePlugin.getCipherManager());
                }
                fileCustomizerProvider = this.getFileCustomizerProvider();
                if (config) {
                    log.config("FileCustomizerProvider: " + fileCustomizerProvider);
                }
                BeanContext fileTypes = workspacePlugin.getFileTypes();
                if (config) {
                    log.config("FileTypes: " + fileTypes.size());
                }
                fileTypes.addBeanContextMembershipListener(new FileTypeHandler());
                for (FileType fileType : fileTypes) {
                    this.installFileType(fileType);
                }
            }
            WorkbenchPlugin workbenchPlugin = WorkbenchUtilities.getWorkbenchPlugin();
            if (config) {
                log.config("WorkbenchPlugin: " + workbenchPlugin);
            }
            LookAndFeelManager lafManager = workbenchPlugin.getLookAndFeelManager();
            workbenchPlugin.getLookAndFeelTypes();
            this.initLookAndFeel(lafManager);
            access.setStartupProgress(0.5);
            if (workbenchPlugin != null) {
                BeanContext lafTypes = workbenchPlugin.getLookAndFeelTypes();
                if (config) {
                    log.config("LookAndFeelTypes: " + lafTypes.size());
                }
                BeanContext iconProviders = workbenchPlugin.getIconProviders();
                if (config) {
                    log.config("IconProviders: " + iconProviders.size());
                }
                iconProviders.addBeanContextMembershipListener(new IconProviderHandler());
                for (IconProvider iconProvider : iconProviders) {
                    this.installIconProvider(iconProvider);
                }
                BeanContext customizerProviders = workbenchPlugin.getCustomizerProviders();
                if (config) {
                    log.config("CustomizerProviders: " + customizerProviders.size());
                }
                customizerProviders.addBeanContextMembershipListener(new CustomizerProviderHandler());
                for (CustomizerProvider customizerProvider : customizerProviders) {
                    this.installCustomizerProvider(customizerProvider);
                }
                FileIconProvider fileIconProvider = this.getFileIconProvider();
                if (config) {
                    log.config("FileIconProvider: " + fileIconProvider);
                }
                if (fileIconProvider != null) {
                    iconProviders.add(fileIconProvider);
                }
                if (fileCustomizerProvider != null) {
                    customizerProviders.add(fileCustomizerProvider);
                }
                access.setStartupProgress(0.6);
                BeanContext views = workbenchPlugin.getViewProviders();
                if (config) {
                    log.config("ViewProviders: " + views.size());
                }
                access.setStartupProgress(0.7);
                BeanContext tools = workbenchPlugin.getTools();
                if (config) {
                    log.config("Tools: " + tools.size());
                }
                access.setStartupProgress(0.8);
                BeanContext prefPages = workbenchPlugin.getPreferencesPages();
                if (config) {
                    log.config("PreferencesPages: " + prefPages.size());
                }
            }
            access.setStartupProgress(0.9);
            Workbench workbench = null;
            if (!platform.isHeadless()) {
                workbench = this.getMainWorkbench();
            }
            access.setStartupProgress(1.0);
            if (platform.isHeadless()) {
                if (info) {
                    log.info("Headless mode.");
                }
            } else if (workbench != null) {
                if (info) {
                    log.info("Showing workbench: " + workbench);
                }
                this.showWorkbench(workbench);
            }
            access.closeSplashWindow();
            ms += System.currentTimeMillis();
            if (info) {
                log.info("Platform initialized in " + ms + " ms.");
            }
            this.startPlugins(platform);
            this.postStartup(platform);
            return;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "" + e, e);
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "" + e, e);
            throw new Exception("" + e);
        }
    }

    protected abstract UndoManager getDefaultUndoManager() throws Exception;

    protected abstract ClipboardManager getDefaultClipboardManager() throws Exception;

    protected abstract BeanDropManager getDefaultBeanDropManager() throws Exception;

    protected abstract FileCustomizerProvider getFileCustomizerProvider() throws Exception;

    protected abstract FileIconProvider getFileIconProvider() throws Exception;

    protected abstract Workbench getMainWorkbench() throws Exception;

    protected void showWorkbench(Workbench workbench) throws Exception {
        workbench.show();
    }

    protected void initBeansToolkit(DefaultBeansToolkit dbtk) throws Exception {
        BeanContext customs;
        dbtk.setUndoManager(this.getDefaultUndoManager());
        dbtk.setClipboardManager(this.getDefaultClipboardManager());
        dbtk.setBeanDropSupport((BeanDropSupport)this.getDefaultBeanDropManager());
        this.initCommonPropertyEditors(dbtk);
        WorkspacePlugin wsPlugin = WorkspaceUtilities.getWorkspacePlugin();
        BeanContext propEditors = wsPlugin.getPropertyEditors();
        if (propEditors != null) {
            for (TypeMapping mapping : propEditors) {
                if (mapping == null) continue;
                String beanClassName = mapping.getSource();
                String propertyEditorClassName = mapping.getTarget();
                logger.fine(" - PropertyEditor: type=" + beanClassName + " > editor=" + propertyEditorClassName);
                if (beanClassName == null || propertyEditorClassName == null) continue;
                dbtk.registerPropertyEditorClass(beanClassName, propertyEditorClassName);
            }
        }
        if ((customs = wsPlugin.getCustomizers()) != null) {
            for (TypeMapping mapping : customs) {
                if (mapping == null) continue;
                String beanClassName = mapping.getSource();
                String customizerClassName = mapping.getTarget();
                logger.fine(" - Customizer: type=" + beanClassName + " > customizer=" + customizerClassName);
                if (beanClassName == null || customizerClassName == null) continue;
                dbtk.registerCustomizerClass(beanClassName, customizerClassName);
            }
        }
    }

    protected void initCommonPropertyEditors(DefaultBeansToolkit dbtk) {
        dbtk.registerPropertyEditorClass(Point.class, PointPropertyEditor.class);
        dbtk.registerPropertyEditorClass(Dimension.class, DimensionPropertyEditor.class);
        dbtk.registerPropertyEditorClass(Rectangle.class, RectanglePropertyEditor.class);
        dbtk.registerPropertyEditorClass(Locale.class, LocalePropertyEditor.class);
        dbtk.registerPropertyEditorClass(File.class, FileTargetPropertyEditor.class);
        dbtk.registerPropertyEditorClass(URL.class, URLPropertyEditor.class);
        dbtk.registerPropertyEditorClass(Color.class, ColorPropertyEditor.class);
        dbtk.registerPropertyEditorClass(Paint.class, PaintPropertyEditor.class);
    }

    protected void installFileType(FileType type) throws Exception {
        FileCustomizerProvider provider;
        if (type == null) {
            return;
        }
        FileTypeRegistry registry = this.getPlatform().getFileTypeRegistry();
        if (registry != null) {
            registry.registerFileType(type);
        }
        if ((provider = this.getFileCustomizerProvider()) != null) {
            provider.registerFileType(type);
        }
    }

    protected void uninstallFileType(FileType type) throws Exception {
        FileCustomizerProvider provider;
        if (type == null) {
            return;
        }
        FileTypeRegistry registry = this.getPlatform().getFileTypeRegistry();
        if (registry != null) {
            registry.unregisterFileType(type);
        }
        if ((provider = this.getFileCustomizerProvider()) != null) {
            provider.unregisterFileType(type);
        }
    }

    final void installIconProvider(IconProvider ip) throws Exception {
        Class[] beanTypes = ip.getBeanTypes();
        int numTypes = beanTypes == null ? 0 : beanTypes.length;
        logger.fine("register IconProvider: " + ip + " >> " + numTypes + " bean-types.");
        for (int j = 0; j < numTypes; ++j) {
            this.defaultBeansToolkit.registerIconProvider(beanTypes[j], ip);
        }
        logger.fine("IconProvider registered: " + ip);
    }

    final void uninstallIconProvider(IconProvider ip) throws Exception {
        logger.fine("unregister IconProvider: " + ip);
        Class[] beanTypes = ip.getBeanTypes();
        int numTypes = beanTypes == null ? 0 : beanTypes.length;
        for (int j = 0; j < numTypes; ++j) {
            this.defaultBeansToolkit.unregisterIconProvider(beanTypes[j]);
        }
    }

    final void installCustomizerProvider(CustomizerProvider cp) throws Exception {
        Class[] beanTypes = cp.getBeanTypes();
        int numTypes = beanTypes == null ? 0 : beanTypes.length;
        logger.fine(" - registering CustomizerProvider: " + cp + " >> " + numTypes + " bean-types.");
        for (int j = 0; j < numTypes; ++j) {
            this.defaultBeansToolkit.registerCustomizerProvider(beanTypes[j], cp);
        }
        logger.fine("CustomizerProvider registered: " + cp);
    }

    final void uninstallCustomizerProvider(CustomizerProvider cp) throws Exception {
        logger.fine("unregister CustomizerProvider: " + cp);
        Class[] beanTypes = cp.getBeanTypes();
        int numTypes = beanTypes == null ? 0 : beanTypes.length;
        for (int j = 0; j < numTypes; ++j) {
            this.defaultBeansToolkit.unregisterCustomizerProvider(beanTypes[j], cp);
        }
    }

    protected final DefaultBeansToolkit getDefaultBeansToolkit() {
        return this.defaultBeansToolkit;
    }

    protected void initLookAndFeel(LookAndFeelManager lafManager) throws Exception {
        LookAndFeelType[] lafTypes = lafManager.getLookAndFeelTypes();
        logger.fine("LookAndFeelType(s): " + lafTypes.length);
        String lafTypeName = null;
        String lafStyleName = null;
        PreferencesRegistry reg = this.getPlatform().getPreferencesRegistry();
        Preferences lafPrefs = reg.getPreferences("platform.look-and-feel");
        if (lafPrefs != null) {
            lafTypeName = "" + lafPrefs.getObject("laf.type");
            lafStyleName = "" + lafPrefs.getObject("laf.style");
        }
        if (lafTypeName == null) {
            lafTypeName = "Bene";
            lafStyleName = "btex07";
        }
        LookAndFeelType lafType = null;
        LookAndFeelStyle lafStyle = null;
        block0: for (int c = 0; c < lafTypes.length; ++c) {
            String lafName = lafTypes[c].getName();
            if (!lafTypeName.equals(lafName)) continue;
            lafType = lafTypes[c];
            LookAndFeelStyle st = null;
            int numStyles = lafType.getStyleCount();
            for (int s = 0; s < numStyles; ++s) {
                st = lafType.getStyleAt(s);
                if (!lafStyleName.equals(st.getName())) continue;
                lafStyle = st;
                break block0;
            }
            break;
        }
        if (lafType != null) {
            LookAndFeel laf = lafType.getLookAndFeel(lafStyle);
            logger.fine("Setting LookAndFeel: " + laf);
            lafManager.setLookAndFeel(laf);
        }
    }

    protected void startPlugins(InfectionPlatform platform) throws Exception {
        platform.startPlugins();
    }

    protected void postStartup(InfectionPlatform platform) throws Exception {
        platform.postStartup();
    }

    protected class CustomizerProviderHandler
    implements BeanContextMembershipListener {
        protected CustomizerProviderHandler() {
        }

        @Override
        public void childrenAdded(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object bean = i.next();
                if (bean == null || !(bean instanceof CustomizerProvider)) continue;
                try {
                    InfectionLauncher.this.installCustomizerProvider((CustomizerProvider)bean);
                }
                catch (Exception e) {
                    InfectionLauncher.this.handleException(e);
                }
            }
        }

        @Override
        public void childrenRemoved(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object bean = i.next();
                if (bean == null || !(bean instanceof IconProvider)) continue;
                try {
                    InfectionLauncher.this.uninstallCustomizerProvider((CustomizerProvider)bean);
                }
                catch (Exception e) {
                    InfectionLauncher.this.handleException(e);
                }
            }
        }
    }

    protected class IconProviderHandler
    implements BeanContextMembershipListener {
        protected IconProviderHandler() {
        }

        @Override
        public void childrenAdded(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object bean = i.next();
                if (bean == null || !(bean instanceof IconProvider)) continue;
                try {
                    InfectionLauncher.this.installIconProvider((IconProvider)bean);
                }
                catch (Exception e) {
                    InfectionLauncher.this.handleException(e);
                }
            }
        }

        @Override
        public void childrenRemoved(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object bean = i.next();
                if (bean == null || !(bean instanceof IconProvider)) continue;
                try {
                    InfectionLauncher.this.uninstallIconProvider((IconProvider)bean);
                }
                catch (Exception e) {
                    InfectionLauncher.this.handleException(e);
                }
            }
        }
    }

    protected class FileTypeHandler
    implements BeanContextMembershipListener {
        protected FileTypeHandler() {
        }

        @Override
        public void childrenAdded(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object bean = i.next();
                if (bean == null || !(bean instanceof FileType)) continue;
                try {
                    InfectionLauncher.this.installFileType((FileType)bean);
                }
                catch (Exception e) {
                    InfectionLauncher.this.handleException(e);
                }
            }
        }

        @Override
        public void childrenRemoved(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object bean = i.next();
                if (bean == null || !(bean instanceof FileType)) continue;
                try {
                    InfectionLauncher.this.uninstallFileType((FileType)bean);
                }
                catch (Exception e) {
                    InfectionLauncher.this.handleException(e);
                }
            }
        }
    }

    protected class PlatformShutdownHook
    implements Runnable {
        protected PlatformShutdownHook() {
        }

        @Override
        public void run() {
            try {
                InfectionLauncher.this.shutdown();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

