/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.util.buffer.Base64Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class RegistrationData {
    private static final String ZIP_ENTRY_NAME = "regdata";
    public static final String KEY_PRODUCT = "product";
    public static final String KEY_INSTANCE = "instance";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_FIRSTNAME = "firstName";
    public static final String KEY_LASTNAME = "lastName";
    public static final String KEY_USERNAME = "userName";
    private Properties properties = new Properties();

    public RegistrationData() {
    }

    public RegistrationData(String data) throws Exception {
        this();
        this.readData(data);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public Enumeration getPropertyNames() {
        return this.properties.propertyNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readData(String data) throws Exception {
        data = data.replace('-', '+');
        byte[] buf = Base64Util.getDecoder().decode(data);
        ByteArrayInputStream bin = new ByteArrayInputStream(buf);
        ZipInputStream zin = new ZipInputStream(bin);
        try {
            ZipEntry entry = zin.getNextEntry();
            if (entry == null) {
                throw new StreamCorruptedException("missing zip entry");
            }
            String name = entry.getName();
            if (!ZIP_ENTRY_NAME.equals(name)) {
                throw new StreamCorruptedException("invalid zip entry");
            }
            DataInputStream din = new DataInputStream(zin);
            int propCount = din.readInt();
            this.properties = new Properties();
            for (int c = 0; c < propCount; ++c) {
                String key = din.readUTF();
                String value = din.readUTF();
                this.properties.put(key, value);
            }
            zin.closeEntry();
        }
        finally {
            zin.close();
        }
    }

    public String toDataString() throws Exception {
        int i;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(bout);
        ZipEntry entry = new ZipEntry(ZIP_ENTRY_NAME);
        zout.putNextEntry(entry);
        DataOutputStream dout = new DataOutputStream(zout);
        int propCount = this.properties.size();
        dout.writeInt(propCount);
        for (Map.Entry<Object, Object> me : this.properties.entrySet()) {
            dout.writeUTF((String)me.getKey());
            dout.writeUTF((String)me.getValue());
        }
        dout.flush();
        zout.closeEntry();
        zout.flush();
        zout.finish();
        zout.flush();
        bout.flush();
        byte[] buf = bout.toByteArray();
        bout.close();
        String rc = Base64Util.getEncoder().encodeToString(buf);
        while ((i = rc.indexOf("\n")) >= 0) {
            rc = rc.substring(0, i) + rc.substring(i + 1);
        }
        while ((i = rc.indexOf("\r")) >= 0) {
            rc = rc.substring(0, i) + rc.substring(i + 1);
        }
        rc = rc.replace('+', '-');
        return rc;
    }

    public String getProduct() {
        return this.getProperty(KEY_PRODUCT);
    }

    public String getInstance() {
        return this.getProperty(KEY_INSTANCE);
    }

    public String getEmail() {
        return this.getProperty(KEY_EMAIL);
    }

    public String getFirstName() {
        return this.getProperty(KEY_FIRSTNAME);
    }

    public String getLastName() {
        return this.getProperty(KEY_LASTNAME);
    }
}

