/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.old.ErrorDialog;
import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.platform.InfectionProductRegistry;
import com.spacekiller.infection.platform.RegistrationData;
import com.spacekiller.util.Platform;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.Tools;
import com.spacekiller.util.swing.DocumentAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URL;
import java.security.Key;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RegistrationPanel
extends JPanel {
    private static final long serialVersionUID = -260605930499268207L;
    private InfectionProductRegistry productRegistry;
    private String urlPrefix;
    private String productId;
    private String instanceId;
    private String userName;
    private Object dialog;
    private boolean dialogConfirm = false;
    private JTextField jTextFieldEmail = null;
    private JTextField jTextFieldFirstName = null;
    private JTextField jTextFieldLastName = null;
    private JPanel jPanel = null;
    private JButton jButtonSubmit = null;
    private JPanel jPanel2 = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JPanel jPanel3 = null;
    private JLabel jLabel4 = null;
    private JPanel jPanel1 = null;
    private JButton jButtonPaste = null;
    private JScrollPane jScrollPane = null;
    private JList jListProducts = null;
    private static final Logger logger = Logger.getLogger(RegistrationPanel.class.getName());

    public RegistrationPanel() {
        this.initialize();
        this.initRegistrationPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.weighty = 1.0;
        gridBagConstraints21.weightx = 1.0;
        gridBagConstraints21.fill = 1;
        gridBagConstraints21.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints21.gridy = 2;
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.fill = 1;
        gridBagConstraints13.weightx = 1.0;
        gridBagConstraints13.weighty = 0.0;
        gridBagConstraints13.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints13.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(396, 326));
        this.add((Component)this.getJPanel2(), gridBagConstraints13);
        this.add((Component)this.getJPanel3(), gridBagConstraints21);
    }

    private JTextField getJTextFieldEmail() {
        if (this.jTextFieldEmail == null) {
            this.jTextFieldEmail = new JTextField();
        }
        return this.jTextFieldEmail;
    }

    private JTextField getJTextFieldFirstName() {
        if (this.jTextFieldFirstName == null) {
            this.jTextFieldFirstName = new JTextField();
        }
        return this.jTextFieldFirstName;
    }

    private JTextField getJTextFieldLastName() {
        if (this.jTextFieldLastName == null) {
            this.jTextFieldLastName = new JTextField();
        }
        return this.jTextFieldLastName;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints7.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJButtonSubmit(), gridBagConstraints7);
        }
        return this.jPanel;
    }

    private JButton getJButtonSubmit() {
        if (this.jButtonSubmit == null) {
            this.jButtonSubmit = new JButton();
            this.jButtonSubmit.setText("Submit");
            this.jButtonSubmit.setToolTipText("Send registration request..");
            this.jButtonSubmit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RegistrationPanel.this.dialogConfirm = true;
                    ((JDialog)RegistrationPanel.this.dialog).dispose();
                }
            });
        }
        return this.jButtonSubmit;
    }

    synchronized void showDialog(InfectionProductRegistry productRegistry, String urlPrefix, String productId, String instanceId, String userName, Key publicKey) {
        this.productRegistry = productRegistry;
        this.urlPrefix = urlPrefix;
        this.productId = productId;
        this.instanceId = instanceId;
        this.userName = userName;
        JDialog dialog = new JDialog();
        dialog.setTitle("Registration");
        dialog.setContentPane(this);
        this.refreshProducts();
        dialog.pack();
        Tools.centerWindow((Window)dialog);
        this.dialog = dialog;
        dialog.setModal(true);
        dialog.setVisible(true);
        if (!this.dialogConfirm) {
            return;
        }
        this.submit();
    }

    protected void initRegistrationPanel() {
        this.getJButtonSubmit().setEnabled(false);
        DocumentAdapter adapter = new DocumentAdapter(){

            protected void handle(DocumentEvent e) {
                RegistrationPanel.this.checkEnable();
            }
        };
        this.getJTextFieldEmail().getDocument().addDocumentListener((DocumentListener)adapter);
        this.getJTextFieldFirstName().getDocument().addDocumentListener((DocumentListener)adapter);
        this.getJTextFieldLastName().getDocument().addDocumentListener((DocumentListener)adapter);
    }

    protected void checkEnable() {
        String lastName;
        String firstName;
        boolean enable = true;
        String mail = this.getJTextFieldEmail().getText();
        if (mail.length() < 3) {
            enable = false;
        }
        if (mail.indexOf("@") < 0) {
            enable = false;
        }
        if ((firstName = this.getJTextFieldFirstName().getText()).length() < 2) {
            enable = false;
        }
        if ((lastName = this.getJTextFieldLastName().getText()).length() < 2) {
            enable = false;
        }
        this.getJButtonSubmit().setEnabled(enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submit() {
        try {
            String email = this.getJTextFieldEmail().getText();
            String firstName = this.getJTextFieldFirstName().getText();
            String lastName = this.getJTextFieldLastName().getText();
            RegistrationData data = new RegistrationData();
            data.setProperty("product", this.productId);
            data.setProperty("instance", this.instanceId);
            data.setProperty("userName", this.userName);
            data.setProperty("email", email);
            data.setProperty("firstName", firstName);
            data.setProperty("lastName", lastName);
            String dataString = data.toDataString();
            logger.fine("Registration hash: " + dataString.hashCode());
            String urlString = this.urlPrefix + dataString;
            logger.fine("Registration URL: " + urlString);
            URL url = new URL(urlString);
            try {
                InputStream in = url.openStream();
                try {
                    String s;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    boolean success = false;
                    while ((s = reader.readLine()) != null) {
                        if (s.indexOf("<!-- REGISTRATION RECORDED -->") < 0) continue;
                        success = true;
                        break;
                    }
                    if (!success) {
                        throw new IOException("Registration failed!");
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (ConnectException e) {
                throw new IOException("Failed to contact server: " + urlString);
            }
            RuntimeContext rc = Platform.getInstance().getRuntimeContext();
            if (rc != null) {
                String title = "Registration";
                String message = "The request was submitted successfully.";
                message = message + "\nYou should receive an e-mail to confirm";
                message = message + "\nyour registration.";
                rc.prompt(title, (Object)message, new String[]{"Ok"});
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            ErrorDialog.showErrorDialog((Throwable)e);
        }
    }

    protected void register() {
        try {
            RuntimeContext rc = Platform.getInstance().getRuntimeContext();
            String productKey = rc.getClipboardText();
            logger.fine("Register product key:\n" + productKey);
            if (productKey == null) {
                productKey = "";
            }
            Platform plat = Platform.getInstance();
            InfectionPlatform ip = (InfectionPlatform)plat;
            ip.registerProduct(this.productId, productKey);
            logger.fine("Product key registered successfully: " + this.productId);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            ErrorDialog.showErrorDialog((Throwable)e);
        }
        this.refreshProducts();
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.anchor = 12;
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridy = 4;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.fill = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 3;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Last name:");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 2;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("First name:");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 1;
            this.jLabel = new JLabel();
            this.jLabel.setText("e-mail:");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 0;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Please provide the following information for your registration:");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanel2.add((Component)this.getJTextFieldEmail(), gridBagConstraints);
            this.jPanel2.add((Component)this.getJTextFieldFirstName(), gridBagConstraints4);
            this.jPanel2.add((Component)this.getJTextFieldLastName(), gridBagConstraints5);
            this.jPanel2.add((Component)this.jLabel3, gridBagConstraints6);
            this.jPanel2.add((Component)this.jLabel, gridBagConstraints1);
            this.jPanel2.add((Component)this.jLabel1, gridBagConstraints2);
            this.jPanel2.add((Component)this.jLabel2, gridBagConstraints3);
            this.jPanel2.add((Component)this.getJPanel(), gridBagConstraints8);
        }
        return this.jPanel2;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 1;
            gridBagConstraints12.gridy = 1;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints12.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.anchor = 14;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.insets = new Insets(4, 4, 0, 4);
            gridBagConstraints10.gridy = 0;
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("Registered Products:");
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanel3.add((Component)this.jLabel4, gridBagConstraints10);
            this.jPanel3.add((Component)this.getJPanel1(), gridBagConstraints11);
            this.jPanel3.add((Component)this.getJScrollPane(), gridBagConstraints12);
        }
        return this.jPanel3;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.gridx = 0;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.getJButtonPaste(), gridBagConstraints9);
        }
        return this.jPanel1;
    }

    private JButton getJButtonPaste() {
        if (this.jButtonPaste == null) {
            this.jButtonPaste = new JButton();
            this.jButtonPaste.setToolTipText("Paste registration key from clipboard..");
            this.jButtonPaste.setText("Add Key");
            this.jButtonPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RegistrationPanel.this.register();
                }
            });
        }
        return this.jButtonPaste;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJListProducts());
        }
        return this.jScrollPane;
    }

    private JList getJListProducts() {
        if (this.jListProducts == null) {
            this.jListProducts = new JList();
            this.jListProducts.setOpaque(false);
        }
        return this.jListProducts;
    }

    protected void refreshProducts() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        if (this.productRegistry != null) {
            String[] products = this.productRegistry.getProducts();
            for (int c = 0; c < products.length; ++c) {
                model.addElement(products[c]);
            }
        }
        this.getJListProducts().setModel(model);
    }
}

