/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform.util;

import com.spacekiller.util.Data;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ClassFile {
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_Utf8 = 1;
    public static final byte CONSTANT_Unicode = 2;
    private boolean validHeader;
    private int minorVersion;
    private int majorVersion;
    private List constantPoolEntries = new ArrayList();
    private int accessFlags;
    private String className;
    private String superClassName;
    private List interfaceClassNames = new ArrayList();
    private int optionFlags;
    private boolean resolveMethodInfo = false;
    private Map methodInfos = null;
    private boolean debug = false;
    private static final Logger logger = Logger.getLogger(ClassFile.class.getName());

    public void read(String expectedClassName, DataInput in) throws Exception {
        byte[] cafebabe = new byte[]{-54, -2, -70, -66};
        byte[] dat = new byte[4];
        in.readFully(dat);
        for (int c = 0; c < 4; ++c) {
            if (dat[c] == cafebabe[c]) continue;
            throw new Exception("Invalid class file header");
        }
        this.validHeader = true;
        this.minorVersion = in.readUnsignedShort();
        this.majorVersion = in.readUnsignedShort();
        int poolCount = in.readUnsignedShort();
        this.constantPoolEntries.clear();
        this.constantPoolEntries.add(null);
        for (int c = 1; c < poolCount; ++c) {
            Object cpEntry = null;
            try {
                cpEntry = this.readCPEntry(in);
            }
            catch (Exception e) {
                logger.fine("Error while reading constant entry: " + c + " / " + poolCount + " => " + e);
                if (this.debug) {
                    this.dump(System.out);
                }
                throw e;
            }
            catch (ClassFormatError e) {
                logger.fine("Error while reading constant entry: " + c + " / " + poolCount + " => " + e);
                if (c > 1) continue;
                if (this.debug) {
                    this.dump(System.out);
                }
                throw e;
            }
            if (cpEntry == null) {
                throw new NullPointerException("cpEntry");
            }
            this.constantPoolEntries.add(cpEntry);
            if (cpEntry instanceof Long) {
                this.constantPoolEntries.add(null);
                ++c;
            }
            if (!(cpEntry instanceof Double)) continue;
            this.constantPoolEntries.add(null);
            ++c;
        }
        this.accessFlags = in.readUnsignedShort();
        this.optionFlags = 0;
        char thisClassIndex = in.readChar();
        char superClassIndex = in.readChar();
        if (thisClassIndex >= this.constantPoolEntries.size()) {
            throw new ClassFormatError("Invalid class-index: " + thisClassIndex);
        }
        Object classEntry = this.constantPoolEntries.get(thisClassIndex);
        if (!(classEntry instanceof CONSTANT_Class_info)) {
            this.dump(System.out);
            logger.fine("Class: " + expectedClassName);
            logger.fine("ClassFile version: major=" + this.majorVersion + ", minor=" + this.minorVersion);
            logger.fine("Access flags: " + Modifier.toString(this.accessFlags));
            throw new ClassFormatError("Invalid class entry: #" + thisClassIndex + " => " + classEntry.getClass() + " = " + classEntry);
        }
        CONSTANT_Class_info constClass = (CONSTANT_Class_info)classEntry;
        char classNameIndex = constClass.name_index;
        String classNameInfo = (String)this.constantPoolEntries.get(classNameIndex);
        this.className = classNameInfo.replace('/', '.');
        if (!this.className.equals(expectedClassName)) {
            throw new ClassFormatError("Unexpected class name: " + this.className + " != " + expectedClassName);
        }
        if (superClassIndex < '\u0001') {
            this.superClassName = null;
        } else {
            constClass = (CONSTANT_Class_info)this.constantPoolEntries.get(superClassIndex);
            classNameIndex = constClass.name_index;
            classNameInfo = (String)this.constantPoolEntries.get(classNameIndex);
            this.superClassName = classNameInfo.replace('/', '.');
        }
        this.readInterfaces(in);
        this.readFields(in);
        this.readMethods(in);
    }

    public void read2(String expectedClassName, DataInput in, int classIndex, ClassFile failedByteCode) throws Exception {
        logger.fine("Reading class[2]: " + expectedClassName);
        byte classIndexHi = (byte)(classIndex >>> 8);
        byte classIndexLo = (byte)(classIndex & 0xFF);
        int constCount = failedByteCode.getConstantCount();
        this.constantPoolEntries = failedByteCode.constantPoolEntries;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            while (true) {
                bout.write(in.readByte() & 0xFF);
            }
        }
        catch (EOFException e) {
            bout.flush();
            byte[] buf = bout.toByteArray();
            bout.close();
            int size = buf.length;
            int ofs = 10;
            int errorPos = -1;
            for (int c = 1; c < constCount; ++c) {
                Object o = failedByteCode.getConstant(c);
                if (o == null) continue;
                byte b = buf[ofs++];
                switch (b) {
                    case 9: {
                        ofs += 4;
                        break;
                    }
                    case 10: {
                        ofs += 4;
                        break;
                    }
                    case 11: {
                        ofs += 4;
                        break;
                    }
                    case 7: {
                        ofs += 2;
                        break;
                    }
                    case 8: {
                        ofs += 2;
                        break;
                    }
                    case 3: {
                        ofs += 4;
                        break;
                    }
                    case 4: {
                        ofs += 4;
                        break;
                    }
                    case 5: {
                        ofs += 8;
                        break;
                    }
                    case 6: {
                        ofs += 8;
                        break;
                    }
                    case 12: {
                        ofs += 4;
                        break;
                    }
                    case 1: {
                        int numHi = buf[ofs] & 0xFF;
                        int numLo = buf[ofs + 1] & 0xFF;
                        ofs += 2;
                        int num = numHi << 8 | numLo;
                        ofs += num;
                        break;
                    }
                    default: {
                        errorPos = ofs;
                    }
                }
                if (errorPos >= 0) break;
            }
            if (errorPos < 0) {
                errorPos = ofs;
            }
            int posHi = Math.min(errorPos + 50, size - 4);
            int posLo = Math.max(errorPos - 50, 0);
            for (int i = posHi; i > posLo && i >= 0; --i) {
                Object obj;
                int numLo;
                int numHi;
                int superIndex;
                if (buf[i] != classIndexHi || buf[i + 1] != classIndexLo || (superIndex = (numHi = buf[i + 2] & 0xFF) << 8 | (numLo = buf[i + 3] & 0xFF)) <= 0 || superIndex >= constCount || (obj = failedByteCode.getConstant(superIndex)) == null || !(obj instanceof CONSTANT_Class_info)) continue;
                CONSTANT_Class_info info = (CONSTANT_Class_info)obj;
                Object nameObj = failedByteCode.getConstant(info.name_index);
                this.superClassName = ((String)nameObj).replace('/', '.');
                try {
                    ByteArrayInputStream byteIn = new ByteArrayInputStream(buf, i + 4, buf.length - i - 4);
                    DataInputStream dataIn = new DataInputStream(byteIn);
                    this.readInterfaces(dataIn);
                    dataIn.close();
                    byteIn.close();
                }
                catch (IndexOutOfBoundsException e2) {
                    logger.fine(" -> Error reading interfaces for class: " + expectedClassName + " >> " + e2);
                }
                return;
            }
            logger.fine("Class-Index reference not found: " + classIndex);
            failedByteCode.dump(System.out);
            throw new ClassFormatError("Class-Index reference not found: " + classIndex);
        }
    }

    protected void readInterfaces(DataInput in) throws IOException {
        int interfaceCount = in.readChar();
        this.interfaceClassNames.clear();
        for (int c = 0; c < interfaceCount; ++c) {
            char interfaceIndex = in.readChar();
            Object obj = this.constantPoolEntries.get(interfaceIndex);
            if (!(obj instanceof CONSTANT_Class_info)) {
                logger.fine("Invalid interface entry: " + obj);
                return;
            }
            CONSTANT_Class_info constClass = (CONSTANT_Class_info)obj;
            char classNameIndex = constClass.name_index;
            String classNameInfo = (String)this.constantPoolEntries.get(classNameIndex);
            String interfaceName = classNameInfo.replace('/', '.');
            this.interfaceClassNames.add(interfaceName);
        }
    }

    protected void readFields(DataInput in) throws IOException {
        int fieldCount = in.readChar();
        for (int c = 0; c < fieldCount; ++c) {
            in.readChar();
            in.readChar();
            in.readChar();
            int attrCount = in.readChar();
            for (int j = 0; j < attrCount; ++j) {
                in.readChar();
                int attrLen = in.readInt();
                in.skipBytes(attrLen);
            }
        }
    }

    protected void readMethods(DataInput in) throws IOException {
        if (this.resolveMethodInfo && this.methodInfos == null) {
            this.methodInfos = new HashMap();
        }
        int methCount = in.readChar();
        for (int c = 0; c < methCount; ++c) {
            Object descr;
            char accessFlags = in.readChar();
            char nameIndex = in.readChar();
            char descrIndex = in.readChar();
            int attrCount = in.readChar();
            Object methName = this.constantPoolEntries.get(nameIndex);
            if ("<init>".equals(methName) && Modifier.isPublic(accessFlags)) {
                this.optionFlags |= 2;
                descr = this.constantPoolEntries.get(descrIndex);
                if ("()V".equals(descr)) {
                    this.optionFlags |= 1;
                }
            }
            if ("main".equals(methName) && Modifier.isStatic(accessFlags) && Modifier.isPublic(accessFlags) && "([Ljava/lang/String;)V".equals(descr = this.constantPoolEntries.get(descrIndex))) {
                this.optionFlags |= 4;
            }
            boolean skip = true;
            int paramCount = 0;
            String descr2 = null;
            if (this.resolveMethodInfo) {
                descr2 = "" + this.constantPoolEntries.get(descrIndex);
                paramCount = this.computeParamCount(descr2);
                boolean bl = skip = paramCount < 1;
            }
            if (skip) {
                for (int j = 0; j < attrCount; ++j) {
                    in.readChar();
                    int attrLen = in.readInt();
                    in.skipBytes(attrLen);
                }
                continue;
            }
            MethodInfo methInfo = new MethodInfo();
            methInfo.modifiers = accessFlags;
            methInfo.name = (String)methName;
            methInfo.signature = descr2;
            String methKey = methInfo.name + descr2;
            this.methodInfos.put(methKey, methInfo);
            if (this.debug) {
                logger.fine("Method: " + methKey);
            }
            for (int j = 0; j < attrCount; ++j) {
                int attrLen;
                char attrNameIndex = in.readChar();
                Object attrName = this.constantPoolEntries.get(attrNameIndex);
                if ("Code".equals(attrName)) {
                    attrLen = in.readInt();
                    String[] paramNames = this.readMethodParamNamesFromCodeAttr(in, attrLen, paramCount);
                    if (paramNames == null) continue;
                    methInfo.parameterNames = paramNames;
                    continue;
                }
                attrLen = in.readInt();
                in.skipBytes(attrLen);
            }
        }
    }

    private String[] readMethodParamNamesFromCodeAttr(DataInput in, int len, int count) throws IOException {
        String s;
        in.readShort();
        int maxLocals = in.readShort();
        String[] varNames = new String[maxLocals];
        in.skipBytes(in.readInt());
        in.skipBytes(8 * in.readShort());
        int attrCount = in.readChar();
        int varCount = 0;
        for (int i = 0; i < attrCount; ++i) {
            char nameIndex = in.readChar();
            int attrLen = in.readInt();
            Object name = this.constantPoolEntries.get(nameIndex);
            if ("LocalVariableTable".equals(name)) {
                int num = in.readChar();
                if (num >= count && count > 0) {
                    for (int j = 0; j < num; ++j) {
                        String paramName;
                        in.readShort();
                        in.readShort();
                        nameIndex = in.readChar();
                        in.readShort();
                        short index = in.readShort();
                        varNames[index] = paramName = (String)this.constantPoolEntries.get(nameIndex);
                        ++varCount;
                        if (!this.debug) continue;
                        logger.fine("Var #" + j + ": index=" + index + ", name=" + paramName);
                    }
                    continue;
                }
                in.skipBytes(attrLen - 2);
                continue;
            }
            in.skipBytes(attrLen);
        }
        if (varCount < count) {
            return null;
        }
        String[] paramNames = new String[count];
        int x = 0;
        for (int i = 0; i < maxLocals && x < count && (s = varNames[i]) != null; ++i) {
            if ("this".equals(s)) continue;
            paramNames[x] = s;
            ++x;
        }
        if (x != count) {
            return null;
        }
        return paramNames;
    }

    private int computeParamCount(String methodSignature) {
        String sig = methodSignature;
        if (!sig.startsWith("(")) {
            return 0;
        }
        int x = sig.indexOf(")");
        if (x < 1) {
            return 0;
        }
        String params = sig.substring(1, x);
        int len = params.length();
        int count = 0;
        block5: for (int i = 0; i < len; ++i) {
            switch (params.charAt(i)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++count;
                    continue block5;
                }
                case '[': {
                    continue block5;
                }
                case 'L': {
                    ++count;
                    int j = params.indexOf(59, i + 1);
                    if (j <= 0) continue block5;
                    i = j;
                    continue block5;
                }
            }
        }
        return count;
    }

    public MethodInfo getMethodInfo(Method method) {
        String methKey = this.getSignature(method);
        return (MethodInfo)this.methodInfos.get(methKey);
    }

    private String getSignature(Method method) {
        StringBuffer buf = new StringBuffer();
        buf.append(method.getName());
        buf.append('(');
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            buf.append(this.getSignature(paramTypes[i]));
        }
        buf.append(')');
        Class<?> retType = method.getReturnType();
        if (retType == Void.TYPE) {
            buf.append("V");
        } else {
            buf.append(this.getSignature(retType));
        }
        return buf.toString();
    }

    private String getSignature(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
        }
        if (clazz.isArray()) {
            return "[" + this.getSignature(clazz.getComponentType());
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    public boolean isValidHeader() {
        return this.validHeader;
    }

    protected Object readCPEntry(DataInput in) throws Exception {
        byte type = in.readByte();
        Object entry = null;
        switch (type) {
            case 9: {
                CONSTANT_Fieldref_info rc = new CONSTANT_Fieldref_info();
                rc.class_index = in.readChar();
                rc.name_and_type_index = in.readChar();
                entry = rc;
                break;
            }
            case 10: {
                CONSTANT_Methodref_info rc = new CONSTANT_Methodref_info();
                rc.class_index = in.readChar();
                rc.name_and_type_index = in.readChar();
                entry = rc;
                break;
            }
            case 11: {
                CONSTANT_InterfaceMethodref_info rc = new CONSTANT_InterfaceMethodref_info();
                rc.class_index = in.readChar();
                rc.name_and_type_index = in.readChar();
                entry = rc;
                break;
            }
            case 7: {
                CONSTANT_Class_info rc = new CONSTANT_Class_info();
                rc.name_index = in.readChar();
                entry = rc;
                break;
            }
            case 8: {
                CONSTANT_String_info rc = new CONSTANT_String_info();
                rc.string_index = in.readChar();
                entry = rc;
                break;
            }
            case 3: {
                int v = in.readInt();
                entry = Data.toInteger((int)v);
                break;
            }
            case 4: {
                float v = in.readFloat();
                entry = Data.toFloat((float)v);
                break;
            }
            case 5: {
                long v = in.readLong();
                entry = Data.toLong((long)v);
                break;
            }
            case 6: {
                double v = in.readDouble();
                entry = Data.toDouble((double)v);
                break;
            }
            case 12: {
                CONSTANT_NameAndType_info rc = new CONSTANT_NameAndType_info();
                rc.name_index = in.readChar();
                rc.signature_index = in.readChar();
                entry = rc;
                break;
            }
            case 1: {
                entry = in.readUTF();
                break;
            }
            default: {
                throw new ClassFormatError("Invalid constant pool type: " + type);
            }
        }
        return entry;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String getClassName() throws Exception {
        return this.className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String[] getInterfaceClassNames() {
        String[] rc = new String[this.interfaceClassNames.size()];
        rc = this.interfaceClassNames.toArray(rc);
        return rc;
    }

    public int getOptionFlags() {
        return this.optionFlags;
    }

    public int getConstantCount() {
        return this.constantPoolEntries.size();
    }

    public Object getConstant(int index) {
        return this.constantPoolEntries.get(index);
    }

    public void dump(PrintStream out) {
        out.println("=============== Dump Byte-Code ==================");
        out.println("Number of constant-pool entries: " + this.constantPoolEntries.size());
        int c = 0;
        for (Object o : this.constantPoolEntries) {
            String clazz = o == null ? "null" : o.getClass().getName();
            out.println(" #" + c + " >> (" + clazz + ") " + o);
            ++c;
        }
        out.println("================= End of Dump ===================");
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean isResolveMethodInfo() {
        return this.resolveMethodInfo;
    }

    public void setResolveMethodInfo(boolean resolveMethodInfo) {
        this.resolveMethodInfo = resolveMethodInfo;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static class MethodInfo {
        public int modifiers;
        public String name;
        public String signature;
        public String[] parameterNames;

        public String[] getParameterNames() {
            return this.parameterNames;
        }
    }

    public static class CONSTANT_NameAndType_info {
        char name_index;
        char signature_index;

        public String toString() {
            return this.getClass().getName() + "[name_index=" + this.name_index + ", signature_index=" + this.signature_index + "]";
        }
    }

    public static class CONSTANT_String_info {
        public char string_index;

        public String toString() {
            return this.getClass().getName() + "[string_index=" + this.string_index + "]";
        }
    }

    public static class CONSTANT_InterfaceMethodref_info {
        public char class_index;
        public char name_and_type_index;

        public String toString() {
            return this.getClass().getName() + "[class_index=" + this.class_index + ", name_and_type_index=" + this.name_and_type_index + "]";
        }
    }

    public static class CONSTANT_Methodref_info {
        public char class_index;
        public char name_and_type_index;

        public String toString() {
            return this.getClass().getName() + "[class_index=" + this.class_index + ", name_and_type_index=" + this.name_and_type_index + "]";
        }
    }

    public static class CONSTANT_Fieldref_info {
        public char class_index;
        public char name_and_type_index;

        public String toString() {
            return this.getClass().getName() + "[class_index=" + this.class_index + ", name_and_type_index=" + this.name_and_type_index + "]";
        }
    }

    public static class CONSTANT_Class_info {
        public char name_index;

        public String toString() {
            return this.getClass().getName() + "[name_index=" + this.name_index + "]";
        }
    }
}

