/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.prefs;

import com.spacekiller.util.swing.FileField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class WorkbenchPreferencesPanel
extends JPanel {
    private static final long serialVersionUID = -4856346242037838747L;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelPageWindow = null;
    private JPanel jPanelBackground = null;
    private JRadioButton jRadioButtonDefaultBackground = null;
    private JRadioButton jRadioButtonCustomBackground = null;
    private FileField fileFieldCustomBackground = null;
    private JCheckBox jCheckBoxStretch = null;
    private static final Logger logger = Logger.getLogger(WorkbenchPreferencesPanel.class.getName());
    private JCheckBox jCheckBoxWindowAnimation = null;
    private JPanel panelWindowOptions;
    private JCheckBox checkBoxAlwaysOnTop;
    private JPanel panelFill;
    private JCheckBox chckbxAutoHideDetached;

    public WorkbenchPreferencesPanel() {
        this.initialize();
        this.initWorkbenchPreferencesPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(534, 404));
        this.add((Component)this.getJTabbedPane(), gridBagConstraints);
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setPreferredSize(new Dimension(300, 300));
            this.jTabbedPane.addTab("Window", new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/platform/icons/lookAndFeel.gif")), this.getJPanelPageWindow(), "Workbench window preferences..");
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelPageWindow() {
        if (this.jPanelPageWindow == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints1.weighty = 0.0;
            gridBagConstraints1.anchor = 11;
            gridBagConstraints1.gridy = 0;
            this.jPanelPageWindow = new JPanel();
            GridBagLayout gbl_jPanelPageWindow = new GridBagLayout();
            gbl_jPanelPageWindow.rowHeights = new int[]{0, 0, 0};
            gbl_jPanelPageWindow.columnWidths = new int[]{0};
            gbl_jPanelPageWindow.rowWeights = new double[]{0.0, 0.0, 0.0};
            gbl_jPanelPageWindow.columnWeights = new double[]{0.0};
            this.jPanelPageWindow.setLayout(gbl_jPanelPageWindow);
            this.jPanelPageWindow.add((Component)this.getJPanelBackground(), gridBagConstraints1);
            GridBagConstraints gbc_panelWindowOptions = new GridBagConstraints();
            gbc_panelWindowOptions.insets = new Insets(4, 4, 5, 4);
            gbc_panelWindowOptions.weightx = 1.0;
            gbc_panelWindowOptions.fill = 1;
            gbc_panelWindowOptions.gridx = 0;
            gbc_panelWindowOptions.gridy = 1;
            this.jPanelPageWindow.add((Component)this.getPanelWindowOptions(), gbc_panelWindowOptions);
            GridBagConstraints gbc_panelFill = new GridBagConstraints();
            gbc_panelFill.weighty = 1.0;
            gbc_panelFill.fill = 1;
            gbc_panelFill.gridx = 0;
            gbc_panelFill.gridy = 2;
            this.jPanelPageWindow.add((Component)this.getPanel_1(), gbc_panelFill);
        }
        return this.jPanelPageWindow;
    }

    private JPanel getJPanelBackground() {
        if (this.jPanelBackground == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.gridy = 0;
            this.jPanelBackground = new JPanel();
            this.jPanelBackground.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Background", 4, 2, null, null));
            this.jPanelBackground.setLayout(new GridBagLayout());
            this.jPanelBackground.setOpaque(false);
            this.jPanelBackground.add((Component)this.getJRadioButtonDefaultBackground(), gridBagConstraints2);
            this.jPanelBackground.add((Component)this.getJRadioButtonCustomBackground(), gridBagConstraints3);
            this.jPanelBackground.add((Component)this.getFileFieldCustomBackground(), gridBagConstraints4);
            this.jPanelBackground.add((Component)this.getJCheckBoxStretch(), gridBagConstraints5);
        }
        return this.jPanelBackground;
    }

    public JRadioButton getJRadioButtonDefaultBackground() {
        if (this.jRadioButtonDefaultBackground == null) {
            this.jRadioButtonDefaultBackground = new JRadioButton();
            this.jRadioButtonDefaultBackground.setText("Default");
            this.jRadioButtonDefaultBackground.setMargin(new Insets(0, 0, 0, 0));
            this.jRadioButtonDefaultBackground.setToolTipText("Use default background (look and feel)");
            this.jRadioButtonDefaultBackground.setOpaque(false);
        }
        return this.jRadioButtonDefaultBackground;
    }

    public JRadioButton getJRadioButtonCustomBackground() {
        if (this.jRadioButtonCustomBackground == null) {
            this.jRadioButtonCustomBackground = new JRadioButton();
            this.jRadioButtonCustomBackground.setOpaque(false);
            this.jRadioButtonCustomBackground.setMargin(new Insets(0, 0, 0, 0));
            this.jRadioButtonCustomBackground.setText("Custom:");
            this.jRadioButtonCustomBackground.setToolTipText("Use a custom background image");
            this.jRadioButtonCustomBackground.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean customEnabled = WorkbenchPreferencesPanel.this.jRadioButtonCustomBackground.isSelected();
                    WorkbenchPreferencesPanel.this.getFileFieldCustomBackground().setEnabled(customEnabled);
                    WorkbenchPreferencesPanel.this.getJCheckBoxStretch().setEnabled(customEnabled);
                }
            });
        }
        return this.jRadioButtonCustomBackground;
    }

    protected void initWorkbenchPreferencesPanel() {
        ButtonGroup bgroup1 = new ButtonGroup();
        bgroup1.add(this.getJRadioButtonDefaultBackground());
        bgroup1.add(this.getJRadioButtonCustomBackground());
        this.getJRadioButtonDefaultBackground().setSelected(true);
        this.getFileFieldCustomBackground().setEnabled(false);
        this.getJCheckBoxStretch().setEnabled(false);
    }

    public FileField getFileFieldCustomBackground() {
        if (this.fileFieldCustomBackground == null) {
            this.fileFieldCustomBackground = new FileField();
            this.fileFieldCustomBackground.setOpaque(false);
        }
        return this.fileFieldCustomBackground;
    }

    public JCheckBox getJCheckBoxStretch() {
        if (this.jCheckBoxStretch == null) {
            this.jCheckBoxStretch = new JCheckBox();
            this.jCheckBoxStretch.setOpaque(false);
            this.jCheckBoxStretch.setToolTipText("stretch image to window size");
            this.jCheckBoxStretch.setMargin(new Insets(0, 0, 0, 0));
            this.jCheckBoxStretch.setText("stretch image");
        }
        return this.jCheckBoxStretch;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public JCheckBox getJCheckBoxWindowAnimation() {
        if (this.jCheckBoxWindowAnimation == null) {
            this.jCheckBoxWindowAnimation = new JCheckBox();
            this.jCheckBoxWindowAnimation.setText("Window animation");
            this.jCheckBoxWindowAnimation.setToolTipText("Animation when closing or minimizing views...");
            this.jCheckBoxWindowAnimation.setOpaque(false);
        }
        return this.jCheckBoxWindowAnimation;
    }

    private JPanel getPanelWindowOptions() {
        if (this.panelWindowOptions == null) {
            this.panelWindowOptions = new JPanel();
            this.panelWindowOptions.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Options", 4, 2, null, null));
            this.panelWindowOptions.setOpaque(false);
            GridBagLayout gbl_panelWindowOptions = new GridBagLayout();
            gbl_panelWindowOptions.columnWidths = new int[]{0, 0};
            gbl_panelWindowOptions.rowHeights = new int[]{0, 0, 0, 0};
            gbl_panelWindowOptions.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelWindowOptions.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panelWindowOptions.setLayout(gbl_panelWindowOptions);
            GridBagConstraints gbc_checkBoxAlwaysOnTop = new GridBagConstraints();
            gbc_checkBoxAlwaysOnTop.anchor = 17;
            gbc_checkBoxAlwaysOnTop.insets = new Insets(4, 4, 5, 4);
            gbc_checkBoxAlwaysOnTop.gridx = 0;
            gbc_checkBoxAlwaysOnTop.gridy = 0;
            this.panelWindowOptions.add((Component)this.getCheckBoxAlwaysOnTop(), gbc_checkBoxAlwaysOnTop);
            GridBagConstraints gbc_chckbxAutoHideDetached = new GridBagConstraints();
            gbc_chckbxAutoHideDetached.insets = new Insets(0, 4, 5, 4);
            gbc_chckbxAutoHideDetached.anchor = 17;
            gbc_chckbxAutoHideDetached.gridx = 0;
            gbc_chckbxAutoHideDetached.gridy = 1;
            this.panelWindowOptions.add((Component)this.getChckbxAutoHideDetached(), gbc_chckbxAutoHideDetached);
            GridBagConstraints gbc_jCheckBoxWindowAnimation = new GridBagConstraints();
            gbc_jCheckBoxWindowAnimation.anchor = 17;
            gbc_jCheckBoxWindowAnimation.insets = new Insets(0, 4, 5, 4);
            gbc_jCheckBoxWindowAnimation.gridx = 0;
            gbc_jCheckBoxWindowAnimation.gridy = 2;
            this.panelWindowOptions.add((Component)this.getJCheckBoxWindowAnimation(), gbc_jCheckBoxWindowAnimation);
        }
        return this.panelWindowOptions;
    }

    public JCheckBox getCheckBoxAlwaysOnTop() {
        if (this.checkBoxAlwaysOnTop == null) {
            this.checkBoxAlwaysOnTop = new JCheckBox("Always on top");
            this.checkBoxAlwaysOnTop.setToolTipText("Window always on top ?");
            this.checkBoxAlwaysOnTop.setOpaque(false);
        }
        return this.checkBoxAlwaysOnTop;
    }

    private JPanel getPanel_1() {
        if (this.panelFill == null) {
            this.panelFill = new JPanel();
            this.panelFill.setOpaque(false);
        }
        return this.panelFill;
    }

    public JCheckBox getChckbxAutoHideDetached() {
        if (this.chckbxAutoHideDetached == null) {
            this.chckbxAutoHideDetached = new JCheckBox("Auto-Hide detached views");
            this.chckbxAutoHideDetached.setToolTipText("Hide detached views when workbench window is not activated ?");
            this.chckbxAutoHideDetached.setOpaque(false);
        }
        return this.chckbxAutoHideDetached;
    }
}

