/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractExecution
implements Execution {
    protected static final byte CONTINUE = 0;
    protected static final byte PAUSE = 1;
    protected static final byte STOP = 2;
    private String name;
    private String description;
    private String status;
    private boolean pauseSupported;
    private boolean stopSupported;
    private boolean daemon;
    private boolean running = false;
    private boolean paused = false;
    private Thread thread;
    private byte signal = 0;
    private long startMillis = 0L;
    private long endMillis = 0L;
    private long pauseStartMillis = 0L;
    private long pausedMillis = 0L;
    private double progress = 0.0;
    private List exceptions;
    private List monitors;

    public AbstractExecution() {
        this("New Executable", "No description available");
    }

    public AbstractExecution(String name, String descr) {
        this.setName(name);
        this.setDescription(descr);
    }

    protected void addException(Throwable e) {
        if (e == null) {
            return;
        }
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        this.exceptions.add(e);
    }

    @Override
    public void addExecutionListener(ExecutionListener monitor) {
        if (monitor == null) {
            return;
        }
        if (this.monitors == null) {
            this.monitors = new ArrayList();
        }
        if (this.monitors.contains(monitor)) {
            return;
        }
        this.monitors.add(monitor);
    }

    @Override
    public void stop() {
        if (!this.isStopSupported()) {
            return;
        }
        if ((this.running || this.paused) && this.signal < 2) {
            this.signal = (byte)2;
        }
    }

    protected abstract void execute() throws Exception;

    protected synchronized void fireExecutionStarted() {
        if (this.monitors == null) {
            return;
        }
        Object[] mons = this.monitors.toArray();
        for (int c = 0; c < mons.length; ++c) {
            ((ExecutionListener)mons[c]).executionStarted(this);
        }
    }

    protected synchronized void fireExecutionStopped() {
        if (this.monitors == null) {
            return;
        }
        Object[] mons = this.monitors.toArray();
        for (int c = 0; c < mons.length; ++c) {
            ((ExecutionListener)mons[c]).executionStopped(this);
        }
    }

    protected synchronized void fireExecutionPaused() {
        if (this.monitors == null) {
            return;
        }
        Object[] mons = this.monitors.toArray();
        for (int c = 0; c < mons.length; ++c) {
            ((ExecutionListener)mons[c]).executionPaused(this);
        }
    }

    protected synchronized void fireExecutionResumed() {
        if (this.monitors == null) {
            return;
        }
        Object[] mons = this.monitors.toArray();
        for (int c = 0; c < mons.length; ++c) {
            ((ExecutionListener)mons[c]).executionResumed(this);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public long getElapsedMillis() {
        if (this.paused) {
            return Math.max(this.pauseStartMillis - this.startMillis - this.pausedMillis, 0L);
        }
        if (this.running) {
            return Math.max(System.currentTimeMillis() - this.startMillis - this.pausedMillis, 0L);
        }
        return Math.max(this.endMillis - this.startMillis - this.pausedMillis, 0L);
    }

    @Override
    public final long getEndMillis() {
        return this.endMillis;
    }

    @Override
    public long getEstimatedMillis() {
        if (this.running || this.paused) {
            double progress = this.getProgress();
            if (progress <= 0.0) {
                return -1L;
            }
            if (progress >= 1.0) {
                return this.getElapsedMillis();
            }
            double elapsed = this.getElapsedMillis();
            return (long)(elapsed / progress);
        }
        return this.getElapsedMillis();
    }

    @Override
    public Throwable getExceptionAt(int i) {
        return (Throwable)this.exceptions.get(i);
    }

    @Override
    public int getExceptionCount() {
        return this.exceptions == null ? 0 : this.exceptions.size();
    }

    protected Logger getLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public final long getStartMillis() {
        return this.startMillis;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    protected void handleException(Throwable e) {
        this.addException(e);
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    @Override
    public final boolean isRunning() {
        return this.running;
    }

    @Override
    public final void removeExecutionListener(ExecutionListener monitor) {
        if (monitor == null) {
            return;
        }
        if (this.monitors == null) {
            return;
        }
        this.monitors.remove(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void run() {
        try {
            this.signal = 0;
            this.running = true;
            if (this.paused) {
                this.paused = false;
                this.pausedMillis += Math.max(System.currentTimeMillis() - this.pauseStartMillis, 0L);
                this.pauseStartMillis = 0L;
                this.fireExecutionResumed();
            } else {
                this.setProgress(0.0);
                this.setEndMillis(0L);
                this.setStartMillis(System.currentTimeMillis());
                this.fireExecutionStarted();
            }
            this.startup();
            this.execute();
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        finally {
            try {
                this.shutdown();
            }
            catch (Throwable e2) {
                this.handleException(e2);
            }
            if (this.signal == 0) {
                this.setProgress(1.0);
            }
            if (this.signal == 1) {
                this.paused = true;
                this.running = false;
                this.setPauseStartMillis(System.currentTimeMillis());
                this.fireExecutionPaused();
            } else {
                this.paused = false;
                this.running = false;
                this.setEndMillis(System.currentTimeMillis());
                this.fireExecutionStopped();
            }
        }
    }

    protected void setDescription(String newDescription) {
        this.description = newDescription;
    }

    protected void setEndMillis(long newEndMillis) {
        this.endMillis = newEndMillis;
    }

    protected void setName(String newName) {
        this.name = newName;
    }

    protected void setProgress(double newProgress) {
        if (newProgress < 0.0) {
            newProgress = 0.0;
        }
        if (newProgress > 1.0) {
            newProgress = 1.0;
        }
        this.progress = newProgress;
    }

    protected void setStartMillis(long newStartMillis) {
        this.startMillis = newStartMillis;
    }

    protected void setStatus(String newStatus) {
        this.status = newStatus;
    }

    protected void shutdown() {
    }

    @Override
    public final synchronized void start() {
        if (this.running || this.paused) {
            return;
        }
        if (this.thread != null) {
            return;
        }
        this.startInternal();
    }

    private void startInternal() {
        String className = this.getClass().getName();
        String threadName = className;
        int x = threadName.lastIndexOf(46);
        if (x >= 0) {
            threadName = threadName.substring(x + 1);
        }
        this.thread = new Thread(new Worker());
        this.thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        if (threadName != null && threadName.length() > 0) {
            this.thread.setName(threadName);
        }
        this.thread.start();
    }

    protected void startup() {
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public final void pause() {
        if (!this.isPauseSupported()) {
            return;
        }
        if (this.signal < 1) {
            this.signal = 1;
        }
    }

    @Override
    public final synchronized void resume() {
        if (!this.paused) {
            return;
        }
        this.signal = 0;
        this.startInternal();
    }

    protected final byte getSignal() {
        return this.signal;
    }

    protected void setSignal(byte signal) {
        this.signal = signal;
    }

    @Override
    public boolean isPauseSupported() {
        return this.pauseSupported;
    }

    protected void setPauseSupported(boolean pauseSupported) {
        this.pauseSupported = pauseSupported;
    }

    @Override
    public boolean isStopSupported() {
        return this.stopSupported;
    }

    protected void setStopSupported(boolean stopSupported) {
        this.stopSupported = stopSupported;
    }

    public final long getPauseStartMillis() {
        return this.pauseStartMillis;
    }

    protected void setPauseStartMillis(long pauseStartMillis) {
        this.pauseStartMillis = pauseStartMillis;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    protected void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public boolean isDaemon() {
        return this.daemon;
    }

    protected void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    protected class Worker
    implements Runnable {
        protected Worker() {
        }

        @Override
        public void run() {
            AbstractExecution.this.run();
        }
    }
}

