/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

public final class Data {
    public static final int BOOLEAN_SIZE = 1;
    public static final int BYTE_SIZE = 1;
    public static final int CHAR_SIZE = 2;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int FLOAT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;

    private Data() {
    }

    public static boolean getBit(byte[] buf, int bit) {
        int ofs = bit >>> 3;
        return (buf[ofs] & 128 >>> (bit & 7)) != 0;
    }

    public static boolean getBoolean(byte[] buf, int off) {
        return buf[off] != 0;
    }

    public static byte getByte(byte[] buf, int off) {
        return buf[off];
    }

    public static char getChar(byte[] buf, int off) {
        int b1 = buf[off] & 0xFF;
        int b2 = buf[off + 1] & 0xFF;
        return (char)(b1 << 8 | b2);
    }

    public static double getDouble(byte[] buf, int off) {
        return Double.longBitsToDouble(Data.getLong(buf, off));
    }

    public static float getFloat(byte[] buf, int off) {
        return Float.intBitsToFloat(Data.getInt(buf, off));
    }

    public static int getInt(byte[] buf, int off) {
        int rc = (buf[off] & 0xFF) << 24;
        rc += (buf[off + 1] & 0xFF) << 16;
        rc += (buf[off + 2] & 0xFF) << 8;
        return rc += buf[off + 3] & 0xFF;
    }

    public static long getLong(byte[] buf, int off) {
        long rc = ((long)buf[off] & 0xFFL) << 56;
        rc += ((long)buf[off + 1] & 0xFFL) << 48;
        rc += ((long)buf[off + 2] & 0xFFL) << 40;
        rc += ((long)buf[off + 3] & 0xFFL) << 32;
        rc += ((long)buf[off + 4] & 0xFFL) << 24;
        rc += ((long)buf[off + 5] & 0xFFL) << 16;
        rc += ((long)buf[off + 6] & 0xFFL) << 8;
        return rc += (long)buf[off + 7] & 0xFFL;
    }

    public static short getShort(byte[] buf, int off) {
        int b1 = buf[off] & 0xFF;
        int b2 = buf[off + 1] & 0xFF;
        return (short)((b1 << 8) + (b2 << 0));
    }

    public static void setBit(byte[] buf, int bit, boolean v) {
        int ofs = bit >>> 3;
        buf[ofs] = v ? (byte)(buf[ofs] & 0xFF | 128 >>> (bit & 7)) : (byte)(buf[ofs] & (0xFF ^ 128 >>> (bit & 7)));
    }

    public static void setBoolean(byte[] buf, int off, boolean v) {
        buf[off] = (byte)(v ? 1 : 0);
    }

    public static void setByte(byte[] buf, int off, byte v) {
        buf[off] = v;
    }

    public static void setChar(byte[] buf, int off, char v) {
        buf[off] = (byte)(v >>> 8);
        buf[off + 1] = (byte)(v >>> 0);
    }

    public static void setDouble(byte[] buf, int off, double v) {
        Data.setLong(buf, off, Double.doubleToLongBits(v));
    }

    public static void setFloat(byte[] buf, int off, float v) {
        Data.setInt(buf, off, Float.floatToIntBits(v));
    }

    public static void setInt(byte[] buf, int off, int v) {
        buf[off++] = (byte)(v >>> 24);
        buf[off++] = (byte)(v >>> 16);
        buf[off++] = (byte)(v >>> 8);
        buf[off++] = (byte)(v >>> 0);
    }

    public static void setLong(byte[] buf, int off, long v) {
        buf[off++] = (byte)(v >>> 56);
        buf[off++] = (byte)(v >>> 48);
        buf[off++] = (byte)(v >>> 40);
        buf[off++] = (byte)(v >>> 32);
        buf[off++] = (byte)(v >>> 24);
        buf[off++] = (byte)(v >>> 16);
        buf[off++] = (byte)(v >>> 8);
        buf[off++] = (byte)(v >>> 0);
    }

    public static void setShort(byte[] buf, int off, short v) {
        buf[off++] = (byte)(v >>> 8);
        buf[off++] = (byte)(v >>> 0);
    }

    public static Boolean toBoolean(boolean v) {
        return v ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Byte toByte(byte v) {
        return v;
    }

    public static Character toCharacter(char v) {
        return Character.valueOf(v);
    }

    public static Short toShort(short v) {
        return v;
    }

    public static Integer toInteger(int v) {
        return v;
    }

    public static Long toLong(long v) {
        return v;
    }

    public static Float toFloat(float v) {
        return Float.valueOf(v);
    }

    public static Double toDouble(double v) {
        return v;
    }
}

