/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.FileType;
import com.spacekiller.util.IconConstants;
import java.io.File;
import java.util.Iterator;
import javax.swing.Icon;

public class DefaultFileType
implements FileType,
IconConstants {
    private String name;
    private Icon icon;
    private String[] fileExtensions;
    private String[] customizerClassNames;

    public DefaultFileType() {
    }

    public DefaultFileType(String name, Icon icon, String[] fileExtensions) {
        this.setName(name);
        this.setFileExtensions(fileExtensions);
        this.setDefaultIcon(icon);
    }

    public Icon getDefaultIcon() {
        return this.getIcon(1);
    }

    @Override
    public Icon getIcon(int iconKind) {
        return this.icon;
    }

    public void setIcon(int iconKind, Icon icon) {
        this.icon = icon;
    }

    public void setDefaultIcon(Icon icon) {
        int h;
        if (icon == null) {
            return;
        }
        int w = icon.getIconWidth();
        int kind = this.getIconKind(w, h = icon.getIconHeight());
        if (kind >= 0) {
            this.setIcon(kind, icon);
        }
    }

    protected int getIconKind(int w, int h) {
        if (w <= 16 && h <= 16) {
            return 1;
        }
        if (w <= 32 && h <= 32) {
            return 2;
        }
        if (w <= 48 && h <= 48) {
            return 5;
        }
        if (w <= 64 && h <= 64) {
            return 6;
        }
        return 6;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFileExtension() {
        if (this.fileExtensions == null) {
            return null;
        }
        return this.fileExtensions.length > 0 ? this.fileExtensions[0] : null;
    }

    @Override
    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    @Override
    public Icon getIcon(File file, int iconKind) {
        return this.getIcon(iconKind);
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }

    @Override
    public String[] getCustomizerClassNames() {
        return this.customizerClassNames;
    }

    public void setCustomizerClassNames(String[] customizerClassNames) {
        this.customizerClassNames = customizerClassNames;
    }

    @Override
    public boolean matches(File file) {
        if (file == null) {
            return false;
        }
        String name = file.getName().toLowerCase();
        for (int c = 0; c < this.fileExtensions.length; ++c) {
            if (!name.endsWith(this.fileExtensions[c])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFileName(File file) {
        return file == null ? null : file.getName();
    }

    @Override
    public Iterator getOpenWithActions(File file) {
        return null;
    }
}

