/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.DefaultExtension;
import com.spacekiller.util.DefaultExtensionPoint;
import com.spacekiller.util.DefaultPluginPrerequisite;
import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.PluginDescriptor;
import com.spacekiller.util.PluginPrerequisite;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class DefaultPluginDescriptor
implements PluginDescriptor,
Serializable {
    private static final long serialVersionUID = -1104299646541221645L;
    private String id = "New Plugin";
    private String version;
    private String name = "New Plugin";
    private String provider;
    private String description;
    private String tooltip;
    private Icon icon;
    private String pluginClassName;
    private List extensionPointList;
    private Map extensionPointMap;
    private List extensionList;
    private Map extensionMap;
    private List prerequisiteList;
    private List injectionResources;
    private boolean autostart;

    public DefaultPluginDescriptor() {
        this.initDefaultPluginDescriptor();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized Extension getExtension(String id) {
        return (Extension)this.extensionMap.get(id);
    }

    @Override
    public synchronized ExtensionPoint getExtensionPoint(String id) {
        return (ExtensionPoint)this.extensionPointMap.get(id);
    }

    @Override
    public synchronized PluginPrerequisite[] getPrerequisites() {
        List list = this.prerequisiteList;
        return list.toArray(new PluginPrerequisite[list.size()]);
    }

    @Override
    public synchronized ExtensionPoint[] getExtensionPoints() {
        List list = this.extensionPointList;
        return list.toArray(new ExtensionPoint[list.size()]);
    }

    @Override
    public synchronized Extension[] getExtensions() {
        List list = this.extensionList;
        return list.toArray(new Extension[list.size()]);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Plugin getPlugin() throws Exception {
        return null;
    }

    public ClassLoader getPluginClassLoader() {
        return null;
    }

    @Override
    public String getPluginClassName() {
        return this.pluginClassName;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    protected void initDefaultPluginDescriptor() {
        this.extensionPointList = new ArrayList();
        this.extensionPointMap = new HashMap();
        this.extensionList = new ArrayList();
        this.extensionMap = new HashMap();
        this.prerequisiteList = new ArrayList();
        this.injectionResources = new ArrayList();
    }

    public boolean isPluginActivated() {
        return false;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public void setIcon(Icon newIcon) {
        this.icon = newIcon;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setPluginClassName(String newPluginClassName) {
        this.pluginClassName = newPluginClassName;
    }

    public void setPluginClassName(Class newPluginClass) {
        this.setPluginClassName(newPluginClass.getName());
    }

    public void setTooltip(String newTooltip) {
        this.tooltip = newTooltip;
    }

    public void setVersion(String newVersion) {
        this.version = newVersion;
    }

    public String toString() {
        return String.valueOf(this.getId());
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public boolean isAutostart() {
        return this.autostart;
    }

    public void setAutostart(boolean autostart) {
        this.autostart = autostart;
    }

    @Override
    public synchronized String[] getInjectionResources() {
        return this.injectionResources.toArray(new String[this.injectionResources.size()]);
    }

    public synchronized void addInjectionResource(String resource) {
        if (resource == null) {
            return;
        }
        this.injectionResources.add(resource);
    }

    public synchronized void removeInjectionResource(String resource) {
        if (resource == null) {
            return;
        }
        this.injectionResources.remove(resource);
    }

    public synchronized void addPluginPrerequisite(DefaultPluginPrerequisite pp) {
        if (pp == null) {
            return;
        }
        this.prerequisiteList.add(pp);
    }

    public synchronized void removePluginPrerequisite(DefaultPluginPrerequisite pp) {
        if (pp == null) {
            return;
        }
        this.prerequisiteList.remove(pp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addExtensionPoint(DefaultExtensionPoint ep) {
        List list;
        if (ep == null) {
            return false;
        }
        String id = ep.getId();
        Object obj = this.extensionPointMap.get(id);
        if (obj != null) {
            return false;
        }
        this.extensionPointMap.put(id, ep);
        List list2 = list = this.extensionPointList;
        synchronized (list2) {
            list.add(ep);
        }
        return true;
    }

    public synchronized boolean removeExtensionPoint(DefaultExtensionPoint ep) {
        if (ep == null) {
            return false;
        }
        String id = ep.getId();
        Object obj = this.extensionPointMap.get(id);
        if (obj == ep) {
            this.extensionPointMap.remove(id);
        }
        return this.extensionPointList.remove(ep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addExtension(DefaultExtension ex) {
        List list;
        if (ex == null) {
            return false;
        }
        String id = ex.getId();
        Object obj = this.extensionMap.get(id);
        if (obj != null) {
            return false;
        }
        this.extensionMap.put(id, ex);
        List list2 = list = this.extensionList;
        synchronized (list2) {
            list.add(ex);
        }
        return true;
    }

    public synchronized boolean removeExtension(DefaultExtension ex) {
        if (ex == null) {
            return false;
        }
        String id = ex.getId();
        Object obj = this.extensionMap.get(id);
        if (obj == ex) {
            this.extensionMap.remove(id);
        }
        return this.extensionList.remove(ex);
    }
}

