/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.ConfigInjector;
import com.spacekiller.util.ConfigNode;
import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.Injection;
import com.spacekiller.util.Platform;
import com.spacekiller.util.PluginDescriptor;
import com.spacekiller.util.RuntimeContext;
import java.util.HashMap;
import java.util.Map;

public abstract class Plugin {
    private Platform platform;
    private ConfigInjector configInjector;
    private PluginDescriptor descriptor;
    private RuntimeContext runtimeContext;
    private Map extensionInstances = new HashMap();
    private Injection injection;

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    protected final ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected final PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected final RuntimeContext getRuntimeContext() {
        if (this.runtimeContext == null && this.platform != null) {
            this.setRuntimeContext(this.platform.getRuntimeContext(this));
        }
        return this.runtimeContext;
    }

    void plugin(Platform thePlatform, PluginDescriptor newDescriptor, ConfigInjector injector, Injection injection) {
        if (this.descriptor != null || this.platform != null) {
            throw new RuntimeException("Plugin descriptor already initialized!");
        }
        this.setPlatform(thePlatform);
        this.setDescriptor(newDescriptor);
        this.setConfigInjector(injector);
        this.setInjection(injection);
    }

    private void setRuntimeContext(RuntimeContext newRuntimeContext) {
        this.runtimeContext = newRuntimeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getExtensionInstance(Extension extension) throws Exception {
        String id;
        Object rc;
        PluginDescriptor pd2;
        PluginDescriptor pd = extension.getDeclaringPluginDescriptor();
        if (pd != (pd2 = this.getDescriptor())) {
            Plugin plugin = this.platform.getPlugin(pd);
            if (plugin == null) {
                throw new NullPointerException("Plugin not available: " + pd);
            }
            if (plugin != this) {
                return plugin.getExtensionInstance(extension);
            }
        }
        if ((rc = this.extensionInstances.get(id = extension.getId())) == null) {
            Plugin plugin = this;
            synchronized (plugin) {
                rc = this.extensionInstances.get(id);
                if (rc == null && (rc = this.createExtensionInstance(extension)) != null) {
                    this.extensionInstances.put(id, rc);
                }
            }
        }
        return rc;
    }

    protected Object createExtensionInstance(Extension extension) throws Exception {
        PluginDescriptor pd2;
        PluginDescriptor pd = extension.getDeclaringPluginDescriptor();
        if (pd != (pd2 = this.getDescriptor())) {
            throw new Exception("Extension is not declared by this plugin: extension=" + extension + ", plugin=" + pd);
        }
        ConfigNode configNode = extension.getConfigNode();
        if (configNode == null) {
            throw new NullPointerException("Missing extension config: " + extension);
        }
        ConfigInjector injector = this.getConfigInjector();
        Object rc = injector.create(configNode);
        try {
            injector.inject(configNode, rc);
        }
        catch (Exception e) {
            throw new Exception("Failed to create instance of extension: " + extension, e);
        }
        return rc;
    }

    protected final boolean disposeExtensionInstance(Extension extension, Object instance) throws Exception {
        String id = extension.getId();
        Object obj = this.extensionInstances.get(id);
        if (obj == instance) {
            this.extensionInstances.remove(id);
            return true;
        }
        return false;
    }

    protected void shutdown() {
    }

    void plugout() {
        this.platform = null;
        this.configInjector = null;
        this.descriptor = null;
        this.extensionInstances = null;
        this.runtimeContext = null;
    }

    protected void startup() {
    }

    protected void extensionAvailable(ExtensionPoint point, Extension x) {
    }

    protected void extensionUnavailable(ExtensionPoint point, Extension x) {
    }

    protected void registerExtension(Extension x) throws Exception {
        if (x != null) {
            this.platform.registerExtension(this.descriptor, x);
        }
    }

    protected void unregisterExtension(Extension x) throws Exception {
        if (x != null) {
            this.platform.unregisterExtension(this.descriptor, x);
        }
    }

    protected final Platform getPlatform() {
        return this.platform;
    }

    private void setPlatform(Platform platform) {
        this.platform = platform;
    }

    private void setDescriptor(PluginDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected final ConfigInjector getConfigInjector() {
        return this.configInjector;
    }

    private void setConfigInjector(ConfigInjector configInjector) {
        this.configInjector = configInjector;
    }

    protected Injection getInjection() {
        return this.injection;
    }

    private void setInjection(Injection injection) {
        this.injection = injection;
    }
}

