/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.Platform;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PreferencesObject {
    private static final Logger logger = Platform.getLogger(PreferencesObject.class);

    public PreferencesObject() {
        this(true);
    }

    public PreferencesObject(boolean setDefaults) {
        if (setDefaults) {
            this.setDefaults();
        }
    }

    protected void setDefaults() {
    }

    protected void setFieldValues(PreferencesObject obj) {
        Class<?> objClass;
        Class<?> thisClass = this.getClass();
        if (thisClass != (objClass = obj.getClass())) {
            throw new IllegalArgumentException("Invalid preferences object types: " + objClass + " != " + thisClass);
        }
        while (thisClass != null) {
            for (Field field : thisClass.getDeclaredFields()) {
                try {
                    int mods = field.getModifiers();
                    if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    Object value = field.get(obj);
                    field.set(this, value);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "setFieldValues failed for " + field, e);
                }
            }
            thisClass = thisClass.getSuperclass();
        }
    }
}

