/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.workbench.AnimationEffect;
import com.spacekiller.util.workbench.AnimationEffects;
import com.spacekiller.util.workbench.DesktopManagerBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;

public class AnimatedDesktopManager
extends DesktopManagerBase {
    private static final long serialVersionUID = 7642516799430563168L;
    private static final Logger logger = Logger.getLogger(AnimatedDesktopManager.class.getName());
    private boolean animated = true;
    private AnimationEffect iconifyAnimationEffect;
    private AnimationEffect deiconifyAnimationEffect;
    private AnimationEffect closeAnimationEffect;

    public AnimatedDesktopManager(JDesktopPane desktopPane, int millis, int delay) {
        super(desktopPane);
        this.setIconifyAnimationEffect(new AnimationEffects.IconifyFrameAnimationEffect(millis, delay));
        this.setDeiconifyAnimationEffect(new AnimationEffects.DeiconifyFrameAnimationEffect(millis, delay));
        this.setCloseAnimationEffect(new AnimationEffects.CloseFrameAnimationEffect(millis, delay));
    }

    @Override
    public void iconifyFrame(JInternalFrame f) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("iconifyFrame: " + f);
        }
        boolean doAnimate = false;
        AnimationEffect effect = this.getIconifyAnimationEffect();
        if (this.animated && effect != null) {
            doAnimate = true;
        }
        if (!doAnimate) {
            super.iconifyFrame(f);
            return;
        }
        boolean showDesktopIcon = true;
        JInternalFrame.JDesktopIcon desktopIcon = null;
        Container c = f.getParent();
        f.getDesktopPane();
        boolean findNext = f.isSelected();
        if (showDesktopIcon) {
            desktopIcon = f.getDesktopIcon();
        }
        if (!this.wasIcon(f)) {
            if (desktopIcon != null) {
                Rectangle r = this.getBoundsForIconOf(f);
                desktopIcon.setBounds(r.x, r.y, r.width, r.height);
            }
            this.setWasIcon(f, Boolean.TRUE);
        }
        if (c == null) {
            return;
        }
        if (c instanceof JLayeredPane) {
            int layer = JLayeredPane.getLayer(f);
            if (desktopIcon != null) {
                JLayeredPane.putLayer(desktopIcon, layer);
            }
        }
        if (!f.isMaximum()) {
            f.setNormalBounds(f.getBounds());
        }
        if (showDesktopIcon && desktopIcon != null) {
            c.add(desktopIcon);
        }
        effect.animate(f);
        try {
            f.setSelected(false);
        }
        catch (PropertyVetoException e2) {
            // empty catch block
        }
        if (findNext) {
            this.activateNextFrameImpl(c);
        }
    }

    @Override
    public void deiconifyFrame(JInternalFrame f) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("deiconifyFrame: " + f);
        }
        boolean doAnimate = false;
        AnimationEffect effect = this.getDeiconifyAnimationEffect();
        if (this.animated && effect != null) {
            doAnimate = true;
        }
        if (!doAnimate) {
            super.deiconifyFrame(f);
            return;
        }
        effect.animate(f);
    }

    @Override
    public void closeFrame(JInternalFrame f) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("closeFrame: " + f);
        }
        boolean doAnimate = false;
        AnimationEffect effect = this.getCloseAnimationEffect();
        if (this.animated && effect != null) {
            doAnimate = true;
        }
        if (!doAnimate) {
            super.closeFrame(f);
            return;
        }
        effect.animate(f);
        boolean findNext = f.isSelected();
        Container c = f.getParent();
        if (findNext) {
            try {
                f.setSelected(false);
            }
            catch (PropertyVetoException e2) {
                // empty catch block
            }
        }
        this.removeIconFor(f);
        if (f.getNormalBounds() != null) {
            f.setNormalBounds(null);
        }
        if (this.wasIcon(f)) {
            this.setWasIcon(f, null);
        }
        if (findNext) {
            this.activateNextFrameImpl(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateNextFrameImpl(Container c) {
        JInternalFrame nextFrame = null;
        if (c == null) {
            return;
        }
        Object object = c.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < c.getComponentCount(); ++i) {
                Component child = c.getComponent(i);
                if (!(child instanceof JInternalFrame)) continue;
                nextFrame = (JInternalFrame)child;
                break;
            }
        }
        if (nextFrame != null) {
            try {
                nextFrame.setSelected(true);
            }
            catch (PropertyVetoException e2) {
                // empty catch block
            }
            nextFrame.moveToFront();
        }
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public AnimationEffect getDeiconifyAnimationEffect() {
        return this.deiconifyAnimationEffect;
    }

    public void setDeiconifyAnimationEffect(AnimationEffect deiconifyAnimationEffect) {
        this.deiconifyAnimationEffect = deiconifyAnimationEffect;
    }

    public AnimationEffect getIconifyAnimationEffect() {
        return this.iconifyAnimationEffect;
    }

    public void setIconifyAnimationEffect(AnimationEffect iconifyAnimationEffect) {
        this.iconifyAnimationEffect = iconifyAnimationEffect;
    }

    public AnimationEffect getCloseAnimationEffect() {
        return this.closeAnimationEffect;
    }

    public void setCloseAnimationEffect(AnimationEffect closeAnimationEffect) {
        this.closeAnimationEffect = closeAnimationEffect;
    }
}

