/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.workbench.ClipboardView;
import com.spacekiller.util.workbench.DefaultViewProvider;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.spacekiller.util.workspace.WorkspacePlugin;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClipboardViewProvider
extends DefaultViewProvider {
    private static final Logger logger = Logger.getLogger(ClipboardViewProvider.class.getName());

    @Override
    protected void initView(View v) {
        super.initView(v);
        if (v instanceof ClipboardView) {
            ClipboardView cv = (ClipboardView)v;
            cv.setTitle(this.getName());
            cv.setTooltip(this.getTooltip());
            cv.setIcon(this.getIcon());
            try {
                WorkspacePlugin wsPlugin = WorkbenchUtilities.getWorkspacePlugin();
                logger.fine("WorkspacePlugin: " + wsPlugin);
                BeansToolkit btk = wsPlugin.getBeansToolkit();
                logger.fine("BeansToolkit: " + btk);
                ClipboardManager cm = wsPlugin.getClipboardManager();
                logger.fine("ClipboardManager: " + cm);
                cv.setBeansToolkit(btk);
                cv.setManager(cm);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

