/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.AbstractPreferences;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.swing.BackgroundPanel;
import com.spacekiller.util.tooling.AbstractToolGroup;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.AnimatedDesktopManager;
import com.spacekiller.util.workbench.ComponentView;
import com.spacekiller.util.workbench.DesktopView;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.StatusBarView;
import com.spacekiller.util.workbench.ToolBarView;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewEvent;
import com.spacekiller.util.workbench.ViewListener;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchToolContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DefaultPerspective
extends Perspective {
    public static final String KEY_VIEW_COUNT = ".count";
    public static final String KEY_VIEW_PROVIDER_ID = "provider";
    public static final String KEY_VIEW_BOUNDS = "bounds";
    public static final String KEY_VIEW_MINIMIZED = "minimized";
    public static final String KEY_VIEW_MAXIMIZED = "maximized";
    public static final String KEY_VIEW_DETACHED = "detached";
    public static final String KEY_VIEW_DETACHED_BOUNDS = "detached.bounds";
    private static final Logger logger = Logger.getLogger(DefaultPerspective.class.getName());
    private ToolGroup toolbarGroup;
    private ToolGroup statusbarGroup;
    private ToolGroup systemTrayGroup;
    private ToolGroup startButtonGroup;
    private ToolGroup contextMenuGroup;
    private View windowView;
    private View toolbarView;
    private View contentView;
    private View statusbarView;
    private View systemTrayView;
    private View startButtonView;
    private Color defaultBackground = new Color(0.5f, 0.7f, 0.9f);
    private boolean customBackgroundEnabled = false;
    private String customBackgroundURL;
    private boolean customBackgroundStretch;
    private BackgroundPanel backgroundPanel;
    private boolean autoHideDetachedViews;
    private boolean windowAnimationEnabled;
    private DesktopViewHandler desktopViewHandler = new DesktopViewHandler();

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    @Override
    protected final View createMainView() {
        return this.getWindowView();
    }

    @Override
    protected void installView(View v) {
        View desk = this.getContentView();
        if (desk != null) {
            desk.addChild(v);
        }
    }

    @Override
    protected void uninstallView(View v) {
        View desk = this.getContentView();
        if (desk != null) {
            desk.removeChild(v);
        }
    }

    @Override
    public boolean maximizeView(View view) {
        DesktopView desk = (DesktopView)this.getContentView();
        return desk.maximizeView(view);
    }

    @Override
    public boolean minimizeView(View view) {
        DesktopView desk = (DesktopView)this.getContentView();
        return desk.minimizeView(view);
    }

    @Override
    public boolean detachView(View view) {
        DesktopView desk = (DesktopView)this.getContentView();
        return desk.detachView(view);
    }

    @Override
    public boolean restoreView(View view) {
        DesktopView desk = (DesktopView)this.getContentView();
        return desk.restoreView(view);
    }

    @Override
    public void toFront(View v) {
        if (v == null) {
            return;
        }
        DesktopView desk = (DesktopView)this.getContentView();
        desk.toFront(v);
    }

    public ToolGroup getStatusbarGroup() {
        return this.statusbarGroup;
    }

    public synchronized void setStatusbarGroup(ToolGroup group) {
        if (this.statusbarGroup != null) {
            throw new RuntimeException("StatusBar-Group already initialized.");
        }
        this.statusbarGroup = group;
        if (this.statusbarView != null) {
            ((StatusBarView)this.statusbarView).setGroup((AbstractToolGroup)group);
        }
    }

    public ToolGroup getToolbarGroup() {
        return this.toolbarGroup;
    }

    public synchronized void setToolbarGroup(ToolGroup group) {
        if (this.toolbarGroup != null) {
            throw new RuntimeException("ToolBar-Group already initialized.");
        }
        this.toolbarGroup = group;
        if (this.toolbarView != null) {
            ((ToolBarView)this.toolbarView).setGroup((AbstractToolGroup)group);
        }
    }

    protected View createContentView() {
        DesktopView desk = new DesktopView(this);
        desk.setWindowAnimationEnabled(this.windowAnimationEnabled);
        desk.addViewListener(this.desktopViewHandler);
        return desk;
    }

    public View getContentView() {
        if (this.contentView == null) {
            this.setContentView(this.createContentView());
        }
        return this.contentView;
    }

    protected void setContentView(View contentView) {
        this.contentView = contentView;
    }

    protected View createStatusbarView() {
        StatusBarView view = null;
        ToolGroup group = this.getStatusbarGroup();
        if (group != null) {
            view = new StatusBarView();
            Workbench wb = this.getWorkbench();
            WorkbenchToolContext context = wb.getWorkbenchToolContext();
            view.setToolContext(context);
            view.setGroup((AbstractToolGroup)group);
        }
        return view;
    }

    public View getStatusbarView() {
        if (this.statusbarView == null) {
            this.setStatusbarView(this.createStatusbarView());
        }
        return this.statusbarView;
    }

    protected void setStatusbarView(View statusView) {
        this.statusbarView = statusView;
    }

    protected View createToolbarView() {
        ToolBarView v = new ToolBarView();
        ToolGroup group = this.getToolbarGroup();
        if (group != null) {
            Workbench wb = this.getWorkbench();
            WorkbenchToolContext context = wb.getWorkbenchToolContext();
            v.setToolContext(context);
            v.setGroup((AbstractToolGroup)group);
        }
        return v;
    }

    public View getToolbarView() {
        if (this.toolbarView == null) {
            this.setToolbarView(this.createToolbarView());
        }
        return this.toolbarView;
    }

    protected void setToolbarView(View toolbarView) {
        this.toolbarView = toolbarView;
    }

    protected View createWindowView() {
        GridBagConstraints gbc;
        Component vc;
        JPanel panel = new JPanel();
        panel.setOpaque(true);
        panel.setLayout(new GridBagLayout());
        panel.setBackground(this.defaultBackground);
        View v = this.getToolbarView();
        Component component = vc = v == null ? null : v.getComponent();
        if (vc != null) {
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.gridx = 0;
            gbc2.gridy = 0;
            gbc2.gridwidth = 1;
            gbc2.fill = 2;
            gbc2.weightx = 1.0;
            gbc2.weighty = 0.0;
            panel.add(vc, gbc2);
        }
        BackgroundPanel back = new BackgroundPanel();
        back.setOpaque(true);
        back.setLayout((LayoutManager)new GridLayout(1, 1));
        back.setBackground(this.defaultBackground);
        if (this.customBackgroundEnabled) {
            back.setCustomBackgroundEnabled(true);
            back.setBackgroundPaint((Paint)this.defaultBackground);
            this.initCustomBackground(back);
        }
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.gridx = 0;
        gbc3.gridy = 1;
        gbc3.gridwidth = 1;
        gbc3.fill = 1;
        gbc3.weightx = 1.0;
        gbc3.weighty = 1.0;
        panel.add((Component)back, gbc3);
        this.backgroundPanel = back;
        v = this.getContentView();
        Component component2 = vc = v == null ? null : v.getComponent();
        if (vc != null) {
            logger.fine("Content: " + vc);
            if (vc instanceof JComponent) {
                ((JComponent)vc).setOpaque(false);
            }
            back.add(vc);
        }
        JPanel southPanel = new JPanel();
        southPanel.setOpaque(false);
        southPanel.setLayout(new BorderLayout());
        gbc3 = new GridBagConstraints();
        gbc3.gridx = 0;
        gbc3.gridy = 2;
        gbc3.gridwidth = 1;
        gbc3.fill = 2;
        gbc3.weightx = 1.0;
        gbc3.weighty = 0.0;
        panel.add((Component)southPanel, gbc3);
        JPanel southWestPanel = new JPanel();
        southWestPanel.setOpaque(false);
        southWestPanel.setLayout(new GridBagLayout());
        southPanel.add((Component)southWestPanel, "West");
        JPanel southCenterPanel = new JPanel();
        southCenterPanel.setOpaque(false);
        southCenterPanel.setLayout(new GridBagLayout());
        southPanel.add((Component)southCenterPanel, "Center");
        JPanel southEastPanel = new JPanel();
        southEastPanel.setOpaque(false);
        southEastPanel.setLayout(new GridBagLayout());
        southPanel.add((Component)southEastPanel, "East");
        v = this.getStartButtonView();
        Component component3 = vc = v == null ? null : v.getComponent();
        if (vc != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            southWestPanel.add(vc, gbc);
        }
        Component component4 = vc = (v = this.getStatusbarView()) == null ? null : v.getComponent();
        if (vc != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            southCenterPanel.add(vc, gbc);
        }
        Component component5 = vc = (v = this.getSystemTrayView()) == null ? null : v.getComponent();
        if (vc != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            southEastPanel.add(vc, gbc);
        }
        ComponentView winView = new ComponentView(panel);
        return winView;
    }

    protected View getWindowView() {
        if (this.windowView == null) {
            this.setWindowView(this.createWindowView());
        }
        return this.windowView;
    }

    protected void setWindowView(View windowView) {
        this.windowView = windowView;
    }

    protected void initCustomBackground(BackgroundPanel background) {
        String customBackgroundResource = this.getCustomBackgroundURL();
        Paint paint = this.defaultBackground;
        Image backImage = null;
        try {
            ImageIcon tempIcon;
            Image image;
            URL url = null;
            if (customBackgroundResource != null) {
                url = customBackgroundResource.startsWith("file:") ? new URL(customBackgroundResource) : this.getClass().getResource(customBackgroundResource);
            }
            if (url != null && (image = (tempIcon = new ImageIcon(url)).getImage()) != null) {
                if (this.customBackgroundStretch) {
                    backImage = image;
                } else {
                    int width = image.getWidth(null);
                    int height = image.getHeight(null);
                    if (width > 0 && height > 0) {
                        BufferedImage buf = new BufferedImage(width, height, 1);
                        Graphics bg = buf.getGraphics();
                        bg.drawImage(image, 0, 0, null);
                        bg.dispose();
                        Rectangle anchor = new Rectangle(width, height);
                        paint = new TexturePaint(buf, anchor);
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        background.setBackgroundPaint(paint);
        background.setBackgroundImage(backImage);
    }

    public Color getDefaultBackground() {
        return this.defaultBackground;
    }

    public synchronized void setDefaultBackground(Color defaultBackground) {
        this.defaultBackground = defaultBackground;
        this.refreshBackground();
    }

    public boolean isCustomBackgroundEnabled() {
        return this.customBackgroundEnabled;
    }

    public synchronized void setCustomBackgroundEnabled(boolean customBackgroundEnabled) {
        this.customBackgroundEnabled = customBackgroundEnabled;
        this.refreshBackground();
    }

    public String getCustomBackgroundURL() {
        return this.customBackgroundURL;
    }

    public synchronized void setCustomBackgroundURL(String customBackgroundURL) {
        this.customBackgroundURL = customBackgroundURL;
        this.refreshBackground();
    }

    public boolean isCustomBackgroundStretch() {
        return this.customBackgroundStretch;
    }

    public void setCustomBackgroundStretch(boolean customBackgroundStretch) {
        this.customBackgroundStretch = customBackgroundStretch;
    }

    protected synchronized void refreshBackground() {
        boolean def;
        if (this.backgroundPanel == null) {
            return;
        }
        boolean custom = this.isCustomBackgroundEnabled();
        boolean bl = def = !custom;
        if (custom) {
            this.backgroundPanel.setCustomBackgroundEnabled(true);
            this.backgroundPanel.setBackgroundPaint((Paint)this.defaultBackground);
            this.initCustomBackground(this.backgroundPanel);
        }
        if (def) {
            this.backgroundPanel.setCustomBackgroundEnabled(false);
            this.backgroundPanel.setBackground(this.defaultBackground);
        }
        this.backgroundPanel.validate();
        this.backgroundPanel.repaint();
    }

    @Override
    public synchronized void refresh() {
        super.refresh();
        if (this.toolbarGroup != null) {
            this.toolbarGroup.refresh();
        }
        if (this.toolbarView != null) {
            this.toolbarView.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePreferences(Preferences prefs) throws Exception {
        String[] propNames;
        String key;
        Object nameObj;
        PreferencesRegistry reg = Platform.getInstance().getPreferencesRegistry();
        int removeIndex = 0;
        while ((nameObj = prefs.getObject(key = "view." + removeIndex)) != null) {
            String viewPrefKey;
            prefs.setObject(key, null);
            if (nameObj instanceof String && reg.containsKey(viewPrefKey = (String)nameObj)) {
                reg.removePreferences(viewPrefKey);
            }
            ++removeIndex;
        }
        for (String propName : propNames = prefs.propertyNames()) {
            prefs.setObject(propName, null);
        }
        PreferencesImpl temp = new PreferencesImpl();
        int viewCount = this.getViewCount();
        int savedCount = 0;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Saving views: " + viewCount);
        }
        for (int i = 0; i < viewCount; ++i) {
            try {
                String providerId;
                View view = this.getViewAt(i);
                if (view == null) continue;
                ViewProvider provider = view.getProvider();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("save view: " + view + ", provider=" + provider);
                }
                if (provider == null || (providerId = provider.getId()) == null) continue;
                try {
                    provider.saveView(view, (Preferences)temp);
                    temp.setObject(KEY_VIEW_PROVIDER_ID, providerId);
                    View desk = this.getContentView();
                    if (desk != null) {
                        DesktopView desktop = (DesktopView)desk;
                        boolean minimized = desktop.isViewMinimized(view);
                        boolean maximized = desktop.isViewMaximized(view);
                        Rectangle viewBounds = desktop.getViewBounds(view);
                        if (maximized) {
                            viewBounds = desktop.getViewNormalBounds(view);
                        }
                        boolean detached = desktop.isViewDetached(view);
                        Rectangle detachedBounds = desktop.getViewDetachedBounds(view);
                        temp.setObject(KEY_VIEW_BOUNDS, viewBounds);
                        temp.setBoolean(KEY_VIEW_MINIMIZED, minimized);
                        temp.setBoolean(KEY_VIEW_MAXIMIZED, maximized);
                        temp.setBoolean(KEY_VIEW_DETACHED, detached);
                        temp.setObject(KEY_VIEW_DETACHED_BOUNDS, detachedBounds);
                    }
                    String viewPrefix = String.valueOf(savedCount) + ".";
                    Map<String, Object> map = temp.getMap();
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        prefs.setObject(viewPrefix + entry.getKey(), entry.getValue());
                    }
                    ++savedCount;
                    continue;
                }
                finally {
                    temp.clear();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        prefs.setInt(KEY_VIEW_COUNT, savedCount);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Saved views: " + savedCount);
        }
    }

    @Override
    public void loadPreferences(Preferences prefs) throws Exception {
        logger.fine("loadPreferences: " + this);
        Workbench wb = this.getWorkbench();
        logger.fine("Workbench: " + wb);
        if (wb == null) {
            return;
        }
        PreferencesRegistry reg = Platform.getInstance().getPreferencesRegistry();
        if (reg == null) {
            return;
        }
        int loadedCount = 0;
        if (prefs.contains(KEY_VIEW_COUNT)) {
            PreferencesImpl viewPrefs;
            int viewCount = 0;
            try {
                viewCount = prefs.getInt(KEY_VIEW_COUNT);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loading views: " + viewCount);
            }
            HashMap<String, PreferencesImpl> prefsMap = new HashMap<String, PreferencesImpl>();
            if (viewCount > 0) {
                String[] propNames;
                for (String propName : propNames = prefs.propertyNames()) {
                    int x = propName.indexOf(46);
                    if (x < 1) continue;
                    String viewPrefix = propName.substring(0, x);
                    viewPrefs = (PreferencesImpl)((Object)prefsMap.get(viewPrefix));
                    if (viewPrefs == null) {
                        viewPrefs = new PreferencesImpl();
                        prefsMap.put(viewPrefix, viewPrefs);
                    }
                    viewPrefs.setObject(propName.substring(x + 1), prefs.getObject(propName));
                }
            }
            LinkedList<ViewInfo> viewInfoList = new LinkedList<ViewInfo>();
            for (int i = 0; i < viewCount; ++i) {
                try {
                    Object detachedBoundsObj;
                    Object detachedObj;
                    Object maximizedObj;
                    Object minimizedObj;
                    View view;
                    Object objProviderId;
                    viewPrefs = (PreferencesImpl)((Object)prefsMap.get(String.valueOf(i)));
                    if (viewPrefs == null || (objProviderId = viewPrefs.getObject(KEY_VIEW_PROVIDER_ID)) == null) continue;
                    String providerId = String.valueOf(objProviderId);
                    ViewProvider provider = wb.getViewProvider(providerId);
                    if (provider == null) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.warning("WARNING: view provider not found: id=" + providerId);
                        continue;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Loading view #" + i + ": provider=" + provider);
                    }
                    if ((view = provider.loadView((Preferences)viewPrefs)) == null) continue;
                    ViewInfo viewInfo = new ViewInfo();
                    viewInfo.view = view;
                    Object boundsObj = viewPrefs.getObject(KEY_VIEW_BOUNDS);
                    if (boundsObj != null && boundsObj instanceof Rectangle) {
                        viewInfo.bounds = (Rectangle)boundsObj;
                    }
                    if ((minimizedObj = viewPrefs.getObject(KEY_VIEW_MINIMIZED)) != null) {
                        viewInfo.minimized = Boolean.parseBoolean(String.valueOf(minimizedObj));
                    }
                    if ((maximizedObj = viewPrefs.getObject(KEY_VIEW_MAXIMIZED)) != null) {
                        viewInfo.maximized = Boolean.parseBoolean(String.valueOf(maximizedObj));
                    }
                    if ((detachedObj = viewPrefs.getObject(KEY_VIEW_DETACHED)) != null) {
                        viewInfo.detached = Boolean.parseBoolean(String.valueOf(detachedObj));
                    }
                    if ((detachedBoundsObj = viewPrefs.getObject(KEY_VIEW_DETACHED_BOUNDS)) != null && detachedBoundsObj instanceof Rectangle) {
                        viewInfo.detachedBounds = (Rectangle)detachedBoundsObj;
                    }
                    viewInfoList.add(viewInfo);
                    ++loadedCount;
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Loaded view: " + view);
                    continue;
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            SwingUtilities.invokeLater(new ViewsInstaller(viewInfoList));
        } else if (prefs.contains("viewCount")) {
            int viewCount = prefs.getInt("viewCount");
            logger.fine("Loading views: " + viewCount);
            for (int i = 0; i < viewCount; ++i) {
                try {
                    String viewPrefKey;
                    Preferences viewPrefs;
                    Object viewKey = prefs.getObject("view." + i);
                    if (viewKey == null || (viewPrefs = reg.getPreferences(viewPrefKey = String.valueOf(viewKey))) == null) continue;
                    logger.fine("Loading view preferences: " + viewPrefs);
                    Object objProviderId = viewPrefs.getObject("view.provider");
                    if (objProviderId == null) continue;
                    String providerId = String.valueOf(objProviderId);
                    ViewProvider provider = wb.getViewProvider(providerId);
                    if (provider == null) {
                        logger.fine("WARNING: view provider not found: id=" + providerId);
                        continue;
                    }
                    logger.fine("Loading view: provider=" + provider);
                    final View view = provider.loadView(viewPrefs);
                    if (view == null) continue;
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Object detached;
                                Object detachedBounds;
                                Rectangle viewBounds = (Rectangle)viewPrefs.getObject("view.bounds");
                                DefaultPerspective.this.addView(view);
                                DesktopView desktop = null;
                                View desk = DefaultPerspective.this.getContentView();
                                if (desk != null && desk instanceof DesktopView) {
                                    desktop = (DesktopView)desk;
                                }
                                if (desktop == null) {
                                    return;
                                }
                                if (viewBounds != null) {
                                    desktop.setViewBounds(view, viewBounds);
                                    boolean minimized = viewPrefs.getBoolean("view.minimized");
                                    boolean maximized = viewPrefs.getBoolean("view.maximized");
                                    JDesktopPane deskPane = desktop.getDesktop();
                                    DesktopManager manager = deskPane == null ? null : deskPane.getDesktopManager();
                                    AnimatedDesktopManager animatedManager = null;
                                    boolean animated = false;
                                    if (manager != null && manager instanceof AnimatedDesktopManager) {
                                        animatedManager = (AnimatedDesktopManager)manager;
                                        animated = animatedManager.isAnimated();
                                        animatedManager.setAnimated(false);
                                    }
                                    desktop.setViewMinimized(view, minimized);
                                    desktop.setViewMaximized(view, maximized);
                                    if (animated && animatedManager != null) {
                                        animatedManager.setAnimated(animated);
                                    }
                                }
                                if ((detachedBounds = viewPrefs.getObject("view.detachedBounds")) != null && detachedBounds instanceof Rectangle) {
                                    desktop.setViewDetachedBounds(view, (Rectangle)detachedBounds);
                                }
                                if ((detached = viewPrefs.getObject("view.detached")) != null && new Boolean(detached.toString()).booleanValue()) {
                                    desktop.detachView(view);
                                }
                            }
                            catch (Exception e) {
                                DefaultPerspective.this.handleException(e);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(run);
                    ++loadedCount;
                    continue;
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded views: " + loadedCount);
        }
    }

    public ToolGroup getSystemTrayGroup() {
        return this.systemTrayGroup;
    }

    public void setSystemTrayGroup(ToolGroup group) {
        if (this.systemTrayGroup != null) {
            throw new RuntimeException("SystemTray-Group already initialized.");
        }
        this.systemTrayGroup = group;
        if (this.systemTrayView != null) {
            ((StatusBarView)this.systemTrayView).setGroup((AbstractToolGroup)group);
        }
    }

    protected View createSystemTrayView() {
        StatusBarView view = null;
        ToolGroup group = this.getSystemTrayGroup();
        if (group != null) {
            view = new StatusBarView();
            Workbench wb = this.getWorkbench();
            WorkbenchToolContext context = wb.getWorkbenchToolContext();
            view.setToolContext(context);
            view.setGroup((AbstractToolGroup)group);
        }
        return view;
    }

    public View getSystemTrayView() {
        if (this.systemTrayView == null) {
            this.setSystemTrayView(this.createSystemTrayView());
        }
        return this.systemTrayView;
    }

    protected void setSystemTrayView(View systemTrayView) {
        this.systemTrayView = systemTrayView;
    }

    protected View createStartButtonView() {
        StatusBarView view = null;
        ToolGroup group = this.getStartButtonGroup();
        if (group != null) {
            view = new StatusBarView();
            Workbench wb = this.getWorkbench();
            WorkbenchToolContext context = wb.getWorkbenchToolContext();
            view.setToolContext(context);
            view.setGroup((AbstractToolGroup)group);
        }
        return view;
    }

    public View getStartButtonView() {
        if (this.startButtonView == null) {
            this.setStartButtonView(this.createStartButtonView());
        }
        return this.startButtonView;
    }

    protected void setStartButtonView(View startButtonView) {
        this.startButtonView = startButtonView;
    }

    public ToolGroup getStartButtonGroup() {
        return this.startButtonGroup;
    }

    public void setStartButtonGroup(ToolGroup group) {
        if (this.startButtonGroup != null) {
            throw new RuntimeException("SystemTray-Group already initialized.");
        }
        this.startButtonGroup = group;
        if (this.startButtonView != null) {
            ((StatusBarView)this.startButtonView).setGroup((AbstractToolGroup)group);
        }
    }

    public ToolGroup getContextMenuGroup() {
        return this.contextMenuGroup;
    }

    public void setContextMenuGroup(ToolGroup contextMenuGroup) {
        this.contextMenuGroup = contextMenuGroup;
    }

    public boolean isWindowAnimationEnabled() {
        return this.windowAnimationEnabled;
    }

    public void setWindowAnimationEnabled(boolean windowAnimationEnabled) {
        this.windowAnimationEnabled = windowAnimationEnabled;
        if (this.contentView != null && this.contentView instanceof DesktopView) {
            DesktopView desk = (DesktopView)this.contentView;
            desk.setWindowAnimationEnabled(windowAnimationEnabled);
        }
    }

    public boolean isAutoHideDetachedViews() {
        return this.autoHideDetachedViews;
    }

    public void setAutoHideDetachedViews(boolean autoHideDetachedViews) {
        this.autoHideDetachedViews = autoHideDetachedViews;
        if (this.contentView != null && this.contentView instanceof DesktopView) {
            DesktopView desk = (DesktopView)this.contentView;
            desk.setAutoHideDetachedViews(autoHideDetachedViews);
        }
    }

    @Override
    public void workbenchActivated(WindowEvent ev) {
        View desk = this.contentView;
        if (desk != null && desk instanceof DesktopView) {
            ((DesktopView)desk).workbenchActivated(ev);
        }
    }

    @Override
    public void workbenchDeactivated(WindowEvent ev) {
        View desk = this.contentView;
        if (desk != null && desk instanceof DesktopView) {
            ((DesktopView)desk).workbenchDeactivated(ev);
        }
    }

    @Override
    public void workbenchIconified(WindowEvent ev) {
        View desk = this.contentView;
        if (desk != null && desk instanceof DesktopView) {
            ((DesktopView)desk).workbenchIconified(ev);
        }
    }

    @Override
    public void workbenchDeiconified(WindowEvent ev) {
        View desk = this.contentView;
        if (desk != null && desk instanceof DesktopView) {
            ((DesktopView)desk).workbenchDeiconified(ev);
        }
    }

    protected class ViewsInstaller
    implements Runnable {
        private List<ViewInfo> infoList;

        public ViewsInstaller(List<ViewInfo> infoList) {
            this.infoList = infoList;
        }

        @Override
        public void run() {
            for (ViewInfo info : this.infoList) {
                try {
                    boolean detached;
                    Rectangle detachedBounds;
                    View view = info.view;
                    DefaultPerspective.this.addView(view);
                    DesktopView desktop = null;
                    View desk = DefaultPerspective.this.getContentView();
                    if (desk != null && desk instanceof DesktopView) {
                        desktop = (DesktopView)desk;
                    }
                    if (desktop == null) continue;
                    Rectangle viewBounds = info.bounds;
                    if (viewBounds != null) {
                        desktop.setViewBounds(view, viewBounds);
                        boolean minimized = info.minimized;
                        boolean maximized = info.maximized;
                        JDesktopPane deskPane = desktop.getDesktop();
                        DesktopManager manager = deskPane == null ? null : deskPane.getDesktopManager();
                        AnimatedDesktopManager animatedManager = null;
                        boolean animated = false;
                        if (manager != null && manager instanceof AnimatedDesktopManager) {
                            animatedManager = (AnimatedDesktopManager)manager;
                            animated = animatedManager.isAnimated();
                            animatedManager.setAnimated(false);
                        }
                        desktop.setViewMinimized(view, minimized);
                        desktop.setViewMaximized(view, maximized);
                        if (animated && animatedManager != null) {
                            animatedManager.setAnimated(animated);
                        }
                    }
                    if ((detachedBounds = info.detachedBounds) != null) {
                        desktop.setViewDetachedBounds(view, detachedBounds);
                    }
                    if (!(detached = info.detached)) continue;
                    desktop.detachView(view);
                }
                catch (Throwable e) {
                    DefaultPerspective.this.handleException(e);
                }
            }
        }
    }

    protected static class ViewInfo {
        protected View view;
        protected Rectangle bounds;
        protected boolean minimized;
        protected boolean maximized;
        protected boolean detached;
        protected Rectangle detachedBounds;

        protected ViewInfo() {
        }
    }

    protected static class PreferencesImpl
    extends AbstractPreferences {
        protected PreferencesImpl() {
        }

        protected IllegalArgumentException getFailed(String k, Object v, Class type) {
            throw new IllegalArgumentException("key=" + k + ", type=" + type + ", value=" + v);
        }

        protected synchronized void clear() {
            super.clear();
        }

        protected Map<String, Object> getMap() {
            return this.map;
        }
    }

    protected class DesktopViewHandler
    implements ViewListener {
        protected DesktopViewHandler() {
        }

        @Override
        public void viewsInserted(ViewEvent ev) {
        }

        @Override
        public void viewsRemoved(ViewEvent ev) {
            View parent = ev.getView();
            if (parent == null) {
                return;
            }
            View[] views = ev.getChildren();
            if (views == null) {
                return;
            }
            for (int i = 0; i < views.length; ++i) {
                View v = views[i];
                if (v == null) continue;
                DefaultPerspective.this.removeView(v);
            }
        }
    }
}

