/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.workbench.SelectionManager;
import com.spacekiller.util.workbench.SelectionToolContext;
import com.spacekiller.util.workbench.SelectionToolContextMenu;
import com.spacekiller.util.workbench.WorkbenchExtensions;
import java.awt.Component;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class NewObjectMenu
extends SelectionToolContextMenu {
    private static final Logger logger = Logger.getLogger(NewObjectMenu.class.getName());

    protected void refreshInstance(Object c) {
        super.refreshInstance(c);
        if (c == null) {
            return;
        }
        if (!(c instanceof JMenu)) {
            return;
        }
        JMenu menu = (JMenu)c;
        menu.removeAll();
        ToolContext tc = this.getToolContext(c);
        if (tc == null) {
            return;
        }
        try {
            if (tc instanceof SelectionToolContext) {
                Selection selection;
                SelectionToolContext stc = (SelectionToolContext)tc;
                SelectionManager sm = stc.getSelectionManager();
                Selection selection2 = selection = sm == null ? null : sm.getSelection();
                if (selection != null) {
                    Tool[] tools;
                    ArrayList objs = new ArrayList();
                    selection.getSelectedObjects(objs);
                    if (!objs.isEmpty() && (tools = WorkbenchExtensions.getObjectCreateActions(sm.getWorkbench(), objs)) != null) {
                        for (int i = 0; i < tools.length; ++i) {
                            Tool t = tools[i];
                            if (t == null) continue;
                            Component item = (Component)t.createInstance((ToolContext)stc, JMenuItem.class);
                            menu.add(item);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        boolean enable = menu.getMenuComponentCount() > 0;
        menu.setEnabled(enable);
    }
}

