/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.tooling.TMenu;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchAction;
import com.spacekiller.util.workbench.WorkbenchPlugin;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenViewMenu
extends TMenu {
    private static final Logger logger = Logger.getLogger(OpenViewMenu.class.getName());

    public OpenViewMenu() {
        try {
            WorkbenchPlugin wbPlugin = WorkbenchUtilities.getWorkbenchPlugin();
            BeanContext viewProviders = wbPlugin.getViewProviders();
            if (viewProviders != null) {
                viewProviders.addBeanContextMembershipListener(new ViewProviderHandler());
                for (Object o : viewProviders) {
                    if (o == null || !(o instanceof ViewProvider)) continue;
                    ViewProvider vp = (ViewProvider)o;
                    this.handleViewProviderAdded(vp);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void handleViewProviderAdded(ViewProvider vp) {
        OpenViewAction test1 = new OpenViewAction(vp);
        test1.setName("" + vp.getName());
        test1.setText("" + vp.getName());
        test1.setTooltip(vp.getTooltip());
        test1.setIcon(vp.getIcon());
        test1.setPriority(vp.getPriority());
        this.addChild((Tool)test1);
    }

    protected void handleViewProviderRemoved(ViewProvider vp) {
        logger.fine("TODO remove OpenView-Menu: " + vp);
    }

    protected void openView(ViewProvider vp, Workbench wb) {
        if (vp == null || wb == null) {
            return;
        }
        try {
            logger.fine("Open View: " + vp);
            Perspective pers = wb.getPerspective();
            if (pers != null) {
                View view = vp.createView();
                logger.fine("View: " + view);
                if (view != null) {
                    pers.addView(view);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected class ViewProviderHandler
    implements BeanContextMembershipListener {
        protected ViewProviderHandler() {
        }

        @Override
        public void childrenAdded(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o == null || !(o instanceof ViewProvider)) continue;
                ViewProvider vp = (ViewProvider)o;
                OpenViewMenu.this.handleViewProviderAdded(vp);
            }
        }

        @Override
        public void childrenRemoved(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o == null || !(o instanceof ViewProvider)) continue;
                ViewProvider vp = (ViewProvider)o;
                OpenViewMenu.this.handleViewProviderRemoved(vp);
            }
        }
    }

    protected class OpenViewAction
    extends WorkbenchAction {
        private ViewProvider viewProvider;

        public OpenViewAction(ViewProvider viewProvider) {
            this.setViewProvider(viewProvider);
        }

        public void invoke(Object instance) {
            Workbench wb = this.getWorkbench(instance);
            OpenViewMenu.this.openView(this.viewProvider, wb);
        }

        public ViewProvider getViewProvider() {
            return this.viewProvider;
        }

        protected void setViewProvider(ViewProvider viewProvider) {
            this.viewProvider = viewProvider;
        }
    }
}

