/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.swing.TransTreeCellRenderer;
import com.spacekiller.util.workbench.PreferencesPage;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PreferencesPanel
extends JPanel {
    private static final long serialVersionUID = 6421657148077246248L;
    private Map pages;
    private View view;
    private Map pageViews;
    private DefaultTreeModel pagesTreeModel;
    private JPanel jPanelPrefs = null;
    private JPanel jPanel = null;
    private JButton jButtonSave = null;
    private JButton jButtonCancel = null;
    private JSplitPane jSplitPane = null;
    private JPanel jPanel1 = null;
    private JPanel jPanelPrefPage = null;
    private JScrollPane jScrollPane = null;
    private JTree jTreePages = null;
    private JScrollPane jScrollPanePrefPage = null;
    private static final Logger logger = Logger.getLogger(PreferencesPanel.class.getName());

    public PreferencesPanel() {
        this.initialize();
        this.initPreferencesPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(413, 298));
        this.add((Component)this.getJPanelPrefs(), gridBagConstraints1);
        this.add((Component)this.getJPanel(), gridBagConstraints2);
    }

    protected void initPreferencesPanel() {
        this.pages = new HashMap();
        this.pageViews = new HashMap();
        this.getJTree().setCellRenderer((TreeCellRenderer)((Object)new PreferencesTreeCellRenderer()));
    }

    public void addPreferencesPage(PreferencesPage page) {
        if (page == null) {
            return;
        }
        String pid = page.getId();
        if (pid == null) {
            return;
        }
        this.pages.put(pid, page);
    }

    public void removePreferencesPage(PreferencesPage page) {
        if (page == null) {
            return;
        }
        String pid = page.getId();
        if (pid != null) {
            this.pages.remove(pid);
        }
    }

    public void refresh() {
        logger.fine("Refresh preferences: pages=" + this.pages.size());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel model = new DefaultTreeModel(root);
        HashMap<String, DefaultMutableTreeNode> nodeMap = new HashMap<String, DefaultMutableTreeNode>();
        for (PreferencesPage page : this.pages.values()) {
            String id = page.getId();
            if (id == null) continue;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            node.setUserObject(page);
            nodeMap.put(id, node);
        }
        for (DefaultMutableTreeNode node : nodeMap.values()) {
            PreferencesPage page = (PreferencesPage)node.getUserObject();
            String parentId = page.getParentId();
            DefaultMutableTreeNode parentNode = null;
            if (parentId != null && parentId.length() > 0) {
                parentNode = (DefaultMutableTreeNode)nodeMap.get(parentId);
            }
            if (parentNode == node) {
                parentNode = null;
            }
            if (parentNode == null) {
                parentNode = root;
            }
            int insertIndex = -1;
            double prio = page.getPriority();
            int n = parentNode.getChildCount();
            for (int k = 0; k < n; ++k) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)parentNode.getChildAt(k);
                PreferencesPage other = (PreferencesPage)child.getUserObject();
                if (!(prio > other.getPriority())) continue;
                insertIndex = k;
                break;
            }
            if (insertIndex < 0) {
                insertIndex = n;
            }
            model.insertNodeInto(node, parentNode, insertIndex);
        }
        this.pagesTreeModel = model;
        this.getJTree().setModel(model);
        int num = root.getChildCount();
        for (int i = 0; i < num; ++i) {
            TreeNode node = root.getChildAt(i);
            TreePath path = new TreePath(new Object[]{root, node});
            this.getJTree().expandPath(path);
        }
    }

    private JPanel getJPanelPrefs() {
        if (this.jPanelPrefs == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.jPanelPrefs = new JPanel();
            this.jPanelPrefs.setLayout(new GridBagLayout());
            this.jPanelPrefs.setOpaque(false);
            this.jPanelPrefs.add((Component)this.getJSplitPane(), gridBagConstraints);
        }
        return this.jPanelPrefs;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJButtonSave(), gridBagConstraints3);
            this.jPanel.add((Component)this.getJButtonCancel(), gridBagConstraints4);
        }
        return this.jPanel;
    }

    private JButton getJButtonSave() {
        if (this.jButtonSave == null) {
            this.jButtonSave = new JButton();
            this.jButtonSave.setText("Save");
            this.jButtonSave.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreferencesPanel.this.actionSave();
                }
            });
        }
        return this.jButtonSave;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreferencesPanel.this.actionCancel();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOpaque(false);
            this.jSplitPane.setLeftComponent(this.getJPanel1());
            this.jSplitPane.setRightComponent(this.getJPanel2());
        }
        return this.jSplitPane;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.weightx = 1.0;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.setOpaque(false);
            this.jPanel1.add((Component)this.getJScrollPane(), gridBagConstraints5);
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanelPrefPage == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridx = 0;
            this.jPanelPrefPage = new JPanel();
            this.jPanelPrefPage.setLayout(new GridBagLayout());
            this.jPanelPrefPage.setOpaque(false);
            this.jPanelPrefPage.add((Component)this.getJScrollPanePrefPage(), gridBagConstraints6);
        }
        return this.jPanelPrefPage;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJTree());
        }
        return this.jScrollPane;
    }

    private JTree getJTree() {
        if (this.jTreePages == null) {
            this.jTreePages = new JTree();
            this.jTreePages.setOpaque(false);
            this.jTreePages.setRootVisible(false);
            this.jTreePages.setShowsRootHandles(true);
            this.jTreePages.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    PreferencesPanel.this.actionPageSelected();
                }
            });
        }
        return this.jTreePages;
    }

    private JScrollPane getJScrollPanePrefPage() {
        if (this.jScrollPanePrefPage == null) {
            this.jScrollPanePrefPage = new JScrollPane();
            this.jScrollPanePrefPage.setOpaque(false);
        }
        return this.jScrollPanePrefPage;
    }

    protected void actionPageSelected() {
        PreferencesPage sel = this.getSelectedPreferencesPage();
        Component comp = null;
        if (sel != null) {
            try {
                View view = (View)this.pageViews.get(sel);
                if (view == null && (view = sel.createView()) != null) {
                    this.pageViews.put(sel, view);
                    this.view.addChild(view);
                    sel.refreshPreferences(view);
                }
                comp = view == null ? null : view.getComponent();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        this.getJScrollPanePrefPage().setViewportView(comp);
        this.getJScrollPanePrefPage().validate();
        this.getJScrollPanePrefPage().repaint();
    }

    protected void actionSave() {
        int errors = 0;
        for (Map.Entry entry : this.pageViews.entrySet()) {
            PreferencesPage page = (PreferencesPage)entry.getKey();
            View view = (View)entry.getValue();
            if (page == null || view == null) continue;
            try {
                page.savePreferences(view);
            }
            catch (Exception e) {
                ++errors;
                this.handleException(e);
            }
        }
        if (this.view != null && errors <= 0) {
            this.view.close();
        }
    }

    protected void actionCancel() {
        if (this.view != null) {
            this.view.close();
        }
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public PreferencesPage getSelectedPreferencesPage() {
        DefaultMutableTreeNode node;
        PreferencesPage sel = null;
        TreePath path = this.getJTree().getSelectionPath();
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()) != null) {
            sel = (PreferencesPage)node.getUserObject();
        }
        return sel;
    }

    public String getSelectedPreferencesPageId() {
        PreferencesPage page = this.getSelectedPreferencesPage();
        return page == null ? null : page.getId();
    }

    public void setSelectedPreferencesPageId(String selectedPreferencesPageId) {
        TreePath path = null;
        PreferencesPage page = (PreferencesPage)this.pages.get(selectedPreferencesPageId);
        logger.fine("setSelectedPreferencesPageId: " + selectedPreferencesPageId + " = " + page);
        if (page != null) {
            path = this.findTreePath(page);
        }
        logger.fine("select path: " + path);
        if (path != null) {
            this.getJTree().setSelectionPath(path);
        } else {
            this.getJTree().clearSelection();
        }
    }

    private TreePath findTreePath(PreferencesPage page) {
        TreeModel model = this.getJTree().getModel();
        TreeNode root = (TreeNode)model.getRoot();
        if (root == null) {
            return null;
        }
        TreeNode node = this.findTreeNode(root, page);
        if (node == null) {
            return null;
        }
        DefaultTreeModel defModel = (DefaultTreeModel)model;
        return new TreePath(defModel.getPathToRoot(node));
    }

    private TreeNode findTreeNode(TreeNode node, PreferencesPage page) {
        DefaultMutableTreeNode def;
        if (node instanceof DefaultMutableTreeNode && page == (def = (DefaultMutableTreeNode)node).getUserObject()) {
            return node;
        }
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeNode child = node.getChildAt(i);
            if ((child = this.findTreeNode(child, page)) == null) continue;
            return child;
        }
        return null;
    }

    protected class PreferencesTreeCellRenderer
    extends TransTreeCellRenderer {
        private static final long serialVersionUID = -1495638178330863556L;

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object obj;
            Component rc = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            String text = null;
            Icon icon = null;
            String tooltip = null;
            if (value != null && value instanceof DefaultMutableTreeNode && (obj = (node = (DefaultMutableTreeNode)value).getUserObject()) != null && obj instanceof PreferencesPage) {
                PreferencesPage page = (PreferencesPage)obj;
                text = page.getName();
                icon = page.getIcon();
                tooltip = page.getTooltip();
            }
            if (text == null) {
                text = String.valueOf(value);
            }
            this.setText(text);
            this.setIcon(icon);
            this.setToolTipText(tooltip);
            return rc;
        }
    }
}

