/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.beans.AnchorlessBeanContext;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanObserver;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.Selectable;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.beans.model.BeanTreeComparator;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.BeanTreeView;
import com.spacekiller.util.workbench.ConstructorView;
import com.spacekiller.util.workbench.ScratchpadPanel;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.beancontext.BeanContext;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class ScratchpadView
extends View
implements BeanObserver,
Selectable {
    private BeanContext rootContext;
    private BeansToolkit beansToolkit;
    private BeanDropSupport beanDropSupport;
    private BeanTreeComparator beanTreeComparator;
    private FeatureDescriptorFilter featureDescriptorFilter;
    private ToolGroup toolbarGroup;
    private ToolGroup popupMenuToolGroup;
    private ScratchpadPanel scratchpadPanel;

    public ScratchpadView() {
        this.initScratchpadView();
    }

    protected void initScratchpadView() {
        AnchorlessBeanContext bc = new AnchorlessBeanContext();
        this.setRootContext((BeanContext)bc);
    }

    @Override
    protected Component createComponent() {
        return this.getScratchpadPanel();
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected ScratchpadPanel createScratchpadPanel() {
        ScratchpadPanel panel = new ScratchpadPanel();
        panel.setScratchpadView(this);
        panel.setBeansToolkit(this.getBeansToolkit());
        panel.setToolbarGroup(this.toolbarGroup);
        BeanTreeView btv = new BeanTreeView();
        btv.setBeanDropSupport(this.beanDropSupport);
        btv.setBeansToolkit(this.beansToolkit);
        btv.setBeanTreeComparator(this.beanTreeComparator);
        btv.setFeatureDescriptorFilter(this.featureDescriptorFilter);
        btv.setPopupMenuToolGroup(this.popupMenuToolGroup);
        btv.setRootContext(this.rootContext);
        this.addChild(btv);
        panel.setBeanTreeView(btv);
        panel.setPreferredSize(new Dimension(300, 300));
        return panel;
    }

    public ScratchpadPanel getScratchpadPanel() {
        if (this.scratchpadPanel == null) {
            this.setScratchpadPanel(this.createScratchpadPanel());
        }
        return this.scratchpadPanel;
    }

    private void setScratchpadPanel(ScratchpadPanel scratchpadPanel) {
        this.scratchpadPanel = scratchpadPanel;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        if (this.scratchpadPanel != null) {
            this.scratchpadPanel.setBeansToolkit(beansToolkit);
        }
    }

    public void actionCreate() {
        ConstructorView cv = new ConstructorView();
        BeansToolkit btk = this.getBeansToolkit();
        ClassRegistry reg = btk == null ? null : btk.getClassRegistry();
        cv.setBeansToolkit(btk);
        cv.setClassRegistry(reg);
        cv.setSelectedBeanObserver(this);
        this.getPerspective().addView(cv);
    }

    public boolean addBean(Object o) throws Exception {
        if (this.rootContext == null) {
            return false;
        }
        return this.rootContext.add(o);
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    public BeanTreeComparator getBeanTreeComparator() {
        return this.beanTreeComparator;
    }

    public void setBeanTreeComparator(BeanTreeComparator beanTreeComparator) {
        this.beanTreeComparator = beanTreeComparator;
    }

    public FeatureDescriptorFilter getFeatureDescriptorFilter() {
        return this.featureDescriptorFilter;
    }

    public void setFeatureDescriptorFilter(FeatureDescriptorFilter featureDescriptorFilter) {
        this.featureDescriptorFilter = featureDescriptorFilter;
    }

    public ToolGroup getPopupMenuToolGroup() {
        return this.popupMenuToolGroup;
    }

    public void setPopupMenuToolGroup(ToolGroup popupMenuToolGroup) {
        this.popupMenuToolGroup = popupMenuToolGroup;
    }

    protected BeanContext getRootContext() {
        return this.rootContext;
    }

    protected void setRootContext(BeanContext rootContext) {
        this.rootContext = rootContext;
    }

    public Selection getSelection() {
        return this.scratchpadPanel.getBeanTreeView().getSelection();
    }

    public ToolGroup getToolbarGroup() {
        return this.toolbarGroup;
    }

    public void setToolbarGroup(ToolGroup toolbarGroup) {
        this.toolbarGroup = toolbarGroup;
    }

    @Override
    public boolean isDirty() throws Exception {
        SyncManager sync;
        Workspace ws;
        Workbench wb;
        if (super.isDirty()) {
            return true;
        }
        BeanContext bc = this.rootContext;
        if (bc != null && !bc.isEmpty() && (wb = this.getWorkbench()) != null && (ws = wb.getWorkspace()) != null && (sync = ws.getSyncManager()) != null) {
            Iterator i = bc.iterator();
            while (i.hasNext()) {
                if (!sync.isTransient(i.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean promptClose() throws Exception {
        if (!this.isDirty()) {
            return true;
        }
        String title = "Discard ?";
        String message = "There are one or more references to transient objects.";
        message = message + "\n";
        message = message + "\n\nAre you sure to close the view ?";
        int optionType = 0;
        int messageType = 3;
        int rc = JOptionPane.showConfirmDialog(this.getComponent(), message, title, optionType, messageType);
        return rc == 0;
    }
}

