/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.tooling.TMenu;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.workbench.SelectionCondition;
import com.spacekiller.util.workbench.SelectionManager;
import com.spacekiller.util.workbench.SelectionToolContext;
import javax.swing.JMenu;

public abstract class SelectionToolContextMenu
extends TMenu {
    protected JMenu createMenu(ToolContext context, Class type) {
        if (context == null) {
            throw new NullPointerException("ToolContext not specified");
        }
        if (context instanceof SelectionToolContext) {
            SelectionToolContext stc = (SelectionToolContext)context;
            return new DynamicMenu(stc);
        }
        return null;
    }

    protected class SelectionConditionImpl
    extends SelectionCondition {
        private DynamicMenu menu;

        public SelectionConditionImpl(DynamicMenu menu) {
            this.menu = menu;
        }

        @Override
        protected void selectionChanged(Selection selection) {
            SelectionToolContextMenu.this.refreshInstance(this.menu);
        }
    }

    protected class DynamicMenu
    extends JMenu {
        private static final long serialVersionUID = -3895602447844587146L;
        private SelectionToolContext context;
        private SelectionManager manager;
        private SelectionCondition handler;

        public DynamicMenu(SelectionToolContext context) {
            this.context = context;
            this.handler = new SelectionConditionImpl(this);
            this.setManager(context.getSelectionManager());
        }

        protected SelectionManager getManager() {
            return this.manager;
        }

        protected void setManager(SelectionManager newManager) {
            if (this.manager == newManager) {
                return;
            }
            if (this.manager != null) {
                this.manager.removeSelectionCondition(this.handler);
            }
            this.manager = newManager;
            if (this.manager != null) {
                this.manager.addSelectionCondition(this.handler);
            }
        }
    }
}

