/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.swing.AbstractCellRenderer;
import com.spacekiller.util.workbench.SynchronizationView;
import com.spacekiller.util.workspace.ResyncManager;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.Synchronization;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;

public class SynchronizationPanel
extends JPanel {
    private static final long serialVersionUID = 8528599910338878666L;
    public static final int MODE_OUTGOING = 0;
    public static final int MODE_INCOMING = 1;
    public static final int MODE_CONFLICTS = 2;
    private int mode = 0;
    private SynchronizationView syncView;
    private BeansToolkit beansToolkit;
    private FeatureDescriptorFilter featureDescriptorFilter;
    private SyncManager syncManager;
    private Synchronization sync;
    private ResyncManager resyncManager;
    private Icon defaultIcon;
    private Icon arrayIcon;
    private Comparator changeComparator;
    private JPanel jPanel = null;
    private JPanel jPanelContent = null;
    private JToggleButton jToggleButtonConflicts = null;
    private JToggleButton jToggleButtonOutgoing = null;
    private JToggleButton jToggleButtonIncoming = null;
    private JPanel jPanelHead = null;
    private JLabel jLabelInfo = null;
    private JPanel jPanelOut = null;
    private JPanel jPanel1 = null;
    private JButton jButtonSave = null;
    private JButton jButtonResync = null;
    private JPanel jPanelUpdate = null;
    private JPanel jPanel3 = null;
    private JButton jButtonUpdate = null;
    private JButton jButtonRefresh = null;
    private JScrollPane jScrollPaneUpdate = null;
    private JPanel jPanelConflicts = null;
    private JPanel jPanel5 = null;
    private JButton jButton = null;
    private JButton jButtonConflictRefresh = null;
    private static final Logger logger = Logger.getLogger(SynchronizationPanel.class.getName());
    private JScrollPane jScrollPaneOut = null;
    private JList jListOut = null;
    private JList jListUpdate = null;
    private JScrollPane jScrollPaneConflict = null;
    private JList jListConflict = null;

    public SynchronizationPanel() {
        this.initialize();
        this.initSyncPanel();
    }

    protected void initSyncPanel() {
        this.changeComparator = new DefaultComparator();
        ButtonGroup group = new ButtonGroup();
        group.add(this.getJToggleButtonOutgoing());
        group.add(this.getJToggleButtonIncoming());
        group.add(this.getJToggleButtonConflicts());
        this.setDefaultIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/bean.gif")));
        this.setArrayIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/array.gif")));
        ToolTipManager tooltipManager = ToolTipManager.sharedInstance();
        SyncListCellRenderer syncListCellRenderer = new SyncListCellRenderer();
        tooltipManager.registerComponent(this.getJListOut());
        this.getJListOut().setCellRenderer(syncListCellRenderer);
        tooltipManager.registerComponent(this.getJListUpdate());
        this.getJListUpdate().setCellRenderer(syncListCellRenderer);
        tooltipManager.registerComponent(this.getJListConflict());
        this.getJListConflict().setCellRenderer(syncListCellRenderer);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.weighty = 0.0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridy = 0;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.fill = 1;
        gridBagConstraints21.weightx = 1.0;
        gridBagConstraints21.weighty = 1.0;
        gridBagConstraints21.gridy = 2;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(368, 122));
        this.add((Component)this.getJPanelContent(), gridBagConstraints21);
        this.add((Component)this.getJPanelHead(), gridBagConstraints4);
    }

    protected Synchronization getSynchronization() {
        return this.sync;
    }

    public void setSynchronization(Synchronization sync) {
        this.sync = sync;
        if (sync != null) {
            int oldMode = this.mode;
            int newMode = sync.getConflictCount() > 0 ? 2 : (sync.getUpdateCount() > 0 ? 1 : 0);
            if (oldMode != newMode) {
                this.setMode(newMode);
            }
            this.refresh();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public synchronized void setMode(int mode) {
        this.mode = mode;
        switch (mode) {
            case 0: {
                this.getJToggleButtonOutgoing().setSelected(true);
                break;
            }
            case 1: {
                this.getJToggleButtonIncoming().setSelected(true);
                break;
            }
            case 2: {
                this.getJToggleButtonConflicts().setSelected(true);
            }
        }
    }

    public synchronized void refresh() {
        this.getJPanelContent().removeAll();
        if (this.sync == null) {
            this.getJPanelContent().validate();
            this.getJPanelContent().repaint();
            return;
        }
        if (this.mode == 0) {
            this.refreshOutgoing();
            return;
        }
        if (this.mode == 1) {
            this.refreshIncoming();
            return;
        }
        if (this.mode == 2) {
            this.refreshConflicts();
            return;
        }
    }

    protected void refreshOutgoing() {
        DefaultListModel model = new DefaultListModel();
        Iterator i = this.sync.getChanges();
        if (i != null) {
            TreeSet sorted = new TreeSet(this.changeComparator);
            while (i.hasNext()) {
                sorted.add(i.next());
            }
            Iterator s = sorted.iterator();
            while (s.hasNext()) {
                model.addElement(s.next());
            }
        }
        this.getJListOut().setModel(model);
        int num = model.getSize();
        if (num > 0) {
            this.getJListOut().setSelectionInterval(0, num - 1);
        }
        this.handleOutSelected();
        this.jLabelInfo.setText("Local changes: " + num);
        this.jLabelInfo.setIcon(this.getJToggleButtonOutgoing().getIcon());
        this.getJPanelContent().add(this.getJPanelOut());
        this.getJPanelContent().validate();
        this.getJPanelContent().repaint();
    }

    protected void refreshIncoming() {
        DefaultListModel model = new DefaultListModel();
        Iterator i = this.sync.getUpdates();
        if (i != null) {
            TreeSet sorted = new TreeSet(this.changeComparator);
            while (i.hasNext()) {
                sorted.add(i.next());
            }
            Iterator s = sorted.iterator();
            while (s.hasNext()) {
                model.addElement(s.next());
            }
        }
        this.getJListUpdate().setModel(model);
        int num = model.getSize();
        if (num > 0) {
            this.getJListUpdate().setSelectionInterval(0, num - 1);
        }
        this.handleIncomingSelected();
        this.jLabelInfo.setText("Incoming updates: " + num);
        this.jLabelInfo.setIcon(this.getJToggleButtonIncoming().getIcon());
        this.getJPanelContent().add(this.getJPanelUpdate());
        this.getJPanelContent().validate();
        this.getJPanelContent().repaint();
    }

    protected void refreshConflicts() {
        DefaultListModel model = new DefaultListModel();
        Iterator i = this.sync.getConflicts();
        if (i != null) {
            TreeSet sorted = new TreeSet(this.changeComparator);
            while (i.hasNext()) {
                sorted.add(i.next());
            }
            Iterator s = sorted.iterator();
            while (s.hasNext()) {
                model.addElement(s.next());
            }
        }
        this.getJListConflict().setModel(model);
        int num = model.getSize();
        if (num > 0) {
            this.getJListConflict().setSelectionInterval(0, num - 1);
        }
        this.getJButton().setEnabled(false);
        this.jLabelInfo.setText("Conflicts: " + num);
        this.jLabelInfo.setIcon(this.getJToggleButtonConflicts().getIcon());
        this.getJPanelContent().add(this.getJPanelConflicts());
        this.getJPanelContent().validate();
        this.getJPanelContent().repaint();
    }

    private int computeChildCount(TreeNode node) {
        int num;
        int rc = num = node.getChildCount();
        for (int c = 0; c < num; ++c) {
            TreeNode child = node.getChildAt(c);
            rc += this.computeChildCount(child);
        }
        return rc;
    }

    private void enumerateChildNodes(TreeNode node, Collection dst) {
        int num = node.getChildCount();
        for (int c = 0; c < num; ++c) {
            TreeNode child = node.getChildAt(c);
            dst.add(child);
            this.enumerateChildNodes(child, dst);
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setOpaque(false);
            this.jPanel.add((Component)this.getJToggleButtonConflicts(), gridBagConstraints3);
            this.jPanel.add((Component)this.getJToggleButtonOutgoing(), gridBagConstraints);
            this.jPanel.add((Component)this.getJToggleButtonIncoming(), gridBagConstraints2);
        }
        return this.jPanel;
    }

    private JPanel getJPanelContent() {
        if (this.jPanelContent == null) {
            GridLayout gridLayout3 = new GridLayout();
            gridLayout3.setRows(1);
            this.jPanelContent = new JPanel();
            this.jPanelContent.setLayout(gridLayout3);
            this.jPanelContent.setOpaque(false);
        }
        return this.jPanelContent;
    }

    private JToggleButton getJToggleButtonConflicts() {
        if (this.jToggleButtonConflicts == null) {
            this.jToggleButtonConflicts = new JToggleButton();
            this.jToggleButtonConflicts.setMargin(new Insets(0, 0, 0, 0));
            this.jToggleButtonConflicts.setToolTipText("Show conflicts..");
            this.jToggleButtonConflicts.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/conflict_synch.gif")));
            this.jToggleButtonConflicts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SynchronizationPanel.this.mode != 2) {
                        SynchronizationPanel.this.setMode(2);
                        SynchronizationPanel.this.refresh();
                    }
                }
            });
        }
        return this.jToggleButtonConflicts;
    }

    private JToggleButton getJToggleButtonOutgoing() {
        if (this.jToggleButtonOutgoing == null) {
            this.jToggleButtonOutgoing = new JToggleButton();
            this.jToggleButtonOutgoing.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/outgo_synch.gif")));
            this.jToggleButtonOutgoing.setToolTipText("Show local changes..");
            this.jToggleButtonOutgoing.setMargin(new Insets(0, 0, 0, 0));
            this.jToggleButtonOutgoing.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SynchronizationPanel.this.mode != 0) {
                        SynchronizationPanel.this.setMode(0);
                        SynchronizationPanel.this.refresh();
                    }
                }
            });
        }
        return this.jToggleButtonOutgoing;
    }

    private JToggleButton getJToggleButtonIncoming() {
        if (this.jToggleButtonIncoming == null) {
            this.jToggleButtonIncoming = new JToggleButton();
            this.jToggleButtonIncoming.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/incom_synch.gif")));
            this.jToggleButtonIncoming.setToolTipText("Show remote changes..");
            this.jToggleButtonIncoming.setMargin(new Insets(0, 0, 0, 0));
            this.jToggleButtonIncoming.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SynchronizationPanel.this.mode != 1) {
                        SynchronizationPanel.this.setMode(1);
                        SynchronizationPanel.this.refresh();
                    }
                }
            });
        }
        return this.jToggleButtonIncoming;
    }

    private JPanel getJPanelHead() {
        if (this.jPanelHead == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 0;
            this.jLabelInfo = new JLabel();
            this.jLabelInfo.setText("Info..");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.weighty = 0.0;
            gridBagConstraints1.fill = 0;
            this.jPanelHead = new JPanel();
            this.jPanelHead.setLayout(new GridBagLayout());
            this.jPanelHead.setOpaque(false);
            this.jPanelHead.add((Component)this.getJPanel(), gridBagConstraints1);
            this.jPanelHead.add((Component)this.jLabelInfo, gridBagConstraints5);
        }
        return this.jPanelHead;
    }

    private JPanel getJPanelOut() {
        if (this.jPanelOut == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.gridx = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 0.0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.gridy = 1;
            this.jPanelOut = new JPanel();
            this.jPanelOut.setLayout(new GridBagLayout());
            this.jPanelOut.setSize(new Dimension(418, 251));
            this.jPanelOut.add((Component)this.getJPanel1(), gridBagConstraints6);
            this.jPanelOut.add((Component)this.getJScrollPaneOut(), gridBagConstraints8);
        }
        return this.jPanelOut;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.anchor = 13;
            gridBagConstraints10.gridy = 1;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.setOpaque(false);
            this.jPanel1.add((Component)this.getJButtonSave(), gridBagConstraints10);
            this.jPanel1.add((Component)this.getJButtonResync(), gridBagConstraints7);
        }
        return this.jPanel1;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public FeatureDescriptorFilter getFeatureDescriptorFilter() {
        return this.featureDescriptorFilter;
    }

    public void setFeatureDescriptorFilter(FeatureDescriptorFilter featureDescriptorFilter) {
        this.featureDescriptorFilter = featureDescriptorFilter;
    }

    public Icon getArrayIcon() {
        return this.arrayIcon;
    }

    public void setArrayIcon(Icon arrayIcon) {
        this.arrayIcon = arrayIcon;
    }

    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    private JButton getJButtonSave() {
        if (this.jButtonSave == null) {
            this.jButtonSave = new JButton();
            this.jButtonSave.setText("Save");
            this.jButtonSave.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonSave.setToolTipText("Save selected objects (recursive)");
            this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/outgo_synch.gif")));
            this.jButtonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SynchronizationPanel.this.actionSave();
                }
            });
        }
        return this.jButtonSave;
    }

    protected void actionSave() {
        Object[] objects = this.getJListOut().getSelectedValues();
        int num = objects.length;
        logger.fine("Number of selected objects: " + num);
        if (num < 1) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            for (int i = 0; i < num; ++i) {
                logger.finer("Object: " + objects[i]);
            }
        }
        int conflicts = 0;
        try {
            int saved = this.syncManager.save(objects, 0, num);
            logger.fine("Number of objects saved: " + saved);
            conflicts = this.sync.getConflictCount();
            if (conflicts > 0) {
                logger.fine("Conflicts: " + conflicts);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.actionResync(true);
    }

    protected void actionUpdate() {
        Object[] objects = this.getJListUpdate().getSelectedValues();
        int num = objects.length;
        logger.fine("Number of selected objects: " + num);
        if (num < 1) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            for (int i = 0; i < num; ++i) {
                logger.finer("Object: " + objects[i]);
            }
        }
        int conflicts = 0;
        try {
            int updated = this.syncManager.refresh(objects, 0, num);
            logger.fine("Number of objects updated: " + updated);
            conflicts = this.sync.getConflictCount();
            if (conflicts > 0) {
                logger.fine("Conflicts: " + conflicts);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.actionResync(true);
    }

    protected void actionResync(boolean autoClose) {
        try {
            ResyncManager manager = this.getResyncManager();
            logger.finer("ResyncManager: " + manager);
            if (manager == null) {
                return;
            }
            Synchronization sync = manager.resynchronize();
            if (autoClose && this.syncView != null && sync.getChangeCount() < 1 && sync.getUpdateCount() < 1 && sync.getConflictCount() < 1) {
                this.syncView.close();
                return;
            }
            this.setSynchronization(sync);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void handleOutSelected() {
        this.getJButtonSave().setEnabled(!this.getJListOut().isSelectionEmpty());
    }

    protected void handleIncomingSelected() {
        this.getJButtonUpdate().setEnabled(!this.getJListUpdate().isSelectionEmpty());
    }

    private JButton getJButtonResync() {
        if (this.jButtonResync == null) {
            this.jButtonResync = new JButton();
            this.jButtonResync.setToolTipText("Resynchronize..");
            this.jButtonResync.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonResync.setText("Refresh");
            this.jButtonResync.setFont(new Font("Dialog", 0, 12));
            this.jButtonResync.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/synchronize.gif")));
            this.jButtonResync.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SynchronizationPanel.this.actionResync(false);
                }
            });
        }
        return this.jButtonResync;
    }

    protected void selectAll(JTree tree) {
        int rows = tree.getRowCount();
        if (rows > 0) {
            tree.setSelectionInterval(0, rows - 1);
        }
    }

    private JPanel getJPanelUpdate() {
        if (this.jPanelUpdate == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.gridx = 0;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.gridy = 1;
            this.jPanelUpdate = new JPanel();
            this.jPanelUpdate.setLayout(new GridBagLayout());
            this.jPanelUpdate.setSize(new Dimension(414, 247));
            this.jPanelUpdate.add((Component)this.getJPanel3(), gridBagConstraints13);
            this.jPanelUpdate.add((Component)this.getJScrollPaneUpdate(), gridBagConstraints14);
        }
        return this.jPanelUpdate;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints12.gridy = 1;
            gridBagConstraints12.gridx = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.insets = new Insets(2, 2, 2, 2);
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.setOpaque(false);
            this.jPanel3.add((Component)this.getJButtonUpdate(), gridBagConstraints11);
            this.jPanel3.add((Component)this.getJButtonRefresh(), gridBagConstraints12);
        }
        return this.jPanel3;
    }

    private JButton getJButtonUpdate() {
        if (this.jButtonUpdate == null) {
            this.jButtonUpdate = new JButton();
            this.jButtonUpdate.setToolTipText("Update selected objects with incoming changes..");
            this.jButtonUpdate.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonUpdate.setText("Update");
            this.jButtonUpdate.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/incom_synch.gif")));
            this.jButtonUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SynchronizationPanel.this.actionUpdate();
                }
            });
        }
        return this.jButtonUpdate;
    }

    private JButton getJButtonRefresh() {
        if (this.jButtonRefresh == null) {
            this.jButtonRefresh = new JButton();
            this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/synchronize.gif")));
            this.jButtonRefresh.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonRefresh.setText("Refresh");
            this.jButtonRefresh.setToolTipText("Resynchronize..");
            this.jButtonRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SynchronizationPanel.this.actionResync(false);
                }
            });
        }
        return this.jButtonRefresh;
    }

    private JScrollPane getJScrollPaneUpdate() {
        if (this.jScrollPaneUpdate == null) {
            this.jScrollPaneUpdate = new JScrollPane();
            this.jScrollPaneUpdate.setOpaque(false);
            this.jScrollPaneUpdate.setViewportView(this.getJListUpdate());
        }
        return this.jScrollPaneUpdate;
    }

    private JPanel getJPanelConflicts() {
        if (this.jPanelConflicts == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.gridx = 0;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 1;
            gridBagConstraints18.gridy = 0;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.weighty = 1.0;
            gridBagConstraints18.gridx = 0;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridy = 1;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.gridx = 0;
            this.jPanelConflicts = new JPanel();
            this.jPanelConflicts.setLayout(new GridBagLayout());
            this.jPanelConflicts.setSize(new Dimension(416, 268));
            this.jPanelConflicts.add((Component)this.getJPanel5(), gridBagConstraints17);
            this.jPanelConflicts.add((Component)this.getJScrollPaneConflict(), gridBagConstraints9);
        }
        return this.jPanelConflicts;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints16.gridy = 1;
            gridBagConstraints16.gridx = 0;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.anchor = 13;
            gridBagConstraints15.gridx = 1;
            gridBagConstraints15.gridy = 1;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.insets = new Insets(2, 2, 2, 2);
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new GridBagLayout());
            this.jPanel5.setOpaque(false);
            this.jPanel5.add((Component)this.getJButton(), gridBagConstraints15);
            this.jPanel5.add((Component)this.getJButtonConflictRefresh(), gridBagConstraints16);
        }
        return this.jPanel5;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setToolTipText("Update selected objects with incoming changes..");
            this.jButton.setMargin(new Insets(2, 4, 2, 4));
            this.jButton.setText("?TODO?");
            this.jButton.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/incom_synch.gif")));
        }
        return this.jButton;
    }

    private JButton getJButtonConflictRefresh() {
        if (this.jButtonConflictRefresh == null) {
            this.jButtonConflictRefresh = new JButton();
            this.jButtonConflictRefresh.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/synchronize.gif")));
            this.jButtonConflictRefresh.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonConflictRefresh.setText("Refresh");
            this.jButtonConflictRefresh.setToolTipText("Resynchronize..");
        }
        return this.jButtonConflictRefresh;
    }

    protected Icon getDefaultIcon(Class type) {
        if (type == null) {
            return this.defaultIcon;
        }
        if (type.isArray()) {
            return this.arrayIcon;
        }
        if (this.beansToolkit != null) {
            return this.beansToolkit.getIcon(type);
        }
        return null;
    }

    private JScrollPane getJScrollPaneOut() {
        if (this.jScrollPaneOut == null) {
            this.jScrollPaneOut = new JScrollPane();
            this.jScrollPaneOut.setViewportView(this.getJListOut());
        }
        return this.jScrollPaneOut;
    }

    private JList getJListOut() {
        if (this.jListOut == null) {
            this.jListOut = new JList();
            this.jListOut.setOpaque(false);
            this.jListOut.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SynchronizationPanel.this.handleOutSelected();
                }
            });
        }
        return this.jListOut;
    }

    protected String getOutgoingTooltip(Object obj) {
        if (obj == null) {
            return null;
        }
        String typeName = obj.getClass().getName();
        try {
            Object id = this.getSyncManager().getObjectId(obj);
            if (id != null) {
                return typeName + "#" + id;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return typeName + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    protected SyncManager getSyncManager() {
        return this.syncManager;
    }

    public void setSyncManager(SyncManager syncManager) {
        this.syncManager = syncManager;
    }

    protected ResyncManager getResyncManager() {
        return this.resyncManager;
    }

    public void setResyncManager(ResyncManager resyncManager) {
        this.resyncManager = resyncManager;
    }

    private JList getJListUpdate() {
        if (this.jListUpdate == null) {
            this.jListUpdate = new JList();
            this.jListUpdate.setOpaque(false);
            this.jListUpdate.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SynchronizationPanel.this.handleIncomingSelected();
                }
            });
        }
        return this.jListUpdate;
    }

    private JScrollPane getJScrollPaneConflict() {
        if (this.jScrollPaneConflict == null) {
            this.jScrollPaneConflict = new JScrollPane();
            this.jScrollPaneConflict.setViewportView(this.getJListConflict());
        }
        return this.jScrollPaneConflict;
    }

    private JList getJListConflict() {
        if (this.jListConflict == null) {
            this.jListConflict = new JList();
            this.jListConflict.setOpaque(false);
            this.jListConflict.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    System.out.println("valueChanged()");
                }
            });
        }
        return this.jListConflict;
    }

    protected SynchronizationView getSyncView() {
        return this.syncView;
    }

    public void setSyncView(SynchronizationView syncView) {
        this.syncView = syncView;
    }

    protected class SyncListCellRenderer
    extends AbstractCellRenderer
    implements ListCellRenderer {
        private static final long serialVersionUID = 6832799008281174379L;
        private JLabel label = new JLabel();
        private WeakReference ref;
        private String tooltip;

        public SyncListCellRenderer() {
            this.setOpaque(false);
            this.setLayout(new GridLayout(1, 1));
            this.add(this.label);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean cellHasFocus) {
            this.setSelected(sel);
            this.setFocus(cellHasFocus);
            String text = null;
            Icon icon = null;
            Class<?> type = null;
            if (value != null) {
                type = value.getClass();
                try {
                    text = value.toString();
                }
                catch (Throwable e) {
                    text = type.getName() + "@" + Integer.toHexString(System.identityHashCode(value)) + " [" + e + "]";
                }
                if (this.ref == null || this.ref.get() != value) {
                    this.ref = new WeakReference<Object>(value);
                    this.tooltip = null;
                }
            } else {
                this.ref = null;
                this.tooltip = null;
            }
            if (text == null) {
                text = "";
            }
            if (icon == null) {
                icon = SynchronizationPanel.this.getDefaultIcon(type);
            }
            this.label.setText(text);
            this.label.setIcon(icon);
            return this;
        }

        public String getToolTipText() {
            return this.getToolTipText(null);
        }

        public String getToolTipText(MouseEvent event) {
            if (this.tooltip != null) {
                return this.tooltip;
            }
            WeakReference r = this.ref;
            if (r == null) {
                return null;
            }
            Object o = r.get();
            if (o == null) {
                return null;
            }
            this.tooltip = SynchronizationPanel.this.getOutgoingTooltip(o);
            return this.tooltip;
        }
    }

    protected class DefaultComparator
    implements Comparator {
        protected DefaultComparator() {
        }

        public int compare(Object a, Object b) {
            int rc;
            Class<?> bClass;
            Class<?> aClass = a.getClass();
            if (aClass != (bClass = b.getClass())) {
                return aClass.getName().compareToIgnoreCase(bClass.getName());
            }
            if (!a.equals(b) && (rc = String.valueOf(a).compareToIgnoreCase(String.valueOf(b))) != 0) {
                return rc;
            }
            return -1;
        }
    }
}

