/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.lock;

import com.spacekiller.util.Tools;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.LockSupport;
import com.spacekiller.util.lock.SyncLockManager;

public abstract class LockManager {
    private static final String LOCK_MANAGER_J15_CLASSNAME = "com.spacekiller.util.lock.j15.J15LockManager";
    private static LockManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LockManager getInstance() {
        if (instance != null) return instance;
        Class<LockManager> clazz = LockManager.class;
        synchronized (LockManager.class) {
            if (instance != null) return instance;
            instance = LockManager.createInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static LockManager createInstance() {
        LockManager lm = LockManager.createInstance(LOCK_MANAGER_J15_CLASSNAME);
        if (lm != null) {
            return lm;
        }
        return new SyncLockManager();
    }

    private static LockManager createInstance(String lockManagerClassName) {
        try {
            Class<?> clazz = Class.forName(lockManagerClassName);
            Object object = Tools.newInstance(clazz);
            LockManager manager = (LockManager)object;
            if (manager.isSupported()) {
                return manager;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public abstract boolean isSupported();

    public abstract LockFactory createLockFactory();

    public abstract LockSupport createLockSupport();

    public abstract LockSupport createLockSupport(boolean var1);
}

