/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.lock;

import com.spacekiller.util.lock.Lock;

public class SyncLock
implements Lock {
    private Thread owner = null;
    private int add = 0;

    @Override
    public synchronized void lock() {
        if (this.owner == null) {
            this.owner = Thread.currentThread();
            return;
        }
        Thread t = Thread.currentThread();
        if (this.owner == t) {
            ++this.add;
            return;
        }
        while (true) {
            try {
                do {
                    this.wait();
                } while (this.owner != null);
                this.owner = t;
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized boolean tryLock() {
        if (this.owner == null) {
            this.owner = Thread.currentThread();
            return true;
        }
        Thread t = Thread.currentThread();
        if (this.owner == t) {
            ++this.add;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean tryLock(long time) throws InterruptedException {
        if (this.owner == null) {
            this.owner = Thread.currentThread();
            return true;
        }
        Thread t = Thread.currentThread();
        if (this.owner == t) {
            ++this.add;
            return true;
        }
        this.wait(time);
        if (this.owner == null) {
            this.owner = t;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void unlock() {
        if (this.owner == Thread.currentThread()) {
            if (this.add > 0) {
                --this.add;
                return;
            }
            this.owner = null;
            this.notify();
            return;
        }
        throw new IllegalMonitorStateException();
    }
}

