/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.Data;
import com.spacekiller.util.beans.DynamicBean;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.beans.PropertySupport;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.beans.SimpleBeanInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDynamicBean
extends PropertySupport
implements DynamicBean,
Externalizable {
    private static final Logger logger = Logger.getLogger(AbstractDynamicBean.class.getName());
    private BeanInfo beanInfo;
    private Map props = new HashMap();

    public AbstractDynamicBean() {
        this.initProperties();
    }

    protected abstract void initProperties();

    protected synchronized void addProperty(String name, Property p) {
        if (p != null && !this.props.containsValue(p)) {
            if (this.props.containsKey(name)) {
                this.removeProperty(name);
            }
            this.props.put(name, p);
            p.addPropertyChangeListener(this.getChangeHandler());
            p.addVetoableChangeListener(this.getChangeHandler());
        }
    }

    protected void finalize() throws Throwable {
        this.removeAllProperties();
    }

    public boolean getBoolean(String key) throws InvocationTargetException, IllegalAccessException {
        return (Boolean)this.getValue(key);
    }

    public byte getByte(String key) throws InvocationTargetException, IllegalAccessException {
        return (Byte)this.getValue(key);
    }

    public char getChar(String key) throws IllegalAccessException, InvocationTargetException {
        return ((Character)this.getValue(key)).charValue();
    }

    public double getDouble(String key) throws InvocationTargetException, IllegalAccessException {
        return (Double)this.getValue(key);
    }

    public float getFloat(String key) throws InvocationTargetException, IllegalAccessException {
        return ((Float)this.getValue(key)).floatValue();
    }

    public int getInt(String key) throws InvocationTargetException, IllegalAccessException {
        return (Integer)this.getValue(key);
    }

    public long getLong(String key) throws InvocationTargetException, IllegalAccessException {
        return (Long)this.getValue(key);
    }

    public Object getObject(String key) throws InvocationTargetException, IllegalAccessException {
        return this.getValue(key);
    }

    @Override
    public Property getProperty(String name) {
        return (Property)this.props.get(name);
    }

    @Override
    public int getPropertyCount() {
        return this.props.size();
    }

    @Override
    public String[] getPropertyNames() {
        Set keys = this.props.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public Property[] getProperties() {
        Collection coll = this.props.values();
        return coll.toArray(new Property[coll.size()]);
    }

    public short getShort(String key) throws InvocationTargetException, IllegalAccessException {
        return (Short)this.getValue(key);
    }

    protected Object getValue(String property) throws InvocationTargetException, IllegalAccessException {
        Property prop = this.getProperty(property);
        if (prop == null) {
            throw new IllegalAccessException("Property not found: " + property);
        }
        return prop.getValue();
    }

    public String[] propertyNames() {
        return this.getPropertyNames();
    }

    public boolean contains(String key) {
        return this.props.containsKey(key);
    }

    protected synchronized void removeAllProperties() {
        Set keys = this.props.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            this.removeProperty((String)i.next());
        }
    }

    protected synchronized void removeProperty(String name) {
        Property p = (Property)this.props.remove(name);
        if (p != null) {
            p.removePropertyChangeListener(this.getChangeHandler());
            p.removeVetoableChangeListener(this.getChangeHandler());
        }
    }

    public void setBoolean(String key, boolean value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toBoolean((boolean)value));
    }

    public void setByte(String key, byte value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toByte((byte)value));
    }

    public void setChar(String key, char value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        this.setValue(key, Data.toCharacter((char)value));
    }

    public void setDouble(String key, double value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toDouble((double)value));
    }

    public void setFloat(String key, float value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toFloat((float)value));
    }

    public void setInt(String key, int value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toInteger((int)value));
    }

    public void setLong(String key, long value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toLong((long)value));
    }

    public void setObject(String key, Object value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, value);
    }

    public void setShort(String key, short value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this.setValue(key, Data.toShort((short)value));
    }

    protected void setValue(String property, Object value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        Property prop = this.getProperty(property);
        if (prop == null) {
            throw new IllegalAccessException("Property not found: " + property);
        }
        prop.setValue(value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = in.readInt();
        for (int c = 0; c < count; ++c) {
            Property p = (Property)in.readObject();
            this.addProperty(p.getName(), p);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Set keys = this.props.keySet();
        int count = keys.size();
        out.writeInt(count);
        Iterator i = keys.iterator();
        for (int c = 0; c < count; ++c) {
            out.writeObject(this.props.get(i.next()));
        }
    }

    @Override
    public BeanInfo getBeanInfo() {
        if (this.beanInfo == null) {
            this.beanInfo = new DynamicBeanInfo();
        }
        return this.beanInfo;
    }

    public void setBeanDescriptor(BeanDescriptor descr) {
        DynamicBeanInfo info = (DynamicBeanInfo)this.getBeanInfo();
        info.setBeanDescriptor(descr);
    }

    protected class DynamicBeanInfo
    extends SimpleBeanInfo {
        private BeanDescriptor beanDescriptor;

        @Override
        public PropertyDescriptor[] getPropertyDescriptors() {
            try {
                String[] names = AbstractDynamicBean.this.getPropertyNames();
                int num = names.length;
                PropertyDescriptor[] descr = new PropertyDescriptor[num];
                for (int c = 0; c < num; ++c) {
                    Property prop = AbstractDynamicBean.this.getProperty(names[c]);
                    descr[c] = prop == null ? null : prop.getDescriptor();
                }
                return descr;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }

        @Override
        public BeanDescriptor getBeanDescriptor() {
            return this.beanDescriptor;
        }

        public void setBeanDescriptor(BeanDescriptor beanDescriptor) {
            this.beanDescriptor = beanDescriptor;
        }
    }
}

