/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Platform;
import com.spacekiller.util.beans.Property;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BeanProperty
implements Property,
Externalizable {
    private static final long serialVersionUID = 89789347093309L;
    private Object bean;
    private PropertyDescriptor descriptor;

    public BeanProperty(Object bean, PropertyDescriptor descriptor) {
        this.setBean(bean);
        this.setDescriptor(descriptor);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        BeanProperty.installPropertyChangeListener(this.bean, pcl);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener vcl) {
        BeanProperty.installVetoableChangeListener(this.bean, vcl);
    }

    protected Object getBean() {
        return this.bean;
    }

    @Override
    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return BeanProperty.getValue(this.bean, this.descriptor);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        BeanProperty.uninstallPropertyChangeListener(this.bean, pcl);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener vcl) {
        BeanProperty.uninstallVetoableChangeListener(this.bean, vcl);
    }

    protected void setBean(Object newBean) {
        this.bean = newBean;
    }

    protected void setDescriptor(PropertyDescriptor newDescriptor) {
        this.descriptor = newDescriptor;
    }

    @Override
    public void setValue(Object value) throws IllegalAccessException, InvocationTargetException {
        BeanProperty.setValue(this.bean, this.descriptor, value);
    }

    public static void setValue(Object bean, PropertyDescriptor descriptor, Object value) throws IllegalAccessException, InvocationTargetException {
        Method writer = descriptor.getWriteMethod();
        if (writer == null) {
            throw new IllegalAccessException("cannot write to read-only property: " + descriptor.getName());
        }
        writer.invoke(bean, value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.setBean(in.readObject());
            this.setDescriptor((PropertyDescriptor)in.readObject());
            this.setValue(in.readObject());
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException("" + e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.writeObject(this.bean);
            out.writeObject(this.descriptor);
            out.writeObject(this.getValue());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException("" + e);
        }
    }

    public static Object getValue(Object bean, PropertyDescriptor descriptor) throws IllegalAccessException, InvocationTargetException {
        Method reader = descriptor.getReadMethod();
        return reader.invoke(bean, new Object[0]);
    }

    public static boolean installPropertyChangeListener(Object bean, PropertyChangeListener listener) {
        try {
            Method meth = bean.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            if (meth != null) {
                meth.invoke(bean, listener);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean installVetoableChangeListener(Object bean, VetoableChangeListener listener) {
        try {
            Method meth = bean.getClass().getMethod("addVetoableChangeListener", VetoableChangeListener.class);
            if (meth != null) {
                meth.invoke(bean, listener);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean uninstallPropertyChangeListener(Object bean, PropertyChangeListener listener) {
        try {
            Method meth = bean.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            if (meth != null) {
                meth.invoke(bean, listener);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean uninstallVetoableChangeListener(Object bean, VetoableChangeListener listener) {
        try {
            Method meth = bean.getClass().getMethod("removeVetoableChangeListener", VetoableChangeListener.class);
            if (meth != null) {
                meth.invoke(bean, listener);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static BeanProperty getBeanProperty(Object bean, String propertyName) throws InstantiationException, IntrospectionException, IllegalAccessException {
        BeansToolkit btk = Platform.getInstance().getBeansToolkit();
        PropertyDescriptor descr = btk.getPropertyDescriptor(bean.getClass(), propertyName);
        return new BeanProperty(bean, descr);
    }
}

