/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.IconProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorIconProvider
implements IconProvider {
    private static final Class[] BEAN_TYPES = new Class[]{Color.class};
    private BeansToolkit beansToolkit;

    public ColorIconProvider(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    @Override
    public Class[] getBeanTypes() {
        return BEAN_TYPES;
    }

    @Override
    public Icon getIcon(Object bean, int iconKind) {
        if (bean != null && bean instanceof Color) {
            Dimension size = this.beansToolkit.getIconKindSize(iconKind);
            Color color = (Color)bean;
            return new ColorIcon(color, size.width, size.height);
        }
        return null;
    }

    protected static class ColorIcon
    implements Icon {
        private int iconWidth;
        private int iconHeight;
        private Color color;

        public ColorIcon(Color c, int w, int h) {
            this.color = c;
            this.iconWidth = w;
            this.iconHeight = h;
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth;
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, this.iconWidth, this.iconHeight);
        }
    }
}

