/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.EventListenerList;
import com.spacekiller.util.FileLink;
import com.spacekiller.util.beans.BeanTransferable;
import com.spacekiller.util.beans.ClipSource;
import com.spacekiller.util.beans.ClipboardListener;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.SerializedTransferable;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Logger;

public class DefaultClipboardManager
implements ClipboardManager {
    private Clipboard clipboard;
    private EventListenerList listeners;
    private Collection beans;
    private long beanListId;
    private ClipSource beanListSource;
    private Random random = new Random();
    private static final Logger logger = Logger.getLogger(DefaultClipboardManager.class.getName());

    public DefaultClipboardManager() {
        this.listeners = new EventListenerList();
        this.initClipboardManager();
    }

    protected void initClipboardManager() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.setClipboard(cb);
    }

    protected Clipboard getClipboard() {
        return this.clipboard;
    }

    protected void setClipboard(Clipboard newClipboard) {
        this.clipboard = newClipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        if (this.clipboard == null) {
            return;
        }
        try {
            this.clipboard.setContents(contents, owner);
        }
        finally {
            this.fireClipboardChanged();
        }
    }

    @Override
    public void addClipboardListener(ClipboardListener l) {
        if (l == null) {
            return;
        }
        this.listeners.add(ClipboardListener.class, (EventListener)l);
    }

    @Override
    public void removeClipboardListener(ClipboardListener l) {
        this.listeners.remove(ClipboardListener.class, (EventListener)l);
    }

    protected synchronized void fireClipboardChanged() {
        Object[] list = this.listeners.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ClipboardListener)list[i]).clipboardChanged(this);
        }
    }

    @Override
    public Transferable getTransferable() {
        return this.clipboard.getContents(this);
    }

    @Override
    public DataFlavor[] getAvailableDataFlavors() {
        Transferable trans = this.getTransferable();
        if (trans == null) {
            return null;
        }
        return trans.getTransferDataFlavors();
    }

    @Override
    public boolean isDataFlavorAvailable(DataFlavor flavor) {
        Transferable trans = this.getTransferable();
        if (trans == null) {
            return false;
        }
        return trans.isDataFlavorSupported(flavor);
    }

    @Override
    public Object getData(DataFlavor flavor) throws Exception {
        Transferable trans = this.getTransferable();
        if (trans == null) {
            return null;
        }
        return trans.getTransferData(flavor);
    }

    @Override
    public void setContents(Collection beans, ClipboardOwner owner, ClipSource source) {
        if (beans == null) {
            return;
        }
        if (beans.isEmpty()) {
            return;
        }
        ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>();
        boolean jvmInternalObjectFlavorEnabled = true;
        boolean fileFlavorEnabled = true;
        for (Object bean : beans) {
            if (!fileFlavorEnabled || bean instanceof File || bean instanceof FileLink) continue;
            fileFlavorEnabled = false;
        }
        if (fileFlavorEnabled) {
            jvmInternalObjectFlavorEnabled = false;
            flavors.add(DataFlavor.javaFileListFlavor);
        }
        if (jvmInternalObjectFlavorEnabled) {
            try {
                long id = this.random.nextLong();
                UseLocalBeanList dummy = new UseLocalBeanList(id);
                SerializedTransferable serTrans = new SerializedTransferable(dummy);
                ArrayList newBeanList = new ArrayList(beans.size());
                newBeanList.addAll(beans);
                this.beans = newBeanList;
                this.beanListId = id;
                this.beanListSource = source;
                this.setContents(serTrans, owner);
            }
            catch (Exception e) {
                logger.fine("" + e);
            }
            return;
        }
        this.beans = null;
        this.beanListId = 0L;
        this.beanListSource = null;
        if (flavors.isEmpty()) {
            return;
        }
        DataFlavor[] flavorArray = new DataFlavor[flavors.size()];
        flavorArray = flavors.toArray(flavorArray);
        BeanTransferable beanTrans = new BeanTransferable(beans, flavorArray);
        this.setContents(beanTrans, owner);
    }

    @Override
    public Collection getObjects() throws Exception {
        DataFlavor[] flavors = this.getAvailableDataFlavors();
        DataFlavor flavor = null;
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor f = flavors[i];
            if (f == null) continue;
            if (f.isFlavorJavaFileListType()) {
                flavor = f;
                continue;
            }
            if (f.isFlavorSerializedObjectType()) {
                flavor = f;
                continue;
            }
            if (f.isFlavorRemoteObjectType()) {
                flavor = f;
                continue;
            }
            if (f.isFlavorTextType()) {
                Class<?> clazz2;
                Class<?> clazz;
                if (flavor != null && (!flavor.isFlavorTextType() || (clazz = f.getRepresentationClass()) != String.class && (clazz2 = flavor.getRepresentationClass()) == String.class)) continue;
                flavor = f;
                continue;
            }
            if (f == DataFlavor.imageFlavor) {
                flavor = f;
                continue;
            }
            logger.fine("DEBUG: unsupported data flavor: " + f);
            if (flavor != null) continue;
            flavor = f;
        }
        if (flavor == null) {
            return null;
        }
        Object data = this.getData(flavor);
        if (data == null) {
            return null;
        }
        if (data instanceof UseLocalBeanList) {
            UseLocalBeanList ulbl = (UseLocalBeanList)data;
            long id = ulbl.getId();
            if (id != this.beanListId) {
                return null;
            }
            if (this.beans == null) {
                return null;
            }
            ArrayList list = new ArrayList(this.beans.size());
            list.addAll(this.beans);
            return list;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        list.add(data);
        return list;
    }

    @Override
    public void objectTransferred(Object object, int action) {
        ClipSource cs = this.beanListSource;
        if (cs == null) {
            return;
        }
        cs.objectTransferred(object, action);
    }

    @Override
    public int getClipAction() {
        ClipSource cs = this.beanListSource;
        if (cs != null) {
            return cs.getClipAction();
        }
        return 2;
    }

    @Override
    public boolean isClipActionSupported(int action) {
        ClipSource cs = this.beanListSource;
        if (cs != null) {
            return cs.isClipActionSupported(action);
        }
        return action == 2;
    }

    protected static class UseLocalBeanList
    implements Serializable {
        private static final long serialVersionUID = 237492370492890L;
        private long id;

        public UseLocalBeanList(long id) {
            this.setId(id);
        }

        public long getId() {
            return this.id;
        }

        private void setId(long id) {
            this.id = id;
        }
    }
}

