/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.FileLink;
import com.spacekiller.util.beans.BeanDropManager;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanTransferable;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultDragSourceHandler
extends DragSourceAdapter {
    private BeanDropSupport beanDropSupport;
    private Collection beans = null;
    private static final Logger logger = Logger.getLogger(DefaultDragSourceHandler.class.getName());

    public DefaultDragSourceHandler() {
    }

    public DefaultDragSourceHandler(BeanDropSupport beanDropSupport) {
        this();
        this.setBeanDropSupport(beanDropSupport);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.beans = null;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        this.adjustCursor(dsde);
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        DragSourceContext context = dse.getDragSourceContext();
        if (context != null) {
            context.setCursor(null);
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        this.adjustCursor(dsde);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        this.adjustCursor(dsde);
    }

    protected void setBeans(Collection beans) {
        this.beans = beans;
    }

    protected void adjustCursor(DragSourceDragEvent dsde) {
        int action = dsde.getUserAction();
        int targetActions = dsde.getTargetActions();
        DragSourceContext context = dsde.getDragSourceContext();
        if (context == null) {
            return;
        }
        BeanDropSupport bds = this.getBeanDropSupport();
        if (bds != null && this.beans != null) {
            Cursor cursor = bds.getCursor(this.beans, action, targetActions);
            context.setCursor(cursor);
            return;
        }
        context.setCursor(null);
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    public void startDrag(DragGestureEvent dge, List beans) {
        int action = dge.getDragAction();
        if (beans.isEmpty()) {
            return;
        }
        ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>();
        boolean jvmInternalObjectFlavorEnabled = true;
        boolean fileFlavorEnabled = true;
        int beanCount = beans.size();
        for (int c = 0; c < beanCount; ++c) {
            Object bean = beans.get(c);
            if (!fileFlavorEnabled || bean instanceof File || bean instanceof FileLink) continue;
            fileFlavorEnabled = false;
        }
        if (jvmInternalObjectFlavorEnabled) {
            try {
                DataFlavor flav = BeanDropManager.getJavaJVMLocalObjectFlavor();
                flavors.add(flav);
            }
            catch (Exception e) {
                logger.fine("" + e);
            }
        }
        if (fileFlavorEnabled) {
            flavors.add(DataFlavor.javaFileListFlavor);
        }
        if (flavors.isEmpty()) {
            logger.fine("No flavors for draging: beans=" + beans.size());
            return;
        }
        DataFlavor[] flavorArray = new DataFlavor[flavors.size()];
        flavorArray = flavors.toArray(flavorArray);
        Cursor cursor = null;
        BeanDropSupport bds = this.getBeanDropSupport();
        if (bds != null) {
            cursor = bds.getCursor(beans, action, action);
        }
        try {
            BeanTransferable trans = new BeanTransferable(beans, flavorArray);
            dge.startDrag(cursor, trans);
            this.setBeans(beans);
        }
        catch (Exception e) {
            logger.fine("Drag failed:");
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

