/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.beans.AbstractProperty;
import com.spacekiller.util.beans.DynamicPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;

public class DefaultProperty
extends AbstractProperty {
    private static final long serialVersionUID = 7897897445643213L;
    private boolean readable = false;
    private boolean writable = false;
    private boolean nullable = false;

    protected DefaultProperty(PropertyDescriptor descriptor) {
        super(descriptor);
    }

    public DefaultProperty(PropertyDescriptor descriptor, Object value, boolean readable, boolean writable, boolean nullable) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        this(descriptor);
        super.setValue(value);
        this.setReadable(readable);
        this.setWritable(writable);
        this.setNullable(nullable);
    }

    public DefaultProperty(String name, Class type, Object value, boolean readable, boolean writable, boolean nullable) throws InvocationTargetException, IllegalAccessException, PropertyVetoException, IntrospectionException {
        this(new DynamicPropertyDescriptor(name, type), value, readable, writable, nullable);
    }

    @Override
    public Object getValue() throws InvocationTargetException, IllegalAccessException {
        if (!this.readable) {
            throw new IllegalAccessException("Property is not readable: " + this.getName());
        }
        return super.getValue();
    }

    protected boolean isNullable() {
        return this.nullable;
    }

    protected boolean isReadable() {
        return this.readable;
    }

    protected boolean isWritable() {
        return this.writable;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.setReadable(in.readBoolean());
        this.setWritable(in.readBoolean());
        this.setNullable(in.readBoolean());
    }

    protected void setNullable(boolean newNullable) {
        this.nullable = newNullable;
    }

    protected void setReadable(boolean newReadable) {
        this.readable = newReadable;
    }

    @Override
    public void setValue(Object value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        if (!this.writable) {
            throw new IllegalAccessException("Property is not writable: " + this.getName());
        }
        if (value == null) {
            if (!this.nullable) {
                throw new IllegalAccessException("Property does not support null-value: " + this.getName());
            }
        } else {
            Class<?> propType = this.getDescriptor().getPropertyType();
            if (!DefaultProperty.isCompatible(value, propType)) {
                throw new ClassCastException(value.getClass().getName() + " incompatible with " + propType);
            }
        }
        super.setValue(value);
    }

    public static boolean isCompatible(Object value, Class type) {
        if (type.isPrimitive()) {
            Class<?> c = value.getClass();
            if (type == Boolean.TYPE) {
                return c == Boolean.class;
            }
            if (type == Byte.TYPE) {
                return c == Byte.class;
            }
            if (type == Character.TYPE) {
                return c == Character.class;
            }
            if (type == Short.TYPE) {
                return c == Short.class;
            }
            if (type == Integer.TYPE) {
                return c == Integer.class;
            }
            if (type == Long.TYPE) {
                return c == Long.class;
            }
            if (type == Float.TYPE) {
                return c == Float.class;
            }
            if (type == Double.TYPE) {
                return c == Double.class;
            }
        }
        return type.isInstance(value);
    }

    protected void setWritable(boolean newWritable) {
        this.writable = newWritable;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.readable);
        out.writeBoolean(this.writable);
        out.writeBoolean(this.nullable);
    }
}

