/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.EventListenerList;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.beans.SelectionEvent;
import com.spacekiller.util.beans.SelectionListener;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.tree.TreePath;

public class DelegatedSelection
implements Selection {
    private Selection selection;
    private SelectionHandler selectionHandler = new SelectionHandler();
    private EventListenerList selectionListenerList;

    @Override
    public int copySelectedObjects() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.copySelectedObjects();
    }

    @Override
    public int cutSelectedObjects() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.cutSelectedObjects();
    }

    @Override
    public Class getSelectedClassAt(int i) {
        return this.selection.getSelectedClassAt(i);
    }

    @Override
    public int getSelectedClassCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getSelectedClassCount();
    }

    @Override
    public void getSelectedClasses(Collection dst) {
        if (this.selection == null) {
            return;
        }
        this.selection.getSelectedClasses(dst);
    }

    @Override
    public Object getSelectedObjectAt(int i) {
        return this.selection.getSelectedObjectAt(i);
    }

    @Override
    public int getSelectedObjectCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getSelectedObjectCount();
    }

    @Override
    public void getSelectedObjects(Collection dst) {
        if (this.selection == null) {
            return;
        }
        this.selection.getSelectedObjects(dst);
    }

    @Override
    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getSelectionCount();
    }

    @Override
    public TreePath getSelectionPathAt(int i) {
        return this.selection.getSelectionPathAt(i);
    }

    @Override
    public Object getSource() {
        if (this.selection == null) {
            return null;
        }
        return this.selection.getSource();
    }

    @Override
    public boolean isPasteSupported() {
        if (this.selection == null) {
            return false;
        }
        return this.selection.isPasteSupported();
    }

    @Override
    public boolean isSelectedClass(Class type) {
        if (this.selection == null) {
            return false;
        }
        return this.selection.isSelectedClass(type);
    }

    @Override
    public boolean isSelectedObject(Object o) {
        if (this.selection == null) {
            return false;
        }
        return this.selection.isSelectedObject(o);
    }

    @Override
    public boolean isSelectionEmpty() {
        if (this.selection == null) {
            return true;
        }
        return this.selection.isSelectionEmpty();
    }

    @Override
    public int pasteObjects() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.pasteObjects();
    }

    @Override
    public int removeSelectedObjects() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.removeSelectedObjects();
    }

    public Selection getSelection() {
        return this.selection;
    }

    public synchronized void setSelection(Selection sel) {
        if (this.selection == sel) {
            return;
        }
        if (this.selection != null) {
            this.selection.removeSelectionListener(this.selectionHandler);
            this.fireSelectionChanged(-1, this.selection);
        }
        this.selection = sel;
        if (this.selection != null) {
            this.selection.addSelectionListener(this.selectionHandler);
            this.fireSelectionChanged(1, this.selection);
        }
    }

    private void fireSelectionChanged(int type, Selection sel) {
        int n = sel.getSelectedObjectCount();
        Object[] objects = new Object[n];
        int[] indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            objects[i] = sel.getSelectedObjectAt(i);
            indexes[i] = i;
        }
        n = sel.getSelectedClassCount();
        Class[] types = new Class[n];
        for (int i = 0; i < n; ++i) {
            types[i] = sel.getSelectedClassAt(i);
        }
        SelectionEvent ev = new SelectionEvent(type, objects, indexes, types);
        this.fireSelectionChanged(ev);
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        this.getSelectionListenerList().add(SelectionListener.class, (EventListener)l);
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        this.getSelectionListenerList().remove(SelectionListener.class, (EventListener)l);
    }

    protected EventListenerList getSelectionListenerList() {
        if (this.selectionListenerList == null) {
            this.selectionListenerList = new EventListenerList();
        }
        return this.selectionListenerList;
    }

    protected synchronized void fireSelectionChanged(SelectionEvent ev) {
        Object[] l = this.getSelectionListenerList().getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != SelectionListener.class) continue;
            ((SelectionListener)l[i + 1]).selectionChanged(ev);
        }
    }

    protected class SelectionHandler
    implements SelectionListener {
        protected SelectionHandler() {
        }

        @Override
        public void selectionChanged(SelectionEvent ev) {
            DelegatedSelection.this.fireSelectionChanged(ev);
        }
    }
}

