/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;

public abstract class DynamicBeanContext
implements BeanContextServices,
Serializable {
    private static final long serialVersionUID = -3326049155019697099L;
    private BeanContext beanContext;
    protected transient boolean childrenLoaded = false;
    protected transient List children;
    protected transient Map services;
    protected transient PropertyChangeSupport pcSupport;
    protected transient VetoableChangeSupport vcSupport;
    protected transient List bcmListeners;
    protected transient List bcsListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object targetChild) {
        if (targetChild == null) {
            throw new IllegalArgumentException();
        }
        this.refreshDynamicChildrenInternal();
        if (this.children.contains(targetChild)) {
            return false;
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.children.contains(targetChild)) {
                return false;
            }
            if (targetChild instanceof BeanContextChild) {
                try {
                    ((BeanContextChild)targetChild).setBeanContext(this);
                }
                catch (PropertyVetoException e) {
                    return false;
                }
            }
            this.children.add(targetChild);
            this.fireChildrenAdded(new BeanContextMembershipEvent((BeanContext)this, new Object[]{targetChild}));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean add(Object targetChild, boolean fireEvent) {
        if (targetChild == null) {
            throw new IllegalArgumentException();
        }
        this.refreshDynamicChildrenInternal();
        if (this.children.contains(targetChild)) {
            return false;
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.children.contains(targetChild)) {
                return false;
            }
            if (targetChild instanceof BeanContextChild) {
                try {
                    ((BeanContextChild)targetChild).setBeanContext(this);
                }
                catch (PropertyVetoException e) {
                    return false;
                }
            }
            this.children.add(targetChild);
            if (fireEvent) {
                this.fireChildrenAdded(new BeanContextMembershipEvent((BeanContext)this, new Object[]{targetChild}));
            }
        }
        return true;
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        if (bcml == null) {
            throw new NullPointerException("listener");
        }
        if (this.bcmListeners == null) {
            this.bcmListeners = new ArrayList(0);
        }
        List list = this.bcmListeners;
        synchronized (list) {
            if (this.bcmListeners.contains(bcml)) {
                return;
            }
            this.bcmListeners.add(bcml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBeanContextServicesListener(BeanContextServicesListener bcsl) {
        if (bcsl == null) {
            throw new NullPointerException("bcsl");
        }
        if (this.bcsListeners == null) {
            this.bcsListeners = new ArrayList(0);
        }
        List list = this.bcsListeners;
        synchronized (list) {
            if (this.bcsListeners.contains(bcsl)) {
                return;
            }
            this.bcsListeners.add(bcsl);
        }
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        if (this.pcSupport == null) {
            this.pcSupport = new PropertyChangeSupport(this);
        }
        this.pcSupport.addPropertyChangeListener(name, pcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addService(Class serviceClass, BeanContextServiceProvider bcsp) {
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        if (bcsp == null) {
            throw new NullPointerException("bcsp");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.services.containsKey(serviceClass)) {
                return false;
            }
            this.services.put(serviceClass, bcsp);
            BeanContextServiceAvailableEvent bcssae = new BeanContextServiceAvailableEvent(this, serviceClass);
            this.fireServiceAdded(bcssae);
            List list = this.children;
            synchronized (list) {
                for (Object c : this.children) {
                    if (!(c instanceof BeanContextServices)) continue;
                    ((BeanContextServicesListener)c).serviceAvailable(bcssae);
                }
            }
            return true;
        }
    }

    @Override
    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        if (this.vcSupport == null) {
            this.vcSupport = new VetoableChangeSupport(this);
        }
        this.vcSupport.addVetoableChangeListener(name, vcl);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        this.refreshDynamicChildrenInternal();
        return this.children.contains(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        this.refreshDynamicChildrenInternal();
        List list = this.children;
        synchronized (list) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                if (this.contains(i.next())) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChildrenAdded(BeanContextMembershipEvent bcme) {
        if (this.bcmListeners != null) {
            Object[] copy;
            List list = this.bcmListeners;
            synchronized (list) {
                copy = this.bcmListeners.toArray();
            }
            for (int i = 0; i < copy.length; ++i) {
                ((BeanContextMembershipListener)copy[i]).childrenAdded(bcme);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChildrenRemoved(BeanContextMembershipEvent bcme) {
        if (this.bcmListeners != null) {
            Object[] copy;
            List list = this.bcmListeners;
            synchronized (list) {
                copy = this.bcmListeners.toArray();
            }
            for (int i = 0; i < copy.length; ++i) {
                ((BeanContextMembershipListener)copy[i]).childrenRemoved(bcme);
            }
        }
    }

    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.pcSupport != null) {
            this.pcSupport.firePropertyChange(name, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceAdded(BeanContextServiceAvailableEvent bcssae) {
        Object[] copy;
        if (this.bcsListeners == null) {
            return;
        }
        List list = this.bcsListeners;
        synchronized (list) {
            copy = this.bcsListeners.toArray();
        }
        for (int i = 0; i < copy.length; ++i) {
            ((BeanContextServicesListener)copy[i]).serviceAvailable(bcssae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceRevoked(BeanContextServiceRevokedEvent bcsre) {
        Object[] copy;
        if (this.bcsListeners == null) {
            return;
        }
        List list = this.bcsListeners;
        synchronized (list) {
            copy = this.bcsListeners.toArray();
        }
        for (int i = 0; i < copy.length; ++i) {
            ((BeanContextServiceRevokedListener)copy[i]).serviceRevoked(bcsre);
        }
    }

    public void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this.vcSupport != null) {
            this.vcSupport.fireVetoableChange(name, oldValue, newValue);
        }
    }

    @Override
    public synchronized BeanContext getBeanContext() {
        return this.beanContext;
    }

    public Iterator getCurrentServiceClasses() {
        return null;
    }

    public Iterator getCurrentServiceSelectors(Class serviceClass) {
        return null;
    }

    @Override
    public URL getResource(String name, BeanContextChild bcc) throws IllegalArgumentException {
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name, BeanContextChild bcc) throws IllegalArgumentException {
        return null;
    }

    public Object getService(BeanContextChild child, Object requestor, Class serviceClass, Object serviceSelector, BeanContextServiceRevokedListener bcsrl) throws TooManyListenersException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasService(Class serviceClass) {
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.services.containsKey(serviceClass)) {
                return true;
            }
            BeanContextServices bcs = null;
            try {
                bcs = (BeanContextServices)this.getBeanContext();
            }
            catch (ClassCastException cce) {
                return false;
            }
            return bcs == null ? false : bcs.hasService(serviceClass);
        }
    }

    @Override
    public Object instantiateChild(String beanName) throws IOException, ClassNotFoundException {
        this.refreshDynamicChildrenInternal();
        return Beans.instantiate(this.getClass().getClassLoader(), beanName, this);
    }

    protected boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    protected abstract boolean isDynamicEmpty();

    @Override
    public boolean isEmpty() {
        if (this.isChildrenLoaded()) {
            return this.children.isEmpty();
        }
        return this.isDynamicEmpty();
    }

    @Override
    public Iterator iterator() {
        this.refreshDynamicChildrenInternal();
        return this.children.iterator();
    }

    @Override
    public boolean needsGui() {
        return false;
    }

    protected abstract void refreshDynamicChildren();

    private synchronized void refreshDynamicChildrenInternal() {
        if (!this.isChildrenLoaded()) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.setChildrenLoaded(true);
            this.refreshDynamicChildren();
        }
    }

    @Override
    public void releaseService(BeanContextChild child, Object requestor, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object targetChild) {
        if (targetChild == null) {
            throw new IllegalArgumentException();
        }
        this.refreshDynamicChildrenInternal();
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (!this.children.contains(targetChild)) {
                return false;
            }
            if (targetChild instanceof BeanContextChild) {
                try {
                    ((BeanContextChild)targetChild).setBeanContext(null);
                }
                catch (PropertyVetoException e) {
                    return false;
                }
            }
            this.children.remove(targetChild);
            this.fireChildrenRemoved(new BeanContextMembershipEvent((BeanContext)this, new Object[]{targetChild}));
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        if (bcml == null) {
            throw new NullPointerException("listener");
        }
        if (this.bcmListeners == null) {
            return;
        }
        List list = this.bcmListeners;
        synchronized (list) {
            if (!this.bcmListeners.contains(bcml)) {
                return;
            }
            this.bcmListeners.remove(bcml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanContextServicesListener(BeanContextServicesListener bcsl) {
        if (bcsl == null) {
            throw new NullPointerException("bcsl");
        }
        if (this.bcsListeners == null) {
            return;
        }
        List list = this.bcsListeners;
        synchronized (list) {
            if (!this.bcsListeners.contains(bcsl)) {
                return;
            }
            this.bcsListeners.remove(bcsl);
        }
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        if (this.pcSupport != null) {
            this.pcSupport.removePropertyChangeListener(name, pcl);
        }
    }

    @Override
    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        if (this.vcSupport != null) {
            this.vcSupport.removeVetoableChangeListener(name, vcl);
        }
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void revokeService(Class serviceClass, BeanContextServiceProvider bcsp, boolean revokeCurrentServicesNow) {
    }

    @Override
    public void serviceAvailable(BeanContextServiceAvailableEvent bcsae) {
    }

    @Override
    public void serviceRevoked(BeanContextServiceRevokedEvent bcsre) {
    }

    @Override
    public void setBeanContext(BeanContext bc) throws PropertyVetoException {
        this.beanContext = bc;
    }

    protected void setChildrenLoaded(boolean newChildrenLoaded) {
        this.childrenLoaded = newChildrenLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List list = this.children;
        synchronized (list) {
            this.refreshDynamicChildrenInternal();
            return this.children.size();
        }
    }

    @Override
    public Object[] toArray() {
        this.refreshDynamicChildrenInternal();
        return this.children.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.refreshDynamicChildrenInternal();
        return this.children.toArray(a);
    }

    public void refresh() {
        this.refreshDynamicChildren();
    }
}

