/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.FileContext;
import com.spacekiller.util.FileManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.DynamicBeanContext;
import com.spacekiller.util.beans.FileLeafNode;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;

public class FileDirNode
extends DynamicBeanContext
implements FileContext,
Serializable {
    private static final long serialVersionUID = 78978646131053406L;
    private static final Logger logger = Logger.getLogger(FileDirNode.class.getName());
    private File file;
    private transient boolean unloadedLeaf = true;
    private transient boolean unloadedLeafSet = false;

    public FileDirNode(File file) {
        this.setFile(file);
    }

    protected void enumerateChildContexts(Collection dstChildren, boolean onlyCheckLeaf) {
        File[] files;
        File dir = this.getFile();
        if (dir != null && dir.exists() && dir.isDirectory() && (files = this.listFiles(dir)) != null) {
            if (onlyCheckLeaf) {
                if (files.length > 0) {
                    dstChildren.add(null);
                }
            } else {
                int count = files.length;
                for (int c = 0; c < count; ++c) {
                    dstChildren.add(this.createFileContext(files[c]));
                }
            }
        }
    }

    protected File[] listFiles(File dir) {
        return dir.listFiles();
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.file == null ? null : this.file.getPath();
    }

    @Override
    protected boolean isDynamicEmpty() {
        if (!this.unloadedLeafSet) {
            Vector v = new Vector();
            this.enumerateChildContexts(v, true);
            this.unloadedLeaf = v.isEmpty();
            this.unloadedLeafSet = true;
        }
        return this.unloadedLeaf;
    }

    @Override
    protected synchronized void refreshDynamicChildren() {
        Vector v = new Vector();
        this.enumerateChildContexts(v, false);
        Iterator i = v.iterator();
        while (i.hasNext()) {
            this.add((FileContext)i.next(), false);
        }
    }

    protected void setFile(File newFile) {
        this.file = newFile;
    }

    public FileContext getChild(String name) {
        for (FileContext ch : this) {
            if (!name.equals(ch.getName())) continue;
            return ch;
        }
        return null;
    }

    public FileContext getChild(File f) {
        String thisPath;
        if (f == null || this.file == null) {
            return null;
        }
        String fPath = f.getPath().replace(File.separatorChar, '/');
        if (!fPath.startsWith(thisPath = this.file.getPath().replace(File.separatorChar, '/'))) {
            return null;
        }
        String relPath = fPath.substring(thisPath.length());
        int from = 0;
        if (!thisPath.endsWith("/")) {
            if (!relPath.startsWith("/")) {
                return null;
            }
            from = 1;
        }
        FileDirNode ctx = this;
        int len = relPath.length();
        while (from < len) {
            String n;
            int i = relPath.indexOf("/", from);
            if (i < 0) {
                n = relPath.substring(from);
                from = len;
            } else {
                n = relPath.substring(from, i);
                from = i + 1;
            }
            if ((ctx = ctx.getChild(n)) != null) continue;
            return null;
        }
        return ctx;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean avoidingGui() {
        return false;
    }

    @Override
    public void dontUseGui() {
    }

    @Override
    public void okToUseGui() {
    }

    @Override
    public boolean isDesignTime() {
        return false;
    }

    @Override
    public void setDesignTime(boolean designTime) {
    }

    public String getName() {
        return this.file.getName();
    }

    protected FileContext createFileContext(File f) {
        if (f.exists() && f.isFile()) {
            return new FileLeafNode(f);
        }
        return new FileDirNode(f);
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long length() {
        return this.file.length();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public void directoryInserted(String path) {
        this.fileInserted(path);
    }

    public void directoryRemoved(String path) {
        this.fileRemoved(path);
    }

    public void fileChanged(String path) {
        logger.fine("TODO FileDirNode.fileChanged: " + path);
    }

    public void fileInserted(String path) {
        String subPath = this.getSubPath(path);
        int from = 0;
        String sep = File.separator;
        FileDirNode fc = this;
        while (true) {
            int x;
            if ((x = subPath.indexOf(sep, from)) < 0) {
                File file = new File(path);
                if (!file.exists()) break;
                if (file.isFile()) {
                    fc.add(new FileLeafNode(file));
                    break;
                }
                fc.add(new FileDirNode(file));
                break;
            }
            String childName = subPath.substring(from, x);
            FileContext child = fc.getChild(childName);
            if (child == null) {
                logger.fine("Error: child not found: " + childName + " => " + fc);
                break;
            }
            from = x + sep.length();
            fc = child;
        }
    }

    public void fileRemoved(String path) {
        logger.fine("FileDirNode.fileRemoved: " + path);
        String subPath = this.getSubPath(path);
        int from = 0;
        String sep = File.separator;
        FileDirNode fc = this;
        while (true) {
            FileContext child;
            String childName;
            int x;
            if ((x = subPath.indexOf(sep, from)) < 0) {
                childName = subPath.substring(from);
                child = fc.getChild(childName);
                logger.fine("Removing child: " + childName + " => " + child);
                if (child != null) {
                    fc.remove(child);
                    break;
                }
                logger.fine("Error: child not found: " + childName + " => " + fc + " / children=" + fc.size());
                Iterator i = fc.iterator();
                while (i.hasNext()) {
                    logger.fine(" - " + i.next());
                }
                break;
            }
            childName = subPath.substring(from, x);
            child = fc.getChild(childName);
            if (child == null) {
                logger.fine("Error: child not found: " + childName + " => " + fc);
                break;
            }
            from = x + sep.length();
            fc = child;
        }
    }

    public URL getURL() throws MalformedURLException {
        return Tools.getFileURL((File)this.file);
    }

    public URI getURI() {
        return Tools.getFileURI((File)this.file);
    }

    protected String getSubPath(String path) {
        if (path == null) {
            return null;
        }
        String thisPath = this.getPath();
        if (thisPath == null) {
            return path;
        }
        if (path.startsWith(thisPath)) {
            String subPath = path.substring(thisPath.length());
            if (subPath.startsWith(File.separator)) {
                subPath = subPath.substring(File.separator.length());
            }
            return subPath;
        }
        return path;
    }

    @Override
    public boolean equals(Object obj) {
        FileContext fc;
        String path;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof FileDirNode && (path = (fc = (FileContext)obj).getPath()) != null) {
            return path.equals(this.getPath());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.file == null ? 0 : this.file.getPath().hashCode();
    }

    @Override
    public boolean remove(Object targetChild) {
        logger.fine("DEBUG: remove file: " + targetChild);
        return super.remove(targetChild);
    }

    public static class NamedDirOnlyNode
    extends NamedFileDirNode {
        private static final long serialVersionUID = -8321817459292966056L;

        public NamedDirOnlyNode(File f, String name) {
            super(f, name);
        }

        public NamedDirOnlyNode(File f) {
            super(f);
        }

        @Override
        protected File[] listFiles(File dir) {
            File[] files = super.listFiles(dir);
            ArrayList<File> dirs = new ArrayList<File>();
            if (files != null) {
                for (int c = 0; c < files.length; ++c) {
                    File f = files[c];
                    if (!f.isDirectory()) continue;
                    dirs.add(f);
                }
            }
            return dirs.toArray(new File[dirs.size()]);
        }

        @Override
        protected FileContext createFileContext(File f) {
            if (f.exists() && f.isFile()) {
                return new FileLeafNode(f);
            }
            return new DirOnlyNode(f);
        }
    }

    public static class DirOnlyNode
    extends FileDirNode {
        private static final long serialVersionUID = -2986793408551438955L;

        public DirOnlyNode(File file) {
            super(file);
        }

        @Override
        protected File[] listFiles(File dir) {
            File[] files = super.listFiles(dir);
            ArrayList<File> dirs = new ArrayList<File>();
            if (files != null) {
                for (int c = 0; c < files.length; ++c) {
                    File f = files[c];
                    if (!f.isDirectory()) continue;
                    dirs.add(f);
                }
            }
            return dirs.toArray(new File[dirs.size()]);
        }

        @Override
        protected FileContext createFileContext(File f) {
            if (f.exists() && f.isFile()) {
                return new FileLeafNode(f);
            }
            return new DirOnlyNode(f);
        }

        @Override
        public void fileInserted(String path) {
            File file = new File(path);
            if (file.isFile()) {
                return;
            }
            super.fileInserted(path);
        }
    }

    public static class NamedFileDirNode
    extends FileDirNode {
        private static final long serialVersionUID = -7198348056611369618L;
        private String name;
        private transient boolean initialized = false;

        public NamedFileDirNode(File f) {
            super(f);
            this.setName(f.getName());
        }

        public NamedFileDirNode(File f, String name) {
            super(f);
            this.setName(name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        protected synchronized void initNamedFileDirNode() {
            FileManager fm;
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            Platform platform = Platform.getInstance();
            if (platform != null && (fm = platform.getFileManager()) != null) {
                fm.registerFileContext((FileContext)this);
            }
        }

        @Override
        protected void enumerateChildContexts(Collection arg0, boolean arg1) {
            super.enumerateChildContexts(arg0, arg1);
            this.initNamedFileDirNode();
        }

        @Override
        public int hashCode() {
            return this.name == null ? 0 : this.name.hashCode();
        }
    }
}

