/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ext.jinput11;

import com.spacekiller.game2d.InputAxis;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.Rumbler;
import com.spacekiller.game2d.input.AbstractInputAxis;
import com.spacekiller.game2d.input.AbstractInputButton;
import java.util.ArrayList;
import net.java.games.input.Axis;
import net.java.games.input.Controller;

public class JInputJoystickController
implements InputController {
    private Controller stick;
    private Axis ax;
    private Axis ay;
    private Axis[] ab;
    private float x;
    private float y;
    private JInputStickXAxis xAxis;
    private JInputStickYAxis yAxis;
    private JInputStickButton[] buttons;
    private InputAxis[] axes;
    private Rumbler[] rumblers = new Rumbler[0];

    public JInputJoystickController(Controller stick) {
        this.initJInputJoystickController(stick);
    }

    protected void initJInputJoystickController(Controller stick) {
        System.out.println("Joystick-Controller: " + stick);
        if (stick == null) {
            return;
        }
        this.stick = stick;
        Axis[] a = stick.getAxes();
        this.ax = stick.getAxis(Axis.Identifier.X);
        System.out.println("Axis X: " + this.ax);
        if (this.ax == null) {
            throw new NullPointerException("Joystick X-axis not found!");
        }
        this.ay = stick.getAxis(Axis.Identifier.Y);
        System.out.println("Axis Y: " + this.ay);
        if (this.ay == null) {
            throw new NullPointerException("Joystick Y-axis not found!");
        }
        ArrayList<Axis> buttonAxes = new ArrayList<Axis>();
        for (int c = 0; c < a.length; ++c) {
            Axis v = a[c];
            if (v.getIdentifier() != Axis.Identifier.BUTTON) continue;
            buttonAxes.add(v);
        }
        int buttonCount = buttonAxes.size();
        System.out.println("Joystick-Buttons: " + buttonCount);
        this.buttons = new JInputStickButton[buttonCount];
        for (int c = 0; c < buttonCount; ++c) {
            this.buttons[c] = new JInputStickButton("button" + (c + 1), (Axis)buttonAxes.get(c));
        }
        ArrayList<Object> allAxes = new ArrayList<Object>();
        this.xAxis = new JInputStickXAxis("X");
        allAxes.add((Object)this.xAxis);
        this.yAxis = new JInputStickYAxis("Y");
        allAxes.add((Object)this.yAxis);
        for (int c = 0; c < buttonCount; ++c) {
            allAxes.add((Object)this.buttons[c]);
        }
        this.axes = new InputAxis[allAxes.size()];
        this.axes = allAxes.toArray(this.axes);
        net.java.games.input.Rumbler[] rumbl = stick.getRumblers();
        if (rumbl != null) {
            int numRumblers = rumbl.length;
            System.out.println("Rumblers: " + numRumblers);
            this.rumblers = new Rumbler[numRumblers];
            for (int c = 0; c < numRumblers; ++c) {
                this.rumblers[c] = new JInputStickRumbler(rumbl[c]);
            }
        }
    }

    public int getAxisCount() {
        return this.axes.length;
    }

    public InputAxis getAxisAt(int i) {
        return this.axes[i];
    }

    public InputAxis getAxisForKey(int keyCode) {
        return null;
    }

    public int getType() {
        return 3;
    }

    public void poll() {
        this.stick.poll();
        this.x = this.ax.getPollData();
        this.y = this.ay.getPollData();
    }

    public int getRumblerCount() {
        return this.rumblers.length;
    }

    public Rumbler getRumblerAt(int i) {
        return this.rumblers[i];
    }

    public String toString() {
        return this.stick.getName();
    }

    protected class JInputStickRumbler
    implements Rumbler {
        private net.java.games.input.Rumbler rumbler;

        public JInputStickRumbler(net.java.games.input.Rumbler rumbler) {
            this.rumbler = rumbler;
        }

        public void rumble(float intensity) {
            this.rumbler.rumble(intensity);
        }
    }

    protected class JInputStickButton
    extends AbstractInputButton {
        private Axis axis;

        public JInputStickButton(String name, Axis axis) {
            super((InputController)JInputJoystickController.this, name, 1000, -1);
            this.axis = axis;
        }

        public boolean isPressed() {
            return this.axis.getPollData() != 0.0f;
        }

        public float getValue() {
            return this.axis.getPollData();
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class JInputStickYAxis
    extends AbstractInputAxis {
        public JInputStickYAxis(String name) {
            super((InputController)JInputJoystickController.this, name, 2001);
        }

        public float getValue() {
            return JInputJoystickController.this.y;
        }

        public boolean isAnalog() {
            return JInputJoystickController.this.ay.isAnalog();
        }

        public boolean isNormalized() {
            return JInputJoystickController.this.ay.isNormalized();
        }

        public boolean isRelative() {
            return true;
        }

        public boolean isPolling() {
            return true;
        }
    }

    protected class JInputStickXAxis
    extends AbstractInputAxis {
        public JInputStickXAxis(String name) {
            super((InputController)JInputJoystickController.this, name, 2000);
        }

        public float getValue() {
            return JInputJoystickController.this.x;
        }

        public boolean isAnalog() {
            return JInputJoystickController.this.ax.isAnalog();
        }

        public boolean isNormalized() {
            return JInputJoystickController.this.ax.isNormalized();
        }

        public boolean isRelative() {
            return true;
        }

        public boolean isPolling() {
            return true;
        }
    }
}

